/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.EmptyQuery;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import com.intellij.util.QueryFactory;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCObjectTypeContext;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import org.jetbrains.annotations.NotNull;

public final class OCMemberInheritorsSearch<T extends OCMemberSymbol>
extends QueryFactory<T, SearchParameters> {
    public static final OCMemberInheritorsSearch INSTANCE = new OCMemberInheritorsSearch();

    public static <T extends OCMemberSymbol> SearchParameters<T> getParameters(T symbol, @NotNull Project project) {
        if (symbol == null) {
            return new SearchParameters();
        }
        return new SearchParameters(project, GlobalSearchScope.allScope((Project)project), symbol.getName(), symbol.getParent(), symbol.getClass(), symbol instanceof OCMethodSymbol || symbol instanceof OCPropertySymbol ? (symbol.isStatic() ? OCObjectTypeContext.StaticMode.STATIC : OCObjectTypeContext.StaticMode.INSTANCE) : OCObjectTypeContext.StaticMode.NO_MATTER);
    }

    public static SearchParameters<OCMethodSymbol> getParameters(OCMethod method) {
        Project project = method.getProject();
        return new SearchParameters<OCMethodSymbol>(project, GlobalSearchScope.allScope((Project)project), method.getSelector(), (OCClassSymbol)ReadAction.compute(() -> method.getContainingClass().getSymbol()), OCMethodSymbol.class, method.isInstanceMethod() ? OCObjectTypeContext.StaticMode.INSTANCE : OCObjectTypeContext.StaticMode.STATIC);
    }

    public static <T extends OCMemberSymbol> SearchParameters<T> getParameters(String selectorName, OCClassSymbol receiverSymbol, Project project, Class<? extends T> memberClass, OCObjectTypeContext.StaticMode staticMode) {
        return new SearchParameters<T>(project, GlobalSearchScope.allScope((Project)project), selectorName, receiverSymbol, memberClass, staticMode);
    }

    public static <T extends OCMemberSymbol> Query<T> search(SearchParameters<T> searchParameters) {
        if (searchParameters.getSelectorName() == null) {
            return new EmptyQuery();
        }
        return INSTANCE.createQuery(searchParameters);
    }

    private OCMemberInheritorsSearch() {
    }

    static {
        INSTANCE.registerExecutor((QueryExecutor)new DefaultExecutor());
    }

    private static class DefaultExecutor
    extends QueryExecutorBase<OCMemberSymbol, SearchParameters> {
        private DefaultExecutor() {
        }

        public void processQuery(@NotNull SearchParameters p, @NotNull Processor<? super OCMemberSymbol> consumer) {
            GlobalSearchScope scope = p.getScope();
            OCCommonProcessors.OrderedProcessor consumerFinal = p.isInterfacesThenImplementations() ? new OCCommonProcessors.OrderedProcessor(consumer, true, methodSymbol -> methodSymbol.getParent().getKind() != OCSymbolKind.IMPLEMENTATION, Conditions.alwaysTrue()) : (p.isImplementationsThenInterfaces() ? new OCCommonProcessors.OrderedProcessor(consumer, true, methodSymbol -> methodSymbol.getParent().getKind() == OCSymbolKind.IMPLEMENTATION, Conditions.alwaysTrue()) : consumer);
            Processor processor = symbol -> {
                ProgressManager.checkCanceled();
                if (!p.getMemberClass().isAssignableFrom(symbol.getClass()) || symbol.getContainingFile() == null || !scope.contains(symbol.getContainingFile()) || (symbol instanceof OCMethodSymbol || symbol instanceof OCPropertySymbol) && !p.getStaticMode().fitsStaticness((OCMemberSymbol)symbol)) {
                    return true;
                }
                OCMemberSymbol method = (OCMemberSymbol)symbol;
                OCClassSymbol parent = method.getParent();
                OCClassSymbol receiverClass = p.getReceiverClass();
                if (!p.isIncludeInterfaceAndProtocolResponders() && (parent instanceof OCInterfaceSymbol || parent instanceof OCProtocolSymbol)) {
                    return true;
                }
                if (receiverClass == null || !p.isIncludeSelfImplementation() && parent.isSameClass(receiverClass)) {
                    return true;
                }
                if (p.isInheritors() && parent.isSubclass(receiverClass, p.getProject()) && (p.isIncludeFromID() || !parent.getName().equals("id")) || p.isAncestors() && (!p.isInheritors() || receiverClass.isSubclass(parent, p.getProject())) && (p.isIncludeFromID() || !receiverClass.getName().equals("id"))) {
                    return consumerFinal.process(method);
                }
                return true;
            };
            if (p.isAncestors() && !p.isInheritors()) {
                OCType type;
                OCClassSymbol receiverClass = p.getReceiverClass();
                OCType oCType = type = receiverClass != null ? receiverClass.getResolvedType(OCResolveContext.forSymbol(receiverClass, p.getProject())) : null;
                if (type instanceof OCObjectType) {
                    ((OCObjectType)type).processMembers(p.getSelectorName(), p.getMemberClass(), processor);
                }
            } else {
                OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(p.getProject(), (Processor<? super OCSymbol>)processor, p.getSelectorName());
            }
            if (consumerFinal instanceof OCCommonProcessors.OrderedProcessor) {
                consumerFinal.finish();
            }
        }
    }

    public static final class SearchParameters<T extends OCMemberSymbol> {
        private GlobalSearchScope myScope;
        private Project myProject;
        private String mySelectorName;
        private OCObjectTypeContext.StaticMode myStaticMode;
        private OCClassSymbol myReceiverClass;
        private boolean myIncludeInterfaceAndProtocolResponders = true;
        private boolean myIncludeSelfImplementation;
        private boolean myInterfacesThenImplementations;
        private boolean myImplementationsThenInterfaces;
        private boolean myIncludeFromID;
        private boolean myInheritors = true;
        private boolean myAncestors;
        private Class<? extends T> myMemberClass;

        public Project getProject() {
            return this.myProject;
        }

        public GlobalSearchScope getScope() {
            return this.myScope;
        }

        public boolean isIncludeInterfaceAndProtocolResponders() {
            return this.myIncludeInterfaceAndProtocolResponders;
        }

        public boolean isIncludeSelfImplementation() {
            return this.myIncludeSelfImplementation;
        }

        public boolean isImplementationsThenInterfaces() {
            return this.myImplementationsThenInterfaces;
        }

        public boolean isInterfacesThenImplementations() {
            return this.myInterfacesThenImplementations;
        }

        public boolean isIncludeFromID() {
            return this.myIncludeFromID;
        }

        public boolean isAncestors() {
            return this.myAncestors;
        }

        public boolean isInheritors() {
            return this.myInheritors;
        }

        public String getSelectorName() {
            return this.mySelectorName;
        }

        public OCClassSymbol getReceiverClass() {
            return this.myReceiverClass;
        }

        public void setAncestors(boolean ancestors) {
            this.myAncestors = ancestors;
        }

        public void setImplementationsThenInterfaces(boolean implementationsThenInterfaces) {
            this.myImplementationsThenInterfaces = implementationsThenInterfaces;
        }

        public void setIncludeInterfaceAndProtocolResponders(boolean includeInterfaceAndProtocolResponders) {
            this.myIncludeInterfaceAndProtocolResponders = includeInterfaceAndProtocolResponders;
        }

        public void setIncludeSelfImplementation(boolean includeSelfImplementation) {
            this.myIncludeSelfImplementation = includeSelfImplementation;
        }

        public void setInheritors(boolean inheritors) {
            this.myInheritors = inheritors;
        }

        public void setInterfacesThenImplementations(boolean interfacesThenImplementations) {
            this.myInterfacesThenImplementations = interfacesThenImplementations;
        }

        public void setIncludeFromID(boolean includeFromID) {
            this.myIncludeFromID = includeFromID;
        }

        public Class<? extends OCMemberSymbol> getMemberClass() {
            return this.myMemberClass;
        }

        public OCObjectTypeContext.StaticMode getStaticMode() {
            return this.myStaticMode;
        }

        private SearchParameters(Project project, GlobalSearchScope scope, String selectorName, OCClassSymbol receiverClass, Class<? extends T> memberClass, OCObjectTypeContext.StaticMode staticMode) {
            this.myProject = project;
            this.myScope = scope;
            this.mySelectorName = selectorName;
            this.myReceiverClass = receiverClass;
            this.myMemberClass = memberClass;
            this.myStaticMode = staticMode;
        }

        private SearchParameters() {
        }
    }
}

