/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.search.PsiSearchHelperImpl;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.search.OCStructInheritorsSearch;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityAfterResolvingVisitor;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class OCFunctionReferenceSearch
implements QueryExecutor<PsiReference, ReferencesSearch.SearchParameters> {
    private final boolean myFindAllPotentialCalls;
    private static final EnumSet<PsiSearchHelperImpl.Options> OPERATOR = EnumSet.of(PsiSearchHelperImpl.Options.CASE_SENSITIVE_SEARCH, PsiSearchHelperImpl.Options.PROCESS_INJECTED_PSI);
    private static final EnumSet<PsiSearchHelperImpl.Options> ORDINAL = EnumSet.of(PsiSearchHelperImpl.Options.PROCESS_ONLY_JAVA_IDENTIFIERS_IF_POSSIBLE, PsiSearchHelperImpl.Options.CASE_SENSITIVE_SEARCH, PsiSearchHelperImpl.Options.PROCESS_INJECTED_PSI);

    public OCFunctionReferenceSearch() {
        this(false);
    }

    public OCFunctionReferenceSearch(boolean findPotentialAllPotentialCalls) {
        this.myFindAllPotentialCalls = findPotentialAllPotentialCalls;
    }

    public boolean execute(@NotNull ReferencesSearch.SearchParameters p, @NotNull Processor<? super PsiReference> consumer) {
        PsiElement element = p.getElementToSearch();
        if (element instanceof OCDeclarator) {
            element = (PsiElement)ReadAction.compute(() -> ((PsiElement)element).getParent());
        }
        if (!(element instanceof OCFunctionDeclaration)) {
            return true;
        }
        OCFunctionDeclaration method = (OCFunctionDeclaration)element;
        PsiSearchHelper helper = (PsiSearchHelper)ReadAction.compute(() -> {
            Project project = method.getProject();
            if (project.isDisposed()) {
                throw new ProcessCanceledException();
            }
            return PsiSearchHelper.getInstance((Project)project);
        });
        SearchParameters searchParameters = (SearchParameters)ReadAction.compute(() -> new SearchParameters(method.getName(), method.isOperator() ? OPERATOR : ORDINAL));
        if (searchParameters.mySearchWord == null || searchParameters.mySearchWord.isEmpty()) {
            return true;
        }
        MyOccurenceProcessor processor = (MyOccurenceProcessor)ReadAction.compute(() -> new MyOccurenceProcessor(method, consumer, this.myFindAllPotentialCalls));
        return ((PsiSearchHelperImpl)helper).processElementsWithWord(p.getEffectiveSearchScope(), searchParameters.mySearchWord, (short)1, searchParameters.myOptions, null, p.getOptimizer().getSearchSession(), (TextOccurenceProcessor)processor);
    }

    public static boolean isCallViaReference(OCExpression qualifier) {
        if ((qualifier = OCParenthesesUtils.diveIntoParenthesesAndCasts(qualifier)) instanceof OCUnaryExpression && ((OCUnaryExpression)qualifier).getOperationSign() == OCTokenTypes.MUL) {
            return true;
        }
        if (qualifier != null) {
            OCType type = qualifier.getResolvedType();
            return type instanceof OCPointerType || type instanceof OCCppReferenceType;
        }
        return false;
    }

    private static class MyOccurenceProcessor
    implements TextOccurenceProcessor {
        private final OCSymbolWithQualifiedName myMethodSymbol;
        private final Processor<? super PsiReference> myConsumer;
        private final boolean myFindAllPotentialCalls;
        private final OCType myResolvedType;
        private final Collection<OCQualifiedName> myPossibleOwners;
        private final OCQualifiedName myOwner;

        MyOccurenceProcessor(OCFunctionDeclaration function, Processor<? super PsiReference> consumer, boolean findAllPotentialCalls) {
            this.myMethodSymbol = (OCSymbolWithQualifiedName)function.getSymbol();
            this.myConsumer = consumer;
            this.myFindAllPotentialCalls = findAllPotentialCalls;
            if (this.myMethodSymbol != null) {
                OCResolveContext context = OCResolveContext.forPsi(function);
                this.myResolvedType = this.myMethodSymbol.getResolvedType(context);
                OCSymbolWithQualifiedName owner = this.myMethodSymbol.getResolvedOwner(context);
                if (owner instanceof OCStructSymbol) {
                    NullableFunction getNameFunction = symbol -> symbol.getResolvedQualifiedName(context);
                    this.myOwner = (OCQualifiedName)getNameFunction.fun((Object)((OCStructSymbol)owner));
                    if (this.myFindAllPotentialCalls) {
                        CommonProcessors.CollectProcessor collectProcessor = new CommonProcessors.CollectProcessor();
                        collectProcessor.process((Object)((OCStructSymbol)owner));
                        MyOccurenceProcessor.processAncestors((OCStructSymbol)owner, (Processor<OCStructSymbol>)collectProcessor, context);
                        this.myPossibleOwners = ContainerUtil.mapNotNull((Collection)collectProcessor.getResults(), (Function)getNameFunction);
                    } else {
                        this.myPossibleOwners = ContainerUtil.mapNotNull((Collection)OCStructInheritorsSearch.search((OCStructSymbol)owner, function).findAll(), (Function)getNameFunction);
                    }
                } else {
                    this.myOwner = OCQualifiedName.GLOBAL;
                    this.myPossibleOwners = Collections.emptySet();
                }
            } else {
                this.myOwner = null;
                this.myResolvedType = null;
                this.myPossibleOwners = Collections.emptySet();
            }
        }

        public static boolean processAncestors(OCStructSymbol substruct, Processor<OCStructSymbol> processor, @NotNull OCResolveContext context) {
            HashSet<OCStructSymbol> processed = new HashSet<OCStructSymbol>();
            Stack workset = new Stack();
            workset.add((Object)substruct);
            while (!workset.isEmpty()) {
                OCStructSymbol symbol = (OCStructSymbol)workset.pop();
                if (processed.contains(symbol)) continue;
                processed.add(symbol);
                symbol.processBaseClasses(context, (symbol1, visibility) -> {
                    if (symbol1 instanceof OCStructSymbol) {
                        workset.add((Object)((OCStructSymbol)symbol1));
                        if (!processor.process((Object)((OCStructSymbol)symbol1))) {
                            return false;
                        }
                    }
                    return true;
                });
            }
            return true;
        }

        public boolean execute(@NotNull PsiElement element, int offsetInElement) {
            OCSymbol symbol = null;
            boolean isVirtual = false;
            PsiReference maybeOperatorRef = element.getReference();
            if (maybeOperatorRef instanceof OCOperatorReference) {
                symbol = (OCSymbol)((OCOperatorReference)maybeOperatorRef).resolveToSymbol();
            } else if (element instanceof OCReferenceElement) {
                symbol = ((OCReferenceElement)element).resolveToSymbol();
                isVirtual = ((OCReferenceElement)element).getNamespaceQualifier() == null;
            } else if (element instanceof OCQualifiedExpression) {
                symbol = ((OCQualifiedExpression)element).resolveToSymbol();
                isVirtual = OCFunctionReferenceSearch.isCallViaReference(((OCQualifiedExpression)element).getQualifier());
            }
            if (symbol instanceof OCFunctionSymbol) {
                if (symbol.equals(this.myMethodSymbol)) {
                    return this.myConsumer.process((Object)element.getReference());
                }
                OCQualifiedName qualifiedName = ((OCFunctionSymbol)symbol).getResolvedQualifiedName(OCResolveContext.forPsi(element));
                if (qualifiedName != null) {
                    OCTypeEqualityAfterResolvingVisitor visitor = new OCTypeEqualityAfterResolvingVisitor(this.myResolvedType, true, true, true, true, OCResolveContext.forSymbol(symbol, element.getProject()));
                    if (this.myOwner != null && this.myOwner.equals(qualifiedName.getQualifier())) {
                        if (symbol.getType().accept(visitor).booleanValue()) {
                            return this.myConsumer.process((Object)element.getReference());
                        }
                    } else if (this.myPossibleOwners.contains(qualifiedName.getQualifier())) {
                        if (!this.myFindAllPotentialCalls) {
                            if (symbol.getType().accept(visitor).booleanValue()) {
                                return this.myConsumer.process((Object)element.getReference());
                            }
                        } else if (isVirtual) {
                            OCSymbol contextSymbol;
                            OCCallable context = (OCCallable)PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{OCCallable.class});
                            if (context != null && (contextSymbol = context.getSymbol()) instanceof OCFunctionSymbol) {
                                OCFunctionSymbol functionSymbol = (OCFunctionSymbol)contextSymbol;
                                boolean bl = isVirtual = !functionSymbol.isCppDestructor() && !functionSymbol.isCppConstructor();
                            }
                            if (isVirtual && symbol.getType().accept(visitor).booleanValue()) {
                                return this.myConsumer.process((Object)element.getReference());
                            }
                        }
                    }
                }
            }
            return true;
        }
    }

    private static class SearchParameters {
        String mySearchWord;
        EnumSet<PsiSearchHelperImpl.Options> myOptions;

        SearchParameters(String searchWord, EnumSet<PsiSearchHelperImpl.Options> options) {
            this.mySearchWord = searchWord;
            this.myOptions = options;
        }
    }
}

