/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import com.intellij.util.QueryFactory;
import com.intellij.util.containers.Stack;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.psi.OCProtocol;
import com.jetbrains.cidr.lang.search.OCDirectInheritorsSearch;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCClassInheritorsSearch
extends QueryFactory<OCClassSymbol, SearchParameters> {
    private static final OCClassInheritorsSearch INSTANCE = new OCClassInheritorsSearch();

    private OCClassInheritorsSearch() {
    }

    @NotNull
    public static Query<OCClassSymbol> search(@NotNull OCClassDeclaration aClass) {
        Project project = aClass.getProject();
        return OCClassInheritorsSearch.search(aClass.getName(), aClass.getSymbol(), aClass instanceof OCProtocol, (SearchScope)GlobalSearchScope.allScope((Project)project), project, aClass instanceof OCImplementation);
    }

    @NotNull
    public static Query<OCClassSymbol> search(OCClassSymbol aClass, @NotNull Project project) {
        return OCClassInheritorsSearch.search(aClass.getName(), aClass, aClass instanceof OCProtocolSymbol, (SearchScope)GlobalSearchScope.allScope((Project)project), project, aClass instanceof OCImplementationSymbol);
    }

    @NotNull
    public static Query<OCClassSymbol> search(@Nullable String className, boolean isProtocol, @NotNull SearchScope scope, @NotNull Project project, boolean myPreferImplementations) {
        return OCClassInheritorsSearch.search(className, null, isProtocol, scope, project, myPreferImplementations);
    }

    @NotNull
    private static Query<OCClassSymbol> search(@Nullable String className, @Nullable OCClassSymbol symbol, boolean isProtocol, @NotNull SearchScope scope, @NotNull Project project, boolean myPreferImplementations) {
        return INSTANCE.createQuery(new SearchParameters(scope, className, symbol, isProtocol, project, myPreferImplementations));
    }

    static {
        INSTANCE.registerExecutor((QueryExecutor)new DefaultExecutor());
    }

    private static class SymbolAndName {
        @Nullable
        final String name;
        @Nullable
        final OCClassSymbol symbol;
        final boolean isProtocol;

        private SymbolAndName(@Nullable String name, @Nullable OCClassSymbol symbol, boolean isProtocol) {
            this.name = name;
            this.symbol = symbol;
            this.isProtocol = isProtocol;
        }

        Pair<String, Boolean> getNameAndProtocol() {
            return new Pair((Object)this.name, (Object)this.isProtocol);
        }
    }

    private static class DefaultExecutor
    extends QueryExecutorBase<OCClassSymbol, SearchParameters> {
        private DefaultExecutor() {
        }

        public void processQuery(@NotNull SearchParameters p, @NotNull Processor<? super OCClassSymbol> consumer) {
            SearchScope scope = p.getScope();
            Project project = p.getProject();
            Stack names = new Stack();
            HashSet<Pair<String, Boolean>> processed = new HashSet<Pair<String, Boolean>>();
            names.push((Object)new SymbolAndName(p.getClassName(), p.getSymbol(), p.isProtocol()));
            while (!names.isEmpty()) {
                ProgressManager.checkCanceled();
                SymbolAndName symbolAndName = (SymbolAndName)names.pop();
                if (!processed.add(symbolAndName.getNameAndProtocol())) continue;
                Query<OCClassSymbol> search = OCDirectInheritorsSearch.search(symbolAndName.name, symbolAndName.symbol, (SearchScope)GlobalSearchScope.allScope((Project)project), project, symbolAndName.isProtocol, p.isPreferImplementations());
                search.forEach(symbol -> {
                    names.push((Object)new SymbolAndName(symbol.getName(), (OCClassSymbol)symbol, symbol instanceof OCProtocolSymbol));
                    VirtualFile file = symbol.getContainingFile();
                    return file == null || !scope.contains(file) || consumer.process(symbol);
                });
            }
        }
    }

    public static class SearchParameters {
        private final SearchScope myScope;
        private final String myClassName;
        private final OCClassSymbol mySymbol;
        private final Project myProject;
        private final boolean myProtocol;
        private final boolean myPreferImplementations;

        public SearchParameters(@NotNull SearchScope scope, @Nullable String className, @Nullable OCClassSymbol symbol, boolean protocol, @NotNull Project project, boolean preferImplementations) {
            this.myScope = scope;
            this.myClassName = className;
            this.mySymbol = symbol;
            this.myProtocol = protocol;
            this.myProject = project;
            this.myPreferImplementations = preferImplementations;
        }

        @NotNull
        public SearchScope getScope() {
            return this.myScope;
        }

        @Nullable
        public String getClassName() {
            return this.myClassName;
        }

        @NotNull
        public Project getProject() {
            return this.myProject;
        }

        public boolean isProtocol() {
            return this.myProtocol;
        }

        public boolean isPreferImplementations() {
            return this.myPreferImplementations;
        }

        @Nullable
        public OCClassSymbol getSymbol() {
            return this.mySymbol;
        }
    }
}

