/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.resolve.references.kvc;

import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCMessageArgument;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class KVCUtil {
    static KVCMethod[] KVC_METHODS = new KVCMethod[]{new KVCMethod("valueForKey:", KVCType.KEY, 0), new KVCMethod("valueForKeyPath:", KVCType.KEY_PATH, 0), new KVCMethod("mutableArrayValueForKey:", KVCType.KEY, 0), new KVCMethod("mutableArrayValueForKeyPath:", KVCType.KEY_PATH, 0), new KVCMethod("mutableSetValueForKey:", KVCType.KEY, 0), new KVCMethod("mutableSetValueForKeyPath:", KVCType.KEY_PATH, 0), new KVCMethod("setValue:forKeyPath:", KVCType.KEY_PATH, 1), new KVCMethod("setNilValueForKey:", KVCType.KEY, 0), new KVCMethod("setValue:forKey:", KVCType.KEY, 1), new KVCMethod("addObserver:forKeyPath:options:context:", KVCType.KEY_PATH, 1), new KVCMethod("removeObserver:forKeyPath:", KVCType.KEY_PATH, 1), new KVCMethod("removeObserver:forKeyPath:context:", KVCType.KEY_PATH, 1), new KVCMethod("willChangeValueForKey:", KVCType.KEY, 0), new KVCMethod("didChangeValueForKey:", KVCType.KEY, 0), new KVCMethod("willChange:valuesAtIndexes:forKey:", KVCType.KEY, 2), new KVCMethod("didChange:valuesAtIndexes:forKey:", KVCType.KEY, 2), new KVCMethod("willChangeValueForKey:withSetMutation:usingObjects:", KVCType.KEY, 0), new KVCMethod("didChangeValueForKey:withSetMutation:usingObjects:", KVCType.KEY, 0)};
    private static final String[] EXCLUDED_CLASSES = new String[]{"NSDictionary", "NSArray", "NSUserDefaults", "NSManagedObject"};
    private static final String[] EXCLUDED_PAIRS = new String[]{"NSManagedObject", "timeStamp"};

    public static boolean isValidKeyForReferring(@NotNull String key) {
        return !key.contains("@");
    }

    public static boolean isValidPairForReferring(@Nullable OCClassSymbol aClass, @NotNull String key, @NotNull OCFile context) {
        if (!KVCUtil.isValidKeyForReferring(key)) {
            return false;
        }
        if (aClass == null) {
            return false;
        }
        if (aClass.getType().resolve(context).isPointerToID()) {
            return false;
        }
        if (KVCUtil.classIsKindOfClasses(EXCLUDED_CLASSES, aClass, context)) {
            return false;
        }
        for (int i = 0; i < EXCLUDED_PAIRS.length; i += 2) {
            String forbiddenClass = EXCLUDED_PAIRS[i];
            String forbiddenKey = EXCLUDED_PAIRS[i + 1];
            if (!forbiddenKey.equals(key) || KVCUtil.checkClassPair(aClass, forbiddenClass, context)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkClassPair(OCClassSymbol aClass, String forbiddenClass, @NotNull OCFile context) {
        return !KVCUtil.classIsKindOfClasses(new String[]{forbiddenClass}, aClass, context);
    }

    @Nullable
    private static KVCMethod getKVCMethod(String selector, KVCType type) {
        for (KVCMethod kvcMethod : KVC_METHODS) {
            if (!kvcMethod.getMessageSelector().equals(selector) || kvcMethod.getType() != type) continue;
            return kvcMethod;
        }
        return null;
    }

    private KVCUtil() {
    }

    public static boolean isLiteralOnRightPlace(@NotNull OCLiteralExpression literal, @NotNull OCSendMessageExpression sendMessageExpression) {
        String selector = sendMessageExpression.getMessageSelector();
        int index = -1;
        for (KVCMethod kvcMethod : KVC_METHODS) {
            if (!kvcMethod.getMessageSelector().equals(selector)) continue;
            index = kvcMethod.getArgumentIndex();
            break;
        }
        int i = 0;
        for (OCMessageArgument argument : sendMessageExpression.getArguments()) {
            if (argument.getArgumentExpression() == literal && i == index) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean classIsKindOfClasses(String[] classes, OCClassSymbol classSymbol, @NotNull OCFile context) {
        OCType resolve = classSymbol.getType().resolve(context);
        return resolve instanceof OCObjectType && KVCUtil.findAncestorOfClass((OCObjectType)resolve, classes, context) != null;
    }

    @Nullable
    private static OCObjectType findAncestorOfClass(@NotNull OCObjectType decl, String @NotNull [] classes, @NotNull PsiElement context) {
        String name = decl.getName(context);
        for (String aClass : classes) {
            if (!aClass.equals(name)) continue;
            return decl;
        }
        OCObjectType superType = decl.getSuperType();
        if (superType != null) {
            return KVCUtil.findAncestorOfClass(superType, classes, context);
        }
        return null;
    }

    public static boolean isKVCMethod(String messageSelector, KVCType type) {
        return KVCUtil.getKVCMethod(messageSelector, type) != null;
    }

    @Nullable
    public static OCClassSymbol getReceiverClass(OCType receiverType, @NotNull PsiElement context) {
        OCType refType;
        if (receiverType instanceof OCPointerType && (refType = ((OCPointerType)receiverType).getRefType().resolve(context)) instanceof OCObjectType) {
            return ((OCObjectType)refType).getClassSymbol();
        }
        return null;
    }

    public static enum KVCType {
        KEY,
        KEY_PATH;

    }

    private static final class KVCMethod {
        private String myMessageSelector;
        private KVCType myType;
        private int myArgumentIndex;

        public String getMessageSelector() {
            return this.myMessageSelector;
        }

        public KVCType getType() {
            return this.myType;
        }

        public int getArgumentIndex() {
            return this.myArgumentIndex;
        }

        private KVCMethod(String messageSelector, KVCType type, int argumentIndex) {
            this.myMessageSelector = messageSelector;
            this.myType = type;
            this.myArgumentIndex = argumentIndex;
        }
    }
}

