/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.resolve.references;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.jetbrains.cidr.lang.daemon.clang.ExternalResolveUtils;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiCachingReferenceBase<T extends PsiElement>
extends PsiReferenceBase<T> {
    public PsiCachingReferenceBase(T element, boolean soft) {
        super(element, soft);
    }

    public PsiElement resolve() {
        try {
            ExternalResolveUtils.prohibitClangResolve();
            PsiElement psiElement = (PsiElement)ResolveCache.getInstance((Project)this.getElement().getProject()).resolveWithCaching((PsiReference)this, (ResolveCache.AbstractResolver)MyResolver.INSTANCE, false, false);
            return psiElement;
        }
        finally {
            ExternalResolveUtils.allowClangResolve();
        }
    }

    @Nullable
    public abstract PsiElement resolveInner();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        PsiCachingReferenceBase reference = (PsiCachingReferenceBase)((Object)o);
        return this.getElement().equals(reference.getElement()) && this.getRangeInElement().equals((Object)reference.getRangeInElement()) && this.mySoft == reference.mySoft;
    }

    public int hashCode() {
        return Objects.hash(this.getElement().hashCode(), this.getRangeInElement().hashCode(), this.mySoft);
    }

    private static class MyResolver
    implements ResolveCache.Resolver {
        private static final MyResolver INSTANCE = new MyResolver();

        private MyResolver() {
        }

        @Nullable
        public PsiElement resolve(@NotNull PsiReference ref, boolean incompleteCode) {
            return ((PsiCachingReferenceBase)ref).resolveInner();
        }
    }
}

