/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.resolve.references;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.suggested.UtilsKt;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.ui.PlatformColors;
import com.jetbrains.cidr.EscapeUtil;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.editor.completion.SymbolLookupBuilderUtil;
import com.jetbrains.cidr.lang.psi.OCLocalizedString;
import com.jetbrains.cidr.lang.psi.OCStringLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCStringsFile;
import com.jetbrains.cidr.lang.resolve.references.OCResourceFilesProvider;
import com.jetbrains.cidr.lang.resolve.references.OCResourceReference;
import com.jetbrains.cidr.lang.resolve.references.PsiCachingReferenceBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCStringResourceReference
extends PsiCachingReferenceBase<PsiElement>
implements OCResourceReference {
    public static final String DEFAULT_TABLE = "Localizable";
    public static final String DEFAULT_TABLE_FILE_NAME = "Localizable.strings";
    private static final String STRINGS_EXTENSION = "strings";
    private static final String STRINGS_DICT_EXTENSION = "stringsdict";
    private final String myTable;

    public OCStringResourceReference(@NotNull PsiElement element, @Nullable String table) {
        super(element, false);
        this.myTable = table;
    }

    @NlsSafe
    @Nullable
    public String getTable() {
        return this.myTable;
    }

    @NotNull
    public String getCanonicalText() {
        OCStringLiteralExpression stringLiteral = this.getLiteralExpression();
        if (stringLiteral != null) {
            return EscapeUtil.escapeStringExceptUnicode((String)stringLiteral.getUnescapedLiteralText());
        }
        return StringUtil.unquoteString((String)this.myElement.getText());
    }

    @Nullable
    private OCStringLiteralExpression getLiteralExpression() {
        return (OCStringLiteralExpression)PsiTreeUtil.getNonStrictParentOfType((PsiElement)this.myElement, (Class[])new Class[]{OCStringLiteralExpression.class});
    }

    private static int getLocalizationWeight(OCStringsFile file) {
        String localizationName = StringUtil.toLowerCase((String)OCResourceFilesProvider.getLocalizationName(file));
        return localizationName.equals("en") || localizationName.equals("english") || localizationName.equals("default") ? 1 : 0;
    }

    @Override
    public OCLocalizedString resolveInner() {
        String key = this.getCanonicalText();
        Ref result = Ref.create(null);
        this.processStringFiles((Processor<? super OCStringsFile>)((Processor)file -> {
            OCLocalizedString pair = file.findStringPair(key);
            if (pair != null && (result.isNull() || OCStringResourceReference.getLocalizationWeight(file) > 0)) {
                result.set((Object)pair);
            }
            return true;
        }));
        return (OCLocalizedString)result.get();
    }

    public Object @NotNull [] getVariants() {
        return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    }

    @Override
    @NotNull
    public List<LookupElement> getLookupElements(@NotNull @NlsSafe String openingQuote, @NotNull @NlsSafe String closingQuote) {
        ArrayList<LookupElement> variants = new ArrayList<LookupElement>();
        HashMap weightsMap = new HashMap();
        HashMap pairsMap = new HashMap();
        this.processStringFiles((Processor<? super OCStringsFile>)((Processor)file -> {
            for (OCLocalizedString pair : file.getStringPairs()) {
                int weight = OCStringResourceReference.getLocalizationWeight(file);
                Integer existingWeight = (Integer)weightsMap.get(pair.getKey());
                if (existingWeight != null && existingWeight >= weight) continue;
                weightsMap.put(pair.getKey(), weight);
                pairsMap.put(pair.getKey(), pair);
            }
            return true;
        }));
        for (final OCLocalizedString pair : pairsMap.values()) {
            final String text = openingQuote + pair.getKey() + closingQuote;
            LookupElementBuilder builder2 = SymbolLookupBuilderUtil.forSymbol(pair.getSymbol(), text, pair.getProject());
            builder2 = builder2.withRenderer((LookupElementRenderer)new LookupElementRenderer<LookupElement>(){

                public void renderElement(LookupElement element, LookupElementPresentation presentation) {
                    presentation.setItemText(text);
                    presentation.setTailText("=" + pair.getEscapedValue(), PlatformColors.BLUE);
                    presentation.setTypeText(OCResourceFilesProvider.getLocalizationName(pair.getContainingFile()), AllIcons.FileTypes.Properties);
                }
            });
            variants.add((LookupElement)builder2);
        }
        return variants;
    }

    public boolean processStringFiles(Processor<? super OCStringsFile> processor) {
        for (Map.Entry<String, VirtualFile> entry : OCResourceFilesProvider.getAccessibleResources(this.myElement).entrySet()) {
            OCStringsFile stringsFile;
            PsiFile psiFile;
            String fileName = entry.getKey();
            if (!OCStringResourceReference.isStringFileName(fileName) || this.myTable != null && !this.myTable.equals(OCStringResourceReference.tableName(fileName)) || !((psiFile = this.myElement.getManager().findFile(entry.getValue())) instanceof OCStringsFile) || processor.process((Object)(stringsFile = (OCStringsFile)psiFile))) continue;
            return false;
        }
        return true;
    }

    private static boolean isStringFileName(@NonNls @NotNull String fileName) {
        return FileUtilRt.extensionEquals((String)fileName, (String)STRINGS_EXTENSION) || FileUtilRt.extensionEquals((String)fileName, (String)STRINGS_DICT_EXTENSION);
    }

    @NlsSafe
    @NotNull
    private static String tableName(@NonNls @NotNull String fileName) {
        String withoutLocalization = OCResourceFilesProvider.withoutLocalization(fileName);
        if (withoutLocalization != null) {
            fileName = withoutLocalization;
        }
        return FileUtilRt.getNameWithoutExtension((String)fileName);
    }

    public boolean areAllLanguagesLocalized() {
        return this.getNotLocalizedLanguages().isEmpty();
    }

    @NotNull
    public @NotNull List<@NlsSafe @NotNull String> getNotLocalizedLanguages() {
        HashSet existing = new HashSet();
        HashSet missing = new HashSet();
        String key = this.getCanonicalText();
        this.processStringFiles((Processor<? super OCStringsFile>)((Processor)file -> {
            String name = OCResourceFilesProvider.getLocalizationName(file);
            if (file.findStringPair(key) == null) {
                missing.add(name);
            } else {
                existing.add(name);
            }
            return true;
        }));
        missing.removeAll(existing);
        if (missing.size() > 3) {
            Iterator itr = missing.iterator();
            return Arrays.asList((String)itr.next(), (String)itr.next(), (String)itr.next());
        }
        return new ArrayList<String>(missing);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public PsiElement getElement() {
        return this.myElement;
    }

    @NotNull
    public TextRange getRangeInElement() {
        OCStringLiteralExpression stringLiteral = this.getLiteralExpression();
        if (stringLiteral != null) {
            return stringLiteral.getContentRangeInElement().shiftRight(UtilsKt.getStartOffset((PsiElement)stringLiteral) - UtilsKt.getStartOffset((PsiElement)this.myElement));
        }
        if (this.myElement.getTextLength() >= 2) {
            return new TextRange(1, this.myElement.getTextLength() - 1);
        }
        return new TextRange(0, this.myElement.getTextLength());
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (!(element instanceof OCLocalizedString) || !((OCLocalizedString)element).getKey().equals(this.getCanonicalText())) {
            return false;
        }
        PsiFile file = element.getContainingFile();
        if (!(file instanceof OCStringsFile)) {
            return false;
        }
        if (!OCResourceFilesProvider.isAccessible(this.myElement, file.getVirtualFile())) {
            return false;
        }
        String fileName = file.getName();
        return this.myTable == null || this.myTable.equals(OCStringResourceReference.tableName(fileName));
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        OCStringLiteralExpression stringLiteral = this.getLiteralExpression();
        if (stringLiteral != null) {
            String unescaped = EscapeUtil.unescapeAnsiStringCharacters((String)newElementName);
            stringLiteral.setContent(unescaped);
        } else {
            OCLog.LOG.error("Unexpected class: " + this.myElement.getClass());
        }
        return this.myElement;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OCStringResourceReference reference = (OCStringResourceReference)o;
        return Objects.equals(this.myTable, reference.myTable);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.myTable);
    }
}

