/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.resolve.references;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.CommonProcessors;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.clang.ExternalResolveUtils;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCUDLiteralExpression;
import com.jetbrains.cidr.lang.psi.impl.OCQualifiedExpressionImpl;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.resolve.OCExprValueCategory;
import com.jetbrains.cidr.lang.resolve.OCFunctionGroupSymbol;
import com.jetbrains.cidr.lang.resolve.OCResolveOverloadsUtil;
import com.jetbrains.cidr.lang.resolve.references.OCPolyVariantReferenceImpl;
import com.jetbrains.cidr.lang.resolve.references.OCStatefulReference;
import com.jetbrains.cidr.lang.resolve.v2.TypeProperties;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterTypeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterValueSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCLiteralExpressionSymbol;
import com.jetbrains.cidr.lang.types.CTypeId;
import com.jetbrains.cidr.lang.types.CVQualifiers;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCNumericType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.types.OCVariadicType;
import com.jetbrains.cidr.lang.types.visitors.OCArgumentDepLookupAccumulator;
import com.jetbrains.cidr.lang.types.visitors.OCArrayToPointerChanger;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class OCOperatorReference
extends OCPolyVariantReferenceImpl<OCSymbol>
implements OCStatefulReference {
    private final PsiElement myElement;
    private final String mySign;
    private final OperatorPlacement myPlacement;
    protected final List<? extends OCTypeOwner> myArguments;
    private final List<OCType> myParamTypes;
    private final PsiElement mySignElement;
    private static Key<MyResolver>[] RESOLVER_KEYS = new Key[]{Key.create((String)"RESOLVER_KEY1"), Key.create((String)"RESOLVER_KEY2")};

    public OCOperatorReference(@NotNull PsiElement element, @NotNull String sign, @NotNull OperatorPlacement placement, @Nullable PsiElement signElement, OCExpression ... arguments) {
        this(element, sign, placement, signElement, Arrays.asList(arguments), null);
    }

    public OCOperatorReference(@NotNull PsiElement element, @NotNull String sign, @NotNull OperatorPlacement placement, @Nullable PsiElement signElement, @Nullable List<? extends OCTypeOwner> arguments, @Nullable List<OCType> paramTypes) {
        this.myElement = element;
        this.mySign = sign;
        this.myPlacement = placement;
        this.myArguments = arguments;
        this.myParamTypes = paramTypes;
        this.mySignElement = signElement;
    }

    @NotNull
    public PsiElement getElement() {
        return this.myElement;
    }

    @NotNull
    public TextRange getRangeInElement() {
        return this.mySignElement != null ? OCElementUtil.getRangeInParent(this.mySignElement) : TextRange.EMPTY_RANGE;
    }

    @Override
    public boolean isValid() {
        return !(!this.myElement.isValid() || this.mySignElement != null && !this.mySignElement.isValid() || this.myArguments != null && !ContainerUtil.and(this.myArguments, owner -> !(owner instanceof OCExpression) || ((OCExpression)owner).isValid()));
    }

    @Override
    public PsiElement resolve() {
        return ExternalResolveUtils.findCombined(this, ref -> {
            OCSymbol clangSymbol = ExternalResolveUtils.resolveSymbol(ref);
            if (clangSymbol != null) {
                PsiElement clangElement = clangSymbol.locateDefinition(this.getElement().getProject());
                ExternalResolveUtils.assertFoundSameElement(clangElement, () -> super.resolve());
                return clangElement;
            }
            return null;
        }, ref -> super.resolve());
    }

    @Override
    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element instanceof OCSymbolDeclarator) {
            return ExternalResolveUtils.findCombined(this, ref -> {
                OCSymbol clangSymbol = ExternalResolveUtils.resolveSymbol(this);
                return clangSymbol != null ? Boolean.valueOf(clangSymbol.isSameSymbol((OCSymbol)((OCSymbolDeclarator)element).getSymbol(), element.getProject())) : null;
            }, ref -> super.isReferenceTo(element));
        }
        return super.isReferenceTo(element);
    }

    @NotNull
    public List<OCSymbol> resolveToSymbolsViaClang() {
        return ExternalResolveUtils.findCombined(this, ref -> ExternalResolveUtils.resolveSymbols(ref), ref -> this.resolveToSymbols());
    }

    public boolean isSoft() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OCOperatorReference reference = (OCOperatorReference)o;
        if (this.myElement != null ? !this.myElement.equals(reference.myElement) : reference.myElement != null) {
            return false;
        }
        if (this.mySignElement != null ? !this.mySignElement.equals(reference.mySignElement) : reference.mySignElement != null) {
            return false;
        }
        return !(this.mySign != null ? !this.mySign.equals(reference.mySign) : reference.mySign != null);
    }

    public int hashCode() {
        int result = this.myElement != null ? this.myElement.hashCode() : 0;
        result = 31 * result + (this.mySign != null ? this.mySign.hashCode() : 0);
        result = 31 * result + (this.mySignElement != null ? this.mySignElement.hashCode() : 0);
        return result;
    }

    @Nullable
    public List<? extends OCTypeOwner> getArgumentExpressions() {
        return this.myArguments;
    }

    @NotNull
    public String getCanonicalText() {
        if (this.mySignElement != null) {
            return this.mySignElement.getText();
        }
        return this.mySign;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (this.mySignElement != null) {
            OCElementUtil.replaceWithIdentifier(this.mySignElement, newElementName, this.getElement());
        }
        return this.getElement();
    }

    @Override
    public PsiElement bindToSymbol(@NotNull OCSymbol symbol) {
        return this.handleElementRename(symbol.getName());
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        Object symbol = ((OCSymbolDeclarator)element).getSymbol();
        return symbol != null ? this.bindToSymbol((OCSymbol)symbol) : element;
    }

    @Nullable
    public static OCFunctionSymbol resolveOperator(@NotNull String sign, @NotNull OperatorPlacement placement, @NotNull List<OCType> types, @Nullable List<? extends OCTypeOwner> arguments, @NotNull OCResolveContext context) {
        if (context.getElement() == null) {
            return null;
        }
        OCOperatorReference reference = new OCOperatorReference(context.getElement(), sign, placement, null, arguments, types);
        List symbols = (List)new MyResolver((boolean)true, (boolean)true, (OCResolveContext)context).resolve((OCOperatorReference)reference, (OCResolveContext)context).first;
        OCSymbol symbol = (OCSymbol)ContainerUtil.getFirstItem((List)symbols);
        return symbol instanceof OCFunctionSymbol ? (OCFunctionSymbol)symbol : null;
    }

    @Nullable
    public static OCFunctionSymbol resolveOperator(@NotNull String sign, @NotNull OperatorPlacement placement, @NotNull OCElement element, @NotNull OCStructType struct) {
        OCResolveContext context = OCResolveContext.forPsi(element);
        OCSymbol symbol = (OCSymbol)ContainerUtil.getFirstItem(new MyResolver(true, true, context).doResolveOperator(sign, placement, Collections.singletonList(struct), null, context, element));
        return symbol instanceof OCFunctionSymbol ? (OCFunctionSymbol)symbol : null;
    }

    @Nullable
    public static OCFunctionSymbol resolveDerefOperator(@NotNull OCElement element, @NotNull OCStructType struct) {
        return OCOperatorReference.resolveOperator(OCTokenTypes.DEREF.getName(), OperatorPlacement.INFIX, element, struct);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private List<OCSymbol> resolveToSymbols(@NotNull MyResolver resolver) {
        Pair pair = null;
        ResolveCache resolveCache = ResolveCache.getInstance((Project)this.myElement.getProject());
        if (resolveCache != null) {
            try {
                ExternalResolveUtils.prohibitClangResolve();
                pair = (Pair)resolveCache.resolveWithCaching((PsiReference)this, (ResolveCache.AbstractResolver)resolver, false, false);
            }
            finally {
                ExternalResolveUtils.allowClangResolve();
            }
        }
        return pair != null ? ContainerUtil.filter((Collection)((Collection)pair.getFirst()), symbol -> !(symbol instanceof OCFunctionGroupSymbol) || ((OCFunctionGroupSymbol)symbol).getCause() != OCFunctionGroupSymbol.Cause.NoViable) : Collections.emptyList();
    }

    @NotNull
    public Collection<OCSymbol> resolveToSymbols(boolean resolveOverloads) {
        return this.resolveToSymbols(MyResolver.getInstance(resolveOverloads));
    }

    @NotNull
    @TestOnly
    public Collection<OCSymbol> resolveToSymbols(boolean resolveOverloads, boolean filterAmbigs) {
        Pair<List<OCSymbol>, Boolean> pair = new MyResolver(resolveOverloads, filterAmbigs).resolve(this, false);
        return pair != null ? (Collection)pair.getFirst() : Collections.emptyList();
    }

    public boolean hasMagicOperands() {
        try {
            ExternalResolveUtils.prohibitClangResolve();
            Pair pair = (Pair)ResolveCache.getInstance((Project)this.myElement.getProject()).resolveWithCaching((PsiReference)this, (ResolveCache.AbstractResolver)MyResolver.getInstance(true), false, false);
            boolean bl = pair != null ? (Boolean)pair.getSecond() : false;
            return bl;
        }
        finally {
            ExternalResolveUtils.allowClangResolve();
        }
    }

    @Override
    @NotNull
    public List<OCSymbol> resolveToSymbols() {
        return new ArrayList<OCSymbol>(this.resolveToSymbols(true));
    }

    @Override
    @NotNull
    public List<OCSymbol> resolveToSymbols(@NotNull OCResolveContext context) {
        return this.resolveToSymbols(true, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<OCSymbol> resolveToSymbols(boolean resolveOverloads, @NotNull OCResolveContext context) {
        MyResolver resolver;
        Key<MyResolver> key = RESOLVER_KEYS[resolveOverloads ? 1 : 0];
        OCResolveContext oCResolveContext = context;
        synchronized (oCResolveContext) {
            resolver = (MyResolver)context.getUserData(key);
            if (resolver == null) {
                resolver = new MyResolver(resolveOverloads, false, context);
                context.putUserData(key, resolver);
            }
        }
        return this.resolveToSymbols(resolver);
    }

    private static final class MyResolver
    implements ResolveCache.AbstractResolver<OCOperatorReference, Pair<List<OCSymbol>, Boolean>> {
        private final boolean myResolveOverloads;
        private final boolean myFilterAmbigs;
        private OCResolveContext myContext;
        private static final MyResolver[] INSTANCES = new MyResolver[]{new MyResolver(false, true), new MyResolver(true, true)};
        private static final Pair<List<OCSymbol>, Boolean> EMPTY = new Pair(Collections.emptyList(), (Object)false);
        private static final Pair<List<OCSymbol>, Boolean> EMPTY_MAGIC = new Pair(Collections.emptyList(), (Object)true);

        public static MyResolver getInstance(boolean resolveOverloads) {
            return resolveOverloads ? INSTANCES[1] : INSTANCES[0];
        }

        private MyResolver(boolean resolveOverloads, boolean filterAmbigs, @NotNull OCResolveContext context) {
            this.myResolveOverloads = resolveOverloads;
            this.myFilterAmbigs = filterAmbigs;
            this.myContext = context;
        }

        private MyResolver(boolean resolveOverloads, boolean filterAmbigs) {
            this.myResolveOverloads = resolveOverloads;
            this.myFilterAmbigs = filterAmbigs;
        }

        public Pair<List<OCSymbol>, Boolean> resolve(@NotNull OCOperatorReference reference, boolean incompleteCode) {
            return this.resolve(reference, this.myContext != null ? this.myContext : OCResolveContext.forPsi(reference.getElement()));
        }

        public Pair<List<OCSymbol>, Boolean> resolve(@NotNull OCOperatorReference reference, @NotNull OCResolveContext context) {
            if (reference.myArguments != null) {
                return this.resolveOperator(reference.mySign, reference.myPlacement, reference.myParamTypes, reference.myArguments, context, reference.getElement());
            }
            return Pair.create(this.doResolveOperator(reference.mySign, reference.myPlacement, reference.myParamTypes, null, context, reference.getElement()), (Object)false);
        }

        @NotNull
        private Pair<List<OCSymbol>, Boolean> resolveOperator(@NotNull String sign, @NotNull OperatorPlacement placement, @Nullable List<OCType> paramTypes, @NotNull List<? extends OCTypeOwner> arguments, @NotNull OCResolveContext context, @NotNull PsiElement localContext) {
            if (OCUDLiteralExpression.isUDLOperator(sign)) {
                return this.resolveUDLOperator(sign, placement, arguments, context, localContext);
            }
            ArrayList<OCType> types = new ArrayList<OCType>();
            ArrayList<OCTypeOwner> args = new ArrayList<OCTypeOwner>();
            boolean hasCppStructType = false;
            boolean wasNonLiteral = false;
            boolean hasMagicParameter = false;
            for (OCTypeOwner oCTypeOwner : arguments) {
                if (oCTypeOwner instanceof OCLiteralExpression || oCTypeOwner instanceof OCLiteralExpressionSymbol) continue;
                wasNonLiteral = true;
                break;
            }
            if (!wasNonLiteral) {
                return EMPTY;
            }
            for (int i = 0; i < arguments.size(); ++i) {
                OCType derefType;
                OCTypeOwner oCTypeOwner = arguments.get(i);
                OCType type = paramTypes != null && i < paramTypes.size() ? paramTypes.get(i).resolve(context) : oCTypeOwner.getResolvedType(context);
                args.add(oCTypeOwner);
                OCType oCType = derefType = type instanceof OCCppReferenceType ? ((OCCppReferenceType)type).getRefType() : type;
                if (derefType instanceof OCMagicType) {
                    hasMagicParameter = true;
                }
                if (TypeProperties.isRecordType(derefType)) {
                    hasCppStructType = true;
                } else if (i == 0 && sign.equals("()")) {
                    return hasMagicParameter ? EMPTY_MAGIC : EMPTY;
                }
                types.add(type);
            }
            if (hasCppStructType) {
                List<OCSymbol> symbols = this.doResolveOperator(sign, placement, types, args, context, localContext);
                return !symbols.isEmpty() ? Pair.create(symbols, (Object)hasMagicParameter) : EMPTY;
            }
            return hasMagicParameter ? EMPTY_MAGIC : EMPTY;
        }

        @NotNull
        private Pair<List<OCSymbol>, Boolean> resolveUDLOperator(@NotNull String sign, @NotNull OperatorPlacement placement, @NotNull List<? extends OCTypeOwner> arguments, @NotNull OCResolveContext context, @NotNull PsiElement localContext) {
            ArrayList<OCType> types = new ArrayList<OCType>();
            ArrayList<OCTypeOwner> args = new ArrayList<OCTypeOwner>();
            if (arguments.size() == 1 && arguments.get(0) instanceof OCLiteralExpression) {
                List<OCSymbol> symbols;
                boolean numericLiteral;
                OCType type;
                OCLiteralExpression literal = (OCLiteralExpression)arguments.get(0);
                IElementType elementType = OCElementUtil.getElementType(literal.getFirstChild());
                if (elementType == OCTokenTypes.INTEGER_LITERAL) {
                    type = OCIntType.ULONGLONG;
                    numericLiteral = true;
                } else if (elementType == OCTokenTypes.FLOAT_LITERAL) {
                    type = OCRealType.LONG_DOUBLE;
                    numericLiteral = true;
                } else {
                    type = literal.getResolvedType(context);
                    numericLiteral = false;
                }
                args.add(literal);
                types.add(type);
                if (literal.isStringLiteral()) {
                    types.add(OCIntType.SIZE_T);
                    args.add(null);
                }
                if (!(symbols = this.doResolveOperator(sign, placement, types, args, context, localContext)).isEmpty()) {
                    return Pair.create(symbols, (Object)false);
                }
                if (numericLiteral) {
                    args.clear();
                    types.clear();
                    types.add(OCPointerType.to(OCIntType.CHAR_CONST));
                    args.add(null);
                    List<OCSymbol> rawChars = this.doResolveOperator(sign, placement, types, args, context, localContext);
                    types.clear();
                    List<OCSymbol> template = this.doResolveOperator(sign, placement, types, null, context, localContext);
                    if (!rawChars.isEmpty() && template.isEmpty()) {
                        symbols = rawChars;
                    } else if (rawChars.isEmpty() && !template.isEmpty()) {
                        symbols = template;
                    } else if (!rawChars.isEmpty() && !template.isEmpty()) {
                        ArrayList<OCSymbol> functionSymbols = new ArrayList<OCSymbol>(2);
                        functionSymbols.addAll(rawChars);
                        functionSymbols.addAll(template);
                        symbols = Collections.singletonList(new OCFunctionGroupSymbol(ContainerUtil.map(functionSymbols, symbol -> (OCFunctionSymbol)symbol), null, OCFunctionGroupSymbol.Cause.Ambiguous, null));
                    }
                    if (!symbols.isEmpty()) {
                        return Pair.create(symbols, (Object)false);
                    }
                }
            }
            return EMPTY;
        }

        @NotNull
        private List<OCSymbol> doResolveOperator(@NotNull String sign, @NotNull OperatorPlacement placement, @NotNull List<OCType> argTypes, @Nullable List<OCTypeOwner> args, @NotNull OCResolveContext context, @NotNull PsiElement localContext) {
            String name = OCTokenTypes.OPERATOR_CPP_KEYWORD.getName() + sign;
            OCType leftType = argTypes.isEmpty() ? null : argTypes.get(0);
            OCExprValueCategory leftValueCategory = args == null || args.isEmpty() ? null : OCExprValueCategory.classify(args.get(0), leftType, context);
            CommonProcessors.CollectProcessor collector = new CommonProcessors.CollectProcessor(new HashSet());
            if (leftType instanceof OCCppReferenceType) {
                leftType = ((OCCppReferenceType)leftType).getRefType();
            }
            if (leftType instanceof OCStructType) {
                List<OCSymbol> members = OCQualifiedExpressionImpl.getResolvedMembers((OCStructType)leftType, name, null, context, true);
                ContainerUtil.process(members, (Processor)collector);
            }
            OCSymbolReference.getLocalReference(name, localContext).processPossibleSymbols((Processor<OCSymbol>)collector, context);
            for (OCType type : argTypes) {
                OCType terminalType = type.getTerminalType();
                if (!(terminalType instanceof OCStructType)) continue;
                OCSymbolWithQualifiedName parent = ((OCStructType)terminalType).getSymbol().getParent();
                OCSymbolReference.GlobalReference reference = OCSymbolReference.getGlobalReference(OCQualifiedName.with(name), parent, OCElementUtil.getVirtualFile(localContext), OCSymbolOffsetUtil.getComplexOffset(localContext));
                reference.processPossibleSymbols((Processor<OCSymbol>)collector, context);
            }
            if (!this.myResolveOverloads) {
                return new ArrayList<OCSymbol>(collector.getResults());
            }
            Collection<OCSymbol> symbols = args != null && args.get(0) instanceof OCExpression ? OCArgumentDepLookupAccumulator.doArgDepLookup(collector.getResults(), argTypes, args, OCQualifiedName.with(name), context) : collector.getResults();
            if (OCUDLiteralExpression.isUDLOperator(sign)) {
                return MyResolver.getUDLSymbols(placement, argTypes, context, localContext, symbols);
            }
            OCArgumentsList<OCTypeOwner> arguments = new OCArgumentsList<OCTypeOwner>(argTypes, args);
            OCSymbol result = OCResolveOverloadsUtil.resolveOverloads(symbols, arguments, leftType, leftValueCategory, placement, true, this.myFilterAmbigs, context, localContext);
            return result != null ? Collections.singletonList(result) : Collections.emptyList();
        }

        @NotNull
        private static List<OCSymbol> getUDLSymbols(@NotNull OperatorPlacement placement, @NotNull List<OCType> argTypes, @NotNull OCResolveContext context, @NotNull PsiElement localContext, @NotNull Collection<OCSymbol> symbols) {
            ArrayList<OCSymbol> directCandidates = new ArrayList<OCSymbol>();
            ArrayList<OCSymbol> fallbackCandidates = new ArrayList<OCSymbol>();
            for (OCSymbol symbol : symbols) {
                List<OCSymbol> symbolList;
                OCType valueType;
                OCTypeParameterSymbol maybeVariadicCharTValues;
                if (!(symbol instanceof OCFunctionSymbol)) continue;
                OCFunctionSymbol functionSymbol = (OCFunctionSymbol)symbol;
                List opTemplParams = functionSymbol.getTemplateParameters();
                List<OCType> opParamTypes = OCResolveOverloadsUtil.getParameterTypes(functionSymbol, placement, context, localContext, CVQualifiers.EMPTY);
                if (opTemplParams.size() == 0 && (argTypes.size() == 1 || argTypes.size() == 2) && argTypes.size() == opParamTypes.size() && opParamTypes.get(0).equalsAfterResolving(argTypes.get(0).transformType(OCArrayToPointerChanger.INSTANCE), context) && (argTypes.size() == 1 || OCIntType.SIZE_T.isCompatible(opParamTypes.get(1).resolve(context), context))) {
                    directCandidates.add(symbol);
                }
                if (argTypes.size() == 1 && argTypes.get(0) instanceof OCNumericType) {
                    CTypeId id = ((OCNumericType)argTypes.get(0)).getCTypeId();
                    if (id != CTypeId.LONG_LONG && id != CTypeId.LONG_DOUBLE) continue;
                    if (opTemplParams.size() == 0 && opParamTypes.size() == 1 && OCPointerType.to(OCIntType.CHAR_CONST).equalsAfterResolving(opParamTypes.get(0), context)) {
                        fallbackCandidates.add(0, symbol);
                        continue;
                    }
                    if (opTemplParams.size() != 1 || opParamTypes.size() != 0 || !((maybeVariadicCharTValues = (OCTypeParameterSymbol)opTemplParams.get(0)) instanceof OCTypeParameterValueSymbol) || !maybeVariadicCharTValues.isVariadic() || !OCIntType.CHAR.equalsAfterResolving(valueType = ((OCVariadicType)maybeVariadicCharTValues.getType()).getUnderlyingType(), context)) continue;
                    fallbackCandidates.add(symbol);
                    continue;
                }
                if (argTypes.size() != 2 || opParamTypes.size() != 0 || opTemplParams.size() != 2) continue;
                OCTypeParameterSymbol maybeCharT = (OCTypeParameterSymbol)opTemplParams.get(0);
                maybeVariadicCharTValues = (OCTypeParameterSymbol)opTemplParams.get(1);
                if (!(maybeCharT instanceof OCTypeParameterTypeSymbol) || !(maybeVariadicCharTValues instanceof OCTypeParameterValueSymbol) || !maybeVariadicCharTValues.isVariadic() || !((valueType = ((OCVariadicType)maybeVariadicCharTValues.getType()).getUnderlyingType()) instanceof OCReferenceType) || (symbolList = ((OCReferenceType)valueType).getReference(context).resolveToSymbols(context)).size() != 1 || !symbolList.get(0).equals(maybeCharT)) continue;
                fallbackCandidates.add(symbol);
            }
            if (!directCandidates.isEmpty()) {
                return directCandidates;
            }
            if (!fallbackCandidates.isEmpty()) {
                return fallbackCandidates;
            }
            return Collections.emptyList();
        }
    }

    public static enum OperatorPlacement {
        PREFIX,
        INFIX,
        POSTFIX;

    }
}

