/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.resolve.references;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileInfoManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.suggested.UtilsKt;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.CommonProcessors;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.jetbrains.cidr.EscapeUtil;
import com.jetbrains.cidr.lang.OCGroupedFileNaming;
import com.jetbrains.cidr.lang.OCGroupedFileNamings;
import com.jetbrains.cidr.lang.psi.OCStringLiteralExpression;
import com.jetbrains.cidr.lang.resolve.references.OCResourceFilesProvider;
import com.jetbrains.cidr.lang.resolve.references.OCResourceReference;
import com.jetbrains.cidr.lang.resolve.references.PsiCachingReferenceBase;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFileResourceReference
extends PsiCachingReferenceBase<PsiElement>
implements OCResourceReference {
    @Nullable
    private Set<String> myExtensions;
    private boolean myExtensionInLiteral;
    private final boolean myIsDirectory;

    public OCFileResourceReference(PsiElement literal, @Nullable Set<String> extensions, boolean extensionInLiteral, boolean isDirectory) {
        super(literal, false);
        this.myExtensions = extensions;
        this.myExtensionInLiteral = extensionInLiteral;
        this.myIsDirectory = isDirectory;
        assert (!this.myExtensionInLiteral || this.myExtensions != null);
    }

    @Override
    public PsiElement resolveInner() {
        CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
        this.processResources(this.getText(), (Processor<VirtualFile>)finder);
        VirtualFile result = (VirtualFile)finder.getFoundValue();
        if (result != null && result.isValid()) {
            return this.findPsiElement(result);
        }
        return null;
    }

    @NotNull
    private String getText() {
        OCStringLiteralExpression stringLiteral = this.getLiteralExpression();
        if (stringLiteral != null) {
            return EscapeUtil.escapeStringExceptUnicode((String)stringLiteral.getUnescapedLiteralText());
        }
        return StringUtil.unquoteString((String)this.myElement.getText());
    }

    @Nullable
    private OCStringLiteralExpression getLiteralExpression() {
        return (OCStringLiteralExpression)PsiTreeUtil.getNonStrictParentOfType((PsiElement)this.myElement, (Class[])new Class[]{OCStringLiteralExpression.class});
    }

    @NotNull
    public String getCanonicalText() {
        Object text = this.getText();
        if (!this.myExtensionInLiteral && this.myExtensions != null && this.myExtensions.size() == 1) {
            text = (String)text + "." + this.myExtensions.iterator().next();
        }
        return text;
    }

    @NotNull
    public TextRange getRangeInElement() {
        OCStringLiteralExpression stringLiteral = this.getLiteralExpression();
        if (stringLiteral != null) {
            return stringLiteral.getContentRangeInElement().shiftRight(UtilsKt.getStartOffset((PsiElement)stringLiteral) - UtilsKt.getStartOffset((PsiElement)this.myElement));
        }
        if (this.myElement.getTextLength() >= 2) {
            return new TextRange(1, this.myElement.getTextLength() - 1);
        }
        return new TextRange(0, this.myElement.getTextLength());
    }

    public Object @NotNull [] getVariants() {
        return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    }

    @Override
    @NotNull
    public List<LookupElement> getLookupElements(@NotNull @NlsSafe String openingQuote, @NotNull @NlsSafe String closingQuote) {
        ArrayList<LookupElement> variants = new ArrayList<LookupElement>();
        HashSet processed = new HashSet();
        this.processResources(null, (PairProcessor<String, VirtualFile>)((PairProcessor)(path, virtualFile) -> {
            String withoutLocalization;
            OCGroupedFileNaming groupedNaming = OCGroupedFileNamings.getGroupedFileNaming(virtualFile);
            if (groupedNaming != null) {
                path = groupedNaming.getBaseName((String)path);
            }
            if ((withoutLocalization = OCResourceFilesProvider.withoutLocalization(path)) != null) {
                path = withoutLocalization;
            }
            if (!processed.add(path)) {
                return true;
            }
            if (!this.myExtensionInLiteral) {
                path = FileUtilRt.getNameWithoutExtension((String)path);
            }
            String text = openingQuote + path + closingQuote;
            Icon fileIcon = virtualFile.getFileType().getIcon();
            PsiElement psiElement = this.findPsiElement((VirtualFile)virtualFile);
            LookupElementBuilder builder2 = FileInfoManager.getFileLookupItem((PsiElement)psiElement, (String)text, (Icon)(fileIcon == null ? AllIcons.FileTypes.Any_type : fileIcon));
            variants.add((LookupElement)builder2);
            return true;
        }));
        return variants;
    }

    private PsiElement findPsiElement(VirtualFile virtualFile) {
        PsiManager manager = this.myElement.getManager();
        return virtualFile.isDirectory() ? manager.findDirectory(virtualFile) : manager.findFile(virtualFile);
    }

    private void processResources(@Nullable String fileName, Processor<VirtualFile> processor) {
        this.processResources(fileName, (PairProcessor<String, VirtualFile>)((PairProcessor)(path, file) -> processor.process(file)));
    }

    private void processResources(@Nullable String fileName, PairProcessor<String, VirtualFile> processor) {
        for (Map.Entry<String, VirtualFile> entry : OCResourceFilesProvider.getAccessibleResources(this.myElement).entrySet()) {
            String entryExtension;
            if (this.myIsDirectory != entry.getValue().isDirectory() || !this.isMatchingExtension(entryExtension = FileUtilRt.getExtension((String)entry.getKey())) || fileName != null && !this.resourceMatchesEntry(fileName, entry) || processor.process((Object)entry.getKey(), (Object)entry.getValue())) continue;
            return;
        }
    }

    private boolean resourceMatchesEntry(@NotNull String fileName, Map.Entry<String, VirtualFile> entry) {
        String entryName = entry.getKey();
        if (!this.myExtensionInLiteral) {
            entryName = FileUtilRt.getNameWithoutExtension((String)entryName);
        }
        if (fileName.equals(entryName)) {
            return true;
        }
        OCGroupedFileNaming groupedNaming = OCGroupedFileNamings.getGroupedFileNaming(entry.getValue());
        if (groupedNaming != null && fileName.equals(entryName = groupedNaming.getBaseName(entryName))) {
            return true;
        }
        return fileName.equals(OCResourceFilesProvider.withoutLocalization(entryName));
    }

    private boolean isMatchingExtension(@NonNls @NotNull String extension) {
        return this.myExtensions == null || this.myExtensions.contains(StringUtil.toLowerCase((String)extension));
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        return super.handleElementRename(this.myExtensionInLiteral ? newElementName : FileUtilRt.getNameWithoutExtension((String)newElementName));
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        return element;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OCFileResourceReference reference = (OCFileResourceReference)o;
        return this.myExtensionInLiteral == reference.myExtensionInLiteral && this.myIsDirectory == reference.myIsDirectory && Objects.equals(this.myExtensions, reference.myExtensions);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.myExtensions, this.myExtensionInLiteral, this.myIsDirectory);
    }
}

