/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.resolve.references;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.resolve.references.CompositeResourceCompletionProvider;
import com.jetbrains.cidr.lang.resolve.references.OCResourceReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCompositeResourceReference
implements OCResourceReference {
    private static final Function<OCResourceReference, PsiElement> ELEMENT = reference -> reference.getElement();
    private static final Function<OCResourceReference, Class> CLASS = reference -> reference.getClass();
    private final List<OCResourceReference> myReferences;

    public OCCompositeResourceReference(List<OCResourceReference> references) {
        CompositeResourceCompletionProvider.assertSameValue(references, CLASS);
        CompositeResourceCompletionProvider.assertSameValue(references, ELEMENT);
        this.myReferences = references;
    }

    @Override
    @NotNull
    public List<LookupElement> getLookupElements(@NotNull @NlsSafe String openingQuote, @NotNull @NlsSafe String closingQuote) {
        ArrayList<LookupElement> result = new ArrayList<LookupElement>();
        HashSet<String> alreadyProposedNames = new HashSet<String>();
        HashSet<PsiElement> alreadyProposedElements = new HashSet<PsiElement>();
        for (OCResourceReference reference : this.myReferences) {
            for (LookupElement element : reference.getLookupElements(openingQuote, closingQuote)) {
                PsiElement psiElement;
                if (!alreadyProposedNames.add(element.getLookupString()) || (psiElement = element.getPsiElement()) != null && !alreadyProposedElements.add(psiElement)) continue;
                result.add(element);
            }
        }
        return result;
    }

    @Nullable
    public PsiElement resolve() {
        Pair<PsiElement, ? extends PsiReference> result = this.resolveInner();
        return (PsiElement)Pair.getFirst(result);
    }

    private Pair<PsiElement, ? extends PsiReference> resolveInner() {
        for (OCResourceReference reference : this.myReferences) {
            PsiElement element = reference.resolve();
            if (element == null) continue;
            return Pair.create((Object)element, (Object)reference);
        }
        return null;
    }

    @NotNull
    public PsiElement getElement() {
        return this.getRepresentative().getElement();
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        Pair<PsiElement, ? extends PsiReference> resolve = this.resolveInner();
        return resolve == null ? null : ((PsiReference)resolve.second).handleElementRename(newElementName);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        return this.getRepresentative().bindToElement(element);
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        for (OCResourceReference reference : this.myReferences) {
            if (!reference.isReferenceTo(element)) continue;
            return true;
        }
        return false;
    }

    public boolean isSoft() {
        for (OCResourceReference reference : this.myReferences) {
            if (reference.isSoft()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public TextRange getRangeInElement() {
        return this.getRepresentative().getRangeInElement();
    }

    @NotNull
    public String getCanonicalText() {
        Pair<PsiElement, ? extends PsiReference> resolve = this.resolveInner();
        return resolve == null ? this.getRepresentative().getCanonicalText() : ((PsiReference)resolve.second).getCanonicalText();
    }

    @NotNull
    public PsiReference getRepresentative() {
        return this.myReferences.get(0);
    }
}

