/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.resolve;

import com.intellij.util.Function;
import com.jetbrains.cidr.lang.symbols.expression.OCVariadicPackExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCExpansionPackType;
import com.jetbrains.cidr.lang.types.OCExpressionTypeArgument;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCVariadicType;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCTypeArgumentsProcessor {
    public static boolean processArguments(@NotNull List<? extends OCTypeArgument> parameterTypes, @NotNull List<? extends OCTypeArgument> argumentTypes, @NotNull TypeArgumentsProcessor processor) {
        return OCTypeArgumentsProcessor.processArguments(parameterTypes, argumentTypes, null, true, processor);
    }

    public static boolean processArguments(@NotNull List<? extends OCTypeArgument> parameterTypes, @NotNull List<? extends OCTypeArgument> argumentTypes, @Nullable Function<OCTypeArgument, OCTypeArgument> parameterResolver, boolean failIfCountMismatch, @NotNull TypeArgumentsProcessor processor) {
        if (failIfCountMismatch && parameterTypes.size() != argumentTypes.size() && (parameterTypes.size() <= 0 || parameterTypes.size() > argumentTypes.size() + 1 || parameterTypes.get(parameterTypes.size() - 1) == null || !parameterTypes.get(parameterTypes.size() - 1).isVariadic())) {
            return false;
        }
        for (int i = 0; i < parameterTypes.size(); ++i) {
            OCTypeArgument argumentType;
            OCTypeArgument parameterType = parameterTypes.get(i);
            if (parameterType != null && parameterType.isVariadic()) {
                if (i == parameterTypes.size() - 1) {
                    if (parameterType instanceof OCVariadicType) {
                        parameterType = ((OCVariadicType)parameterType).getUnderlyingType();
                    } else if (parameterType instanceof OCExpressionTypeArgument) {
                        parameterType = new OCExpressionTypeArgument(((OCVariadicPackExpressionSymbol)((OCExpressionTypeArgument)parameterType).getSymbol()).getExpression());
                    }
                    if (parameterResolver != null) {
                        parameterType = (OCTypeArgument)parameterResolver.fun((Object)parameterType);
                    }
                    if (i >= argumentTypes.size() && !processor.process(parameterType instanceof OCType ? ((OCType)parameterType).getTerminalType() : parameterType, new OCExpansionPackType())) {
                        return false;
                    }
                    for (int j = i; j < argumentTypes.size(); ++j) {
                        OCTypeArgument argumentType2 = argumentTypes.get(j);
                        if (processor.process(parameterType, argumentType2)) continue;
                        return false;
                    }
                }
                return true;
            }
            if (parameterResolver != null) {
                parameterType = (OCTypeArgument)parameterResolver.fun((Object)parameterType);
            }
            OCTypeArgument oCTypeArgument = argumentType = i >= argumentTypes.size() ? null : argumentTypes.get(i);
            if (processor.process(parameterType, argumentType)) continue;
            return false;
        }
        return true;
    }

    @FunctionalInterface
    public static interface TypeArgumentsProcessor {
        public boolean process(OCTypeArgument var1, OCTypeArgument var2);
    }
}

