/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.resolve;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.daemon.OCAnnotator;
import com.jetbrains.cidr.lang.daemon.OCAnnotatorHelper;
import com.jetbrains.cidr.lang.preprocessor.OCFileActiveConfigurationCache;
import com.jetbrains.cidr.lang.preprocessor.OCFileUtil;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.psi.OCConstructorFieldInitializer;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceQualifier;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCGotoStatement;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.psi.OCInterface;
import com.jetbrains.cidr.lang.psi.OCLambdaExpression;
import com.jetbrains.cidr.lang.psi.OCLocalScopeable;
import com.jetbrains.cidr.lang.psi.OCLocalSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCNamespaceQualifierOwner;
import com.jetbrains.cidr.lang.psi.OCParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.psi.OCProtocol;
import com.jetbrains.cidr.lang.psi.OCPsiFile;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCTypeArgumentList;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.impl.OCNoexceptSpecifierImpl;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.resolve.OCLocalDeclarationsVisitor;
import com.jetbrains.cidr.lang.resolve.OCTypeParameterSymbolResolver;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCQualifiedNameWithArguments;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithSubstitution;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbolImpl;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceLikeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCUsingSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCLambdaExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCFileSymbols;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeResolveVisitor;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCResolveUtil {
    public static final Key<Boolean> DISABLE_LOCAL_SYMBOL_TABLE = Key.create((String)"DISABLE_LOCAL_SYMBOL_TABLE");
    private static List<Class<? extends OCLocalScopeable>> stopSet = Arrays.asList(OCFunctionDefinition.class, OCMethod.class);

    private OCResolveUtil() {
    }

    public static boolean isEarlierInCode(OCSymbol symbol, VirtualFile usageFile, int usageOffset) {
        return symbol.getContainingFile() == null || !Comparing.equal((Object)symbol.getContainingFile(), (Object)usageFile) || symbol.getOffset() <= usageOffset;
    }

    public static boolean isEarlierInCodeWithComplexOffset(OCSymbol symbol, VirtualFile usageFile, long usageComplexOffset) {
        return symbol.getContainingFile() == null || !Comparing.equal((Object)symbol.getContainingFile(), (Object)usageFile) || symbol.getComplexOffset() <= usageComplexOffset;
    }

    public static boolean isInSameStructInCode(OCSymbol symbol, int usageOffset) {
        if (!(symbol instanceof OCSymbolWithQualifiedName)) {
            return false;
        }
        OCSymbolWithQualifiedName parent = ((OCSymbolWithQualifiedName)symbol).getParent();
        return parent instanceof OCStructSymbol && parent.getOffset() < usageOffset;
    }

    public static boolean isInSameStructInCode(OCSymbol symbol, PsiElement usage) {
        PsiFile usageContainingFile = usage.getContainingFile();
        return symbol.getContainingFile() == null || usageContainingFile == null || OCResolveUtil.isInSameStructInCode(symbol, usage.getTextOffset());
    }

    public static boolean isEarlierInCode(OCSymbol symbol, @Nullable PsiElement usage) {
        if (usage == null) {
            return true;
        }
        PsiFile usageContainingFile = usage.getContainingFile();
        return symbol.getContainingFile() == null || usageContainingFile == null || OCResolveUtil.isEarlierInCode(symbol, usageContainingFile.getVirtualFile(), usage.getTextOffset());
    }

    public static boolean isEarlierInCode(OCSymbol symbol, OCSymbol usage) {
        VirtualFile usageContainingFile = usage.getContainingFile();
        return symbol.getContainingFile() == null || usageContainingFile == null || OCResolveUtil.isEarlierInCode(symbol, usageContainingFile, usage.getOffset());
    }

    public static boolean isDisabledSymbol(OCSymbol symbol, @NotNull PsiFile context) {
        return symbol instanceof OCInstanceVariableSymbol && ((OCInstanceVariableSymbol)symbol).isForbiddenClang4ImplicitIvar(context, context.getProject());
    }

    public static boolean isSymbolAvailable(@NotNull OCSymbol symbolToCheck, @Nullable PsiElement contextElement) {
        return OCResolveUtil.checkAvailability(symbolToCheck, contextElement) == null;
    }

    @Nullable
    public static String checkAvailability(@NotNull OCSymbol symbol, @Nullable PsiElement contextElement) {
        if (contextElement == null) {
            return null;
        }
        OCResolveConfiguration configuration = OCFileActiveConfigurationCache.getActiveConfiguration(contextElement);
        if (configuration != null) {
            for (OCAnnotatorHelper each : OCAnnotator.getAnnotatorHelpers()) {
                String unavailableMessage = each.checkAvailability(symbol, configuration);
                if (unavailableMessage == null) continue;
                return unavailableMessage;
            }
        }
        return null;
    }

    public static boolean isDependentCode(@NotNull OCQualifiedName name, @NotNull OCResolveContext context) {
        OCQualifiedName qualifier;
        if (name instanceof OCQualifiedNameWithArguments) {
            for (OCTypeArgument argument : ((OCQualifiedNameWithArguments)name).getArguments()) {
                OCType type;
                if (!(argument instanceof OCType) || !((type = context.getSubstitution().substitute(((OCType)argument).transformType(new OCTypeResolveVisitor(context)), context)) instanceof OCMagicType)) continue;
                return true;
            }
        }
        return (qualifier = name.getQualifier()) != null && OCResolveUtil.isDependentCode(qualifier, context);
    }

    public static boolean isDependentCode(OCExpression expression, @NotNull OCResolveContext context) {
        if (expression instanceof OCReferenceExpression) {
            OCReferenceElement refElement = ((OCReferenceExpression)expression).getReferenceElement();
            return OCResolveUtil.isDependentCode(refElement, context);
        }
        if (expression instanceof OCCallExpression) {
            OCExpression funExpr = ((OCCallExpression)expression).getFunctionReferenceExpression();
            if (funExpr.getResolvedType() instanceof OCMagicType || OCResolveUtil.isDependentCode(funExpr, context)) {
                return true;
            }
            for (OCExpression argument : ((OCCallExpression)expression).getArguments()) {
                if (!(argument.getResolvedType() instanceof OCMagicType)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isDependentCode(@Nullable OCReferenceElement refElement, @NotNull OCResolveContext context) {
        if (refElement == null) {
            return false;
        }
        if (OCResolveUtil.containsMagicTemplateArgument(refElement.getTemplateArgumentList(), context)) {
            return true;
        }
        OCCppNamespaceQualifier namespaceQualifier = refElement.getNamespaceQualifier();
        return OCResolveUtil.containsMagicTemplateArgument(namespaceQualifier != null ? namespaceQualifier.getTemplateArgumentList() : null, context);
    }

    private static boolean containsMagicTemplateArgument(@Nullable OCTypeArgumentList<?> templateArgumentList, @NotNull OCResolveContext context) {
        if (templateArgumentList != null) {
            for (OCElement argument : templateArgumentList.getArguments()) {
                OCType type;
                if (!(argument instanceof OCTypeElement) || !((type = context.getSubstitution().substitute(((OCTypeElement)argument).getType(), context).transformType(new OCTypeResolveVisitor(context))) instanceof OCMagicType)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasNonResolvedTemplateParameters(OCSymbolWithSubstitution symbol, @NotNull OCResolveContext context) {
        OCSymbol parent = (OCSymbol)((Object)symbol);
        while (parent instanceof OCSymbolWithParent) {
            if (parent instanceof OCTemplateSymbol) {
                for (OCTypeParameterSymbol param : ((OCTemplateSymbol)parent).getTemplateParameters()) {
                    OCTypeArgument argument = symbol.getSubstitution().getSubstitutionFor(param);
                    if (argument != null && (!(argument instanceof OCType) || !((OCType)argument).isMagicInside(context))) continue;
                    return true;
                }
            }
            parent = ((OCSymbolWithParent)parent).getParent();
        }
        return false;
    }

    @NotNull
    public static List<Pair<String, OCFunctionSymbol>> findExistingFunctions(@NotNull Project project, @NotNull List<String> names, @NotNull List<? extends OCType> argumentTypes, @Nullable OCSymbol parentForMembers, @NotNull OCResolveContext context) {
        ArrayList<Pair<String, OCFunctionSymbol>> result = new ArrayList<Pair<String, OCFunctionSymbol>>();
        HashSet processed = new HashSet();
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ApplicationManager.getApplication().runReadAction(() -> {
            for (String name : names) {
                OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(project, (Processor<? super OCSymbol>)((Processor)s -> {
                    OCStructSymbol memberFunctionOwner;
                    if (!(s instanceof OCFunctionSymbol)) {
                        return true;
                    }
                    OCFunctionSymbol function = (OCFunctionSymbol)s;
                    if (processed.contains(function)) {
                        return true;
                    }
                    processed.add(function);
                    OCSymbolWithQualifiedName owner = function.getResolvedOwner(context, true);
                    if (!(owner instanceof OCStructSymbol)) {
                        memberFunctionOwner = null;
                    } else {
                        OCFunctionSymbol inParent;
                        if (!owner.equals(parentForMembers)) {
                            return true;
                        }
                        memberFunctionOwner = function.isFriendOrStatic() ? null : ((inParent = function.getDeclarationInParent(context)) == null || inParent.isFriendOrStatic() ? null : (OCStructSymbol)owner);
                    }
                    List<OCType> parameterTypes = function.getType().getParameterTypes();
                    if (argumentTypes.size() != parameterTypes.size() + (memberFunctionOwner == null ? 0 : 1)) {
                        return true;
                    }
                    if (memberFunctionOwner != null) {
                        OCStructType thisType = memberFunctionOwner.getType();
                        OCType argType = (OCType)argumentTypes.get(0);
                        if (argType != null && !argType.equalsAfterResolving(thisType, context, true)) {
                            return true;
                        }
                    }
                    for (int i = 0; i < parameterTypes.size(); ++i) {
                        int argTypeIdx = i + (memberFunctionOwner == null ? 0 : 1);
                        OCType argType = (OCType)argumentTypes.get(argTypeIdx);
                        OCType paramType = parameterTypes.get(i);
                        if (argType == null || argType.equalsAfterResolving(paramType, context, true)) continue;
                        return true;
                    }
                    result.add(Pair.create((Object)function.getName(), (Object)function));
                    return true;
                }), name, false);
            }
        }), OCBundle.message("find.existing.operators.progress.title", new Object[0]), true, project);
        return result;
    }

    public static boolean isDestructorName(String memberName) {
        return StringUtil.isNotEmpty((String)memberName) && memberName.charAt(0) == '~';
    }

    @NotNull
    public static List<PsiElement> locateDefinitions(Collection<? extends OCSymbol> symbols, @NotNull Project project) {
        ArrayList<PsiElement> result = new ArrayList<PsiElement>(symbols.size());
        for (OCSymbol oCSymbol : symbols) {
            PsiElement element = oCSymbol.locateDefinition(project);
            if (element == null) continue;
            result.add(element);
        }
        return result;
    }

    public static boolean processSymbols(@Nullable String name, @NotNull PsiElement context, @NotNull Processor<OCSymbol> processor) {
        OCSymbolReference.LocalReference reference = OCSymbolReference.getLocalReference(OCQualifiedName.with(name), context);
        OCResolveContext resolveContext = OCResolveContext.forPsi((PsiElement)context.getContainingFile());
        return reference.processPossibleSymbols(processor, resolveContext);
    }

    public static boolean processLocalAndMemberSymbols(@Nullable String symbolNameToFind, @NotNull PsiElement context, @NotNull Processor<OCSymbol> processor) {
        if (!OCResolveUtil.processLocalSymbols(symbolNameToFind, context, processor, false)) {
            return true;
        }
        return !OCResolveUtil.processMemberSymbols(symbolNameToFind, context, processor);
    }

    public static boolean processLocalAndMemberSymbols(@Nullable String symbolNameToFind, @NotNull PsiElement context, @NotNull Processor<OCSymbol> processor, @NotNull OCResolveContext resolveContext) {
        if (!OCResolveUtil.processLocalSymbols(symbolNameToFind, context, processor, resolveContext, false)) {
            return true;
        }
        return !OCResolveUtil.processMemberSymbols(symbolNameToFind, context, processor);
    }

    public static boolean processGlobalSymbols(@Nullable String name, @NotNull PsiElement context, @NotNull Processor<OCSymbol> processor) {
        PsiFile file = context.getContainingFile();
        return OCResolveUtil.processGlobalSymbols(name, context, file, context.getTextRange().getEndOffset(), processor);
    }

    public static boolean processGlobalSymbols(@Nullable String name, @Nullable PsiElement context, @Nullable PsiFile file, int textOffset, Processor<OCSymbol> processor) {
        PsiElement context1;
        if (!OCLanguageUtils.supportsResolve(file)) {
            return false;
        }
        OCCommonProcessors.OrderedProcessor<OCSymbol> orderedProcessor = new OCCommonProcessors.OrderedProcessor<OCSymbol>(ResolveFilteringProcessor.createByFileAndOffset(processor, file, textOffset, false), symbol -> !symbol.isPredeclaration(), Conditions.alwaysTrue());
        if (name != null) {
            OCSymbolKind kind;
            OCType builtInType;
            if (name.startsWith("__builtin")) {
                builtInType = new OCMagicType();
                kind = OCSymbolKind.BUILTIN_SYMBOL;
            } else if (name.equals("_cmd") && PsiTreeUtil.getContextOfType((PsiElement)context, (Class[])new Class[]{OCMethod.class}) != null) {
                builtInType = OCReferenceType.fromText("SEL");
                kind = OCSymbolKind.PARAMETER;
            } else {
                builtInType = null;
                kind = OCSymbolKind.BUILTIN_SYMBOL;
            }
            if (builtInType != null) {
                orderedProcessor.process(new OCDeclaratorSymbolImpl(null, OCSymbolOffsetUtil.getComplexOffset(textOffset, 0), null, name, Collections.emptyList(), builtInType, kind));
                return orderedProcessor.finish();
            }
        }
        if ((context1 = file.getContext()) != null) {
            return OCResolveUtil.processSymbols(name, context1, processor);
        }
        OCNamespaceLikeSymbol membersContainer = OCPsiFile.getMembersContainer(file, false);
        assert (membersContainer != null) : "file without oc resolve";
        OCStructType.processMembersOfNamespace(membersContainer, name, true, false, orderedProcessor, OCResolveContext.forPsi((PsiElement)file));
        return orderedProcessor.finish();
    }

    public static boolean processMemberSymbols(@Nullable String name, PsiElement element, Processor<? super OCMemberSymbol> processor) {
        OCObjectType type = OCResolveUtil.getContainingObjectType(element);
        if (type == null) {
            return true;
        }
        OCCommonProcessors.OrderedProcessor<? super OCMemberSymbol> orderedProcessor = new OCCommonProcessors.OrderedProcessor<OCMemberSymbol>(ResolveFilteringProcessor.createByPsiContext(processor, element), symbol -> symbol instanceof OCInstanceVariableSymbol && ((OCInstanceVariableSymbol)symbol).getGeneratedFromProperty() == null || symbol instanceof OCPropertySymbol && symbol.getParent().getCategoryName() == null, symbol -> symbol instanceof OCInstanceVariableSymbol && !((OCInstanceVariableSymbol)symbol).isClang4ImplicitIvar(element.getContainingFile()) || symbol instanceof OCPropertySymbol && "".equals(symbol.getParent().getCategoryName()), Conditions.alwaysTrue());
        type.processMembers(name, OCMemberSymbol.class, orderedProcessor);
        return orderedProcessor.finish();
    }

    @Contract(value="_, null, _, _ -> true")
    public static boolean processLocalSymbols(@Nullable String symbolNameToFind, @Nullable PsiElement element, @NotNull Processor<OCSymbol> processor, boolean treeUpResolveForParamAndSelector) {
        if (element == null) {
            return true;
        }
        return OCResolveUtil.processLocalSymbols(symbolNameToFind, element, processor, OCResolveContext.forPsi(element), treeUpResolveForParamAndSelector);
    }

    private static boolean needTreeUpResolve(@Nullable PsiElement element, boolean treeUpResolveForParamAndSelector) {
        PsiElement parent = PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{OCTypeElement.class, OCNoexceptSpecifierImpl.class});
        if (parent != null && (parent.getParent() instanceof OCDeclarator || parent.getParent() instanceof OCLambdaExpression)) {
            return true;
        }
        return treeUpResolveForParamAndSelector && PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{OCParameterDeclaration.class, OCMethodSelectorPart.class}) != null;
    }

    public static boolean processLocalSymbols(@Nullable String symbolNameToFind, @NotNull PsiElement element, @NotNull Processor<OCSymbol> processor, @NotNull OCResolveContext context, boolean treeUpResolveForParamAndSelector) {
        Iterable<OCSymbol> localSymbols;
        OCElement rootElement = (OCElement)PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{OCFunctionDeclaration.class, OCMethod.class, OCParameterList.class});
        long elementOffset = OCResolveUtil.getElementOffset(element);
        if (rootElement == null) {
            rootElement = (OCElement)PsiTreeUtil.getTopmostParentOfType((PsiElement)element, OCBlockExpression.class);
        }
        if (rootElement == null) {
            rootElement = (OCElement)PsiTreeUtil.getTopmostParentOfType((PsiElement)element, OCLambdaExpression.class);
        }
        if (rootElement == null) {
            return OCResolveUtil.processGenericAndTemplateSymbols(symbolNameToFind, element, processor, context);
        }
        if (element.getParent() instanceof OCConstructorFieldInitializer) {
            return true;
        }
        ResolveFilteringProcessor<OCSymbol> resolveProcessor = ResolveFilteringProcessor.createByPsiContext(processor, element);
        if (symbolNameToFind != null && element.getProject().getUserData(DISABLE_LOCAL_SYMBOL_TABLE) != Boolean.TRUE && !OCResolveUtil.needTreeUpResolve(element, treeUpResolveForParamAndSelector) && (localSymbols = OCFileSymbols.getLocalSymbols(rootElement.getContainingOCFile(), symbolNameToFind)) != null) {
            if (!OCResolveUtil.processLocalSymbolsInTable(localSymbols, symbolNameToFind, element, OCSymbolOffsetUtil.getComplexOffset(rootElement), resolveProcessor, context)) {
                return false;
            }
            return OCResolveUtil.processGenericAndTemplateSymbols(symbolNameToFind, element, processor, context);
        }
        boolean result = OCResolveUtil.treeWalkUp(element, (Processor<OCLocalSymbolDeclarator>)((Processor)element1 -> {
            Object symbol = element1.getLocalSymbol();
            if (symbol == null) {
                return true;
            }
            String symbolName = symbol.getName();
            if (symbol.isUnnamed()) {
                return true;
            }
            if (symbol.getKind() == OCSymbolKind.NAMESPACE_USING_SYMBOL && symbol.getScope().containsOffset(elementOffset)) {
                for (OCSymbol namespace : context.resolveToSymbols(((OCUsingSymbol)symbol).getSymbolReference())) {
                    if (!(namespace instanceof OCNamespaceSymbol) || OCStructType.processMembersOfNamespace((OCNamespaceSymbol)namespace, symbolNameToFind, true, false, (Processor<? super OCSymbol>)processor, context)) continue;
                    return false;
                }
                return true;
            }
            if (symbolNameToFind != null && !symbolName.equals(symbolNameToFind)) {
                return true;
            }
            if (symbol.getKind() == OCSymbolKind.SYMBOL_USING_SYMBOL) {
                return ContainerUtil.process(context.resolveToSymbols(((OCUsingSymbol)symbol).getSymbolReference()), (Processor)processor);
            }
            return resolveProcessor.process(symbol);
        }), element.getParent() instanceof OCGotoStatement);
        if (result) {
            return OCResolveUtil.processGenericAndTemplateSymbols(symbolNameToFind, element, processor, context);
        }
        return false;
    }

    static boolean processGenericAndTemplateSymbols(@Nullable String symbolNameToFind, PsiElement element, Processor<OCSymbol> processor, @NotNull OCResolveContext context) {
        return OCTypeParameterSymbolResolver.processGenericSymbols(symbolNameToFind, element, processor, context) && OCTypeParameterSymbolResolver.processTemplateSymbols(symbolNameToFind, element, processor, context);
    }

    private static long getElementOffset(PsiElement element) {
        if (element instanceof OCLocalSymbolDeclarator) {
            Object symbol = ((OCLocalSymbolDeclarator)element).getLocalSymbol();
            if (symbol != null && symbol.getKind() == OCSymbolKind.PARAMETER && symbol.getScope() != null) {
                return symbol.getScope().getStartOffset();
            }
        } else {
            OCParameterList parameterList = (OCParameterList)PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{OCParameterList.class});
            if (parameterList != null) {
                PsiElement parent = parameterList.getParent().getParent();
                if (parent instanceof OCFunctionDefinition) {
                    OCBlockStatement body = ((OCFunctionDefinition)parent).getBody();
                    return OCSymbolOffsetUtil.getComplexOffset(body != null ? body : parent);
                }
                return OCSymbolOffsetUtil.getComplexOffset(parameterList);
            }
        }
        return OCSymbolOffsetUtil.getComplexOffset(element);
    }

    private static boolean processLocalSymbolsInTable(Iterable<? extends OCSymbol> symbols, String name, PsiElement element, long rootElementOffset, Processor<? super OCSymbol> processor, OCResolveContext context) {
        long elementOffset = OCResolveUtil.getElementOffset(element);
        if (symbols instanceof Set) {
            assert (((Set)symbols).size() == 1);
            OCSymbol symbol = symbols.iterator().next();
            if (symbol.getScope().containsOffset(elementOffset)) {
                return processor.process((Object)symbol);
            }
        } else if (symbols instanceof List) {
            OCSymbol symbol;
            List list = (List)symbols;
            int index = OCResolveUtil.findNearest(elementOffset, list);
            ListIterator itr = list.listIterator(-index - 1);
            while (itr.hasPrevious() && (symbol = (OCSymbol)itr.previous()).getScope().getEndOffset() >= rootElementOffset) {
                if (!symbol.getScope().containsOffset(elementOffset)) continue;
                if (symbol.getKind() == OCSymbolKind.NAMESPACE_USING_SYMBOL) {
                    for (OCSymbol namespace : context.resolveToSymbols(((OCUsingSymbol)symbol).getSymbolReference())) {
                        if (!(namespace instanceof OCNamespaceSymbol) || OCStructType.processMembersOfNamespace((OCNamespaceSymbol)namespace, name, true, false, processor, context)) continue;
                        return false;
                    }
                    continue;
                }
                if (symbol.getKind() == OCSymbolKind.SYMBOL_USING_SYMBOL) {
                    return ContainerUtil.process(context.resolveToSymbols(((OCUsingSymbol)symbol).getSymbolReference()), processor);
                }
                if (processor.process((Object)symbol)) continue;
                return false;
            }
        } else assert (symbols == null);
        return true;
    }

    @Nullable
    public static OCSymbol resolveLambdaLocalSymbolInTable(List<? extends OCDeclaratorSymbol> variables, OCQualifiedName qualifiedName, long offset) {
        OCDeclaratorSymbol variable;
        OCDeclaratorSymbolImpl symbol = new OCDeclaratorSymbolImpl(null, offset, null, qualifiedName, Collections.emptyList(), OCUnknownType.INSTANCE, null, null, Collections.emptyList(), Collections.emptyList(), OCDeclaratorSymbol.Property.IS_SYNTHETIC.ordinal(), 0, null, null);
        int index = Collections.binarySearch(variables, symbol, OCLambdaExpressionSymbol.variablesComparator);
        if (index >= 0) {
            return variables.get(index).getInitializerExpression();
        }
        for (index = -(index + 2); index >= 0 && (variable = variables.get(index)).getName().equals(qualifiedName.getName()); --index) {
            if (variable.getScope() != null && !variable.getScope().contains(offset)) continue;
            return variable;
        }
        return null;
    }

    public static int findNearest(long elementOffset, @NotNull List<? extends OCSymbol> list) {
        return Collections.binarySearch(list, null, (symbol1, symbol2) -> {
            long offset2;
            long offset1 = symbol1 != null ? symbol1.getScope().getStartOffset() : elementOffset;
            long l = offset2 = symbol2 != null ? symbol2.getScope().getStartOffset() : elementOffset;
            if (offset1 == offset2) {
                if (symbol1 == null) {
                    ++offset1;
                } else if (symbol2 == null) {
                    ++offset2;
                }
            }
            return Long.compare(offset1, offset2);
        });
    }

    private static boolean treeWalkUp(PsiElement place, Processor<OCLocalSymbolDeclarator> processor, boolean stepIntoBlocks) {
        PsiElement lastParent = null;
        for (PsiElement run2 = place; run2 != null; run2 = run2.getContext()) {
            OCLocalDeclarationsVisitor visitor = new OCLocalDeclarationsVisitor(processor, lastParent, stepIntoBlocks);
            run2.accept((PsiElementVisitor)visitor);
            if (!visitor.getResult()) {
                return false;
            }
            Class<?> runClass = run2.getClass();
            for (Class<? extends OCLocalScopeable> clazz : stopSet) {
                if (!clazz.isAssignableFrom(runClass) || PsiTreeUtil.getContextOfType((PsiElement)run2, (Class[])new Class[]{OCCallable.class}) != null) continue;
                return true;
            }
            lastParent = run2;
        }
        return true;
    }

    @Nullable
    private static OCObjectType getContainingObjectType(PsiElement element) {
        OCClassDeclaration clazz = (OCClassDeclaration)PsiTreeUtil.getContextOfType((PsiElement)element, (boolean)false, (Class[])new Class[]{OCInterface.class, OCImplementation.class, OCProtocol.class});
        return clazz != null ? clazz.getType() : null;
    }

    public static boolean isDuplicate(OCSymbolKind kind1, OCSymbolKind kind2) {
        if (kind1 == OCSymbolKind.METHOD || kind2 == OCSymbolKind.METHOD || kind1 == OCSymbolKind.PROPERTY || kind2 == OCSymbolKind.PROPERTY || kind1 == OCSymbolKind.SYNTHESIZE || kind2 == OCSymbolKind.SYNTHESIZE) {
            return kind1 == kind2;
        }
        if (kind1.isClass() != kind2.isClass()) {
            return false;
        }
        if (kind1.isStructLike() != kind2.isStructLike()) {
            return false;
        }
        if (kind1 == OCSymbolKind.PROTOCOL != (kind2 == OCSymbolKind.PROTOCOL)) {
            return false;
        }
        if (kind1 == OCSymbolKind.PARAMETER && (kind2.isGlobalVariable() || kind2.isFunction())) {
            return false;
        }
        return kind2 != OCSymbolKind.PARAMETER || !kind1.isGlobalVariable() && !kind1.isFunction();
    }

    public static boolean isDuplicate(OCSymbol symbol, OCSymbol duplicate, @NotNull Project project) {
        if (symbol.equals(duplicate)) {
            return false;
        }
        if (!OCResolveUtil.isEarlierInCodeWithComplexOffset(symbol, duplicate.getContainingFile(), duplicate.getComplexOffset())) {
            return false;
        }
        if ((!symbol.getClass().equals(duplicate.getClass()) || symbol.isPredeclaration() != duplicate.isPredeclaration()) && (!symbol.isGlobal() || !duplicate.isGlobal() || symbol instanceof OCClassSymbol && duplicate instanceof OCClassSymbol || symbol.getKind().isTemplateParameter() || duplicate.getKind().isTemplateParameter())) {
            return false;
        }
        if (symbol.getKind() == OCSymbolKind.PROTOCOL != (duplicate.getKind() == OCSymbolKind.PROTOCOL)) {
            return false;
        }
        if (symbol instanceof OCClassSymbol && duplicate instanceof OCClassSymbol && (!Objects.equals(((OCClassSymbol)symbol).getCategoryName(), ((OCClassSymbol)duplicate).getCategoryName()) || "".equals(((OCClassSymbol)symbol).getCategoryName()))) {
            return false;
        }
        if (symbol instanceof OCMemberSymbol && duplicate instanceof OCMemberSymbol && !((OCMemberSymbol)symbol).getParent().equals(((OCMemberSymbol)duplicate).getParent())) {
            return false;
        }
        if (symbol instanceof OCDeclaratorSymbol && duplicate instanceof OCDeclaratorSymbol && !Comparing.equal((Object)symbol.getScope(), (Object)duplicate.getScope())) {
            return false;
        }
        if (symbol instanceof OCMethodSymbol && duplicate instanceof OCMethodSymbol && ((OCMethodSymbol)symbol).isStatic() != ((OCMethodSymbol)duplicate).isStatic()) {
            return false;
        }
        if (symbol instanceof OCMethodSymbol && ((OCMethodSymbol)symbol).getGeneratedFromProperty() != null || duplicate instanceof OCMethodSymbol && ((OCMethodSymbol)duplicate).getGeneratedFromProperty() != null) {
            return false;
        }
        if ((symbol instanceof OCMethodSymbol && duplicate instanceof OCPropertySymbol || symbol instanceof OCPropertySymbol && duplicate instanceof OCMethodSymbol) && symbol.getName().equals(duplicate.getName())) {
            return false;
        }
        if (symbol instanceof OCMacroSymbol != duplicate instanceof OCMacroSymbol) {
            return false;
        }
        if (duplicate instanceof OCMacroSymbol && !Comparing.equal((Object)symbol.getContainingFile(), (Object)duplicate.getContainingFile())) {
            return false;
        }
        if (symbol instanceof OCInstanceVariableSymbol && ((OCInstanceVariableSymbol)symbol).isClang4ImplicitIvar(project)) {
            return false;
        }
        if (duplicate instanceof OCInstanceVariableSymbol && ((OCInstanceVariableSymbol)duplicate).isClang4ImplicitIvar(project)) {
            return false;
        }
        PsiFile file = symbol.getContainingPsiFile(project);
        OCResolveContext context = OCResolveContext.forNullablePsi((PsiElement)file, project);
        if (symbol instanceof OCSymbolWithQualifiedName && duplicate instanceof OCSymbolWithQualifiedName) {
            OCSymbolWithQualifiedName duplicateParent;
            OCSymbolWithQualifiedName parent;
            OCLanguageKind kind = OCPsiFile.getKind(file);
            if (kind != null && kind.isCpp() || symbol.hasAttribute("overloadable") || duplicate.hasAttribute("overloadable")) {
                if (!Comparing.equal((Object)((OCSymbolWithQualifiedName)symbol).getResolvedQualifiedName(context), (Object)((OCSymbolWithQualifiedName)duplicate).getResolvedQualifiedName(context))) {
                    return false;
                }
                if (symbol instanceof OCFunctionSymbol && duplicate instanceof OCFunctionSymbol && !OCTypeUtils.areSignaturesEqual((OCFunctionSymbol)symbol, (OCFunctionSymbol)duplicate, context, ((OCFunctionSymbol)symbol).isTemplateSymbol() || ((OCFunctionSymbol)duplicate).isTemplateSymbol())) {
                    return false;
                }
            } else if (!Comparing.equal((Object)((OCSymbolWithQualifiedName)symbol).getParent(), (Object)((OCSymbolWithQualifiedName)duplicate).getParent())) {
                return false;
            }
            if ((parent = ((OCSymbolWithQualifiedName)symbol).getResolvedOwner(context)) != (duplicateParent = ((OCSymbolWithQualifiedName)duplicate).getResolvedOwner(context)) && parent != null && duplicateParent != null && !parent.isPredeclaration() && parent.getKind().isStructLike() && !duplicateParent.isPredeclaration() && duplicateParent.getKind().isStructLike()) {
                return false;
            }
        }
        return !(symbol instanceof OCTemplateSymbol) || !(duplicate instanceof OCTemplateSymbol) || ((OCTemplateSymbol)symbol).getTemplateParameters().size() == ((OCTemplateSymbol)duplicate).getTemplateParameters().size();
    }

    private static int findSymbolInList(List<? extends OCSymbol> symbols, int offset) {
        int index = Collections.binarySearch(symbols, null, (o1, o2) -> {
            int offset1 = o1 == null ? offset : o1.getOffset();
            int offset2 = o2 == null ? offset : o2.getOffset();
            return offset1 - offset2;
        });
        return index >= 0 ? index : -index - 1;
    }

    private static int findStartIdx(List<? extends OCSymbol> symbols, int afterOffset) {
        int startIdx;
        int n = afterOffset == -1 ? 0 : (startIdx = OCResolveUtil.findSymbolInList(symbols, afterOffset == 0 ? 0 : afterOffset + 1));
        if (startIdx > 0 && symbols.get(startIdx - 1) instanceof OCNamespaceSymbol && ((OCNamespaceSymbol)symbols.get(startIdx - 1)).getLastElementOffset() >= afterOffset) {
            --startIdx;
        }
        return startIdx;
    }

    private static int findEndIdx(List<? extends OCSymbol> symbols, int beforeOffset) {
        int endIdx = beforeOffset == -1 ? symbols.size() : OCResolveUtil.findSymbolInList(symbols, beforeOffset + 1);
        return endIdx;
    }

    public static boolean processSymbolsFromList(Processor<? super OCSymbol> processor, List<? extends OCSymbol> symbols, int afterOffset, int beforeOffset) {
        int startIdx = OCResolveUtil.findStartIdx(symbols, afterOffset);
        int endIdx = OCResolveUtil.findEndIdx(symbols, beforeOffset);
        for (int i = startIdx; i < endIdx; ++i) {
            ProgressManager.checkCanceled();
            if (processor.process((Object)symbols.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean processSymbolsFromTwoLists(Processor<? super OCSymbol> processor, List<? extends OCSymbol> symbols1, List<? extends OCSymbol> symbols2, int afterOffset, int beforeOffset) {
        int startIdx1 = OCResolveUtil.findStartIdx(symbols1, afterOffset);
        int endIdx1 = OCResolveUtil.findEndIdx(symbols1, beforeOffset);
        int startIdx2 = OCResolveUtil.findStartIdx(symbols2, afterOffset);
        int endIdx2 = OCResolveUtil.findEndIdx(symbols2, beforeOffset);
        int idx1 = startIdx1;
        int idx2 = startIdx2;
        while (idx1 < endIdx1 || idx2 < endIdx2) {
            OCSymbol symbol;
            OCSymbol symbol2;
            ProgressManager.checkCanceled();
            OCSymbol symbol1 = idx1 < endIdx1 ? symbols1.get(idx1) : null;
            OCSymbol oCSymbol = symbol2 = idx2 < endIdx2 ? symbols2.get(idx2) : null;
            if (symbol1 != null) {
                if (symbol2 != null && symbol2.getOffset() < symbol1.getOffset()) {
                    symbol = symbol2;
                    ++idx2;
                } else {
                    symbol = symbol1;
                    ++idx1;
                }
            } else {
                symbol = symbol2;
                ++idx2;
            }
            if (processor.process((Object)symbol)) continue;
            return false;
        }
        return true;
    }

    public static <T extends OCSymbol> boolean processMap(Processor<? super T> processor, @Nullable String name, MostlySingularMultiMap<String, T> map2) {
        if (name != null) {
            return map2.processForKey((Object)name, processor);
        }
        return map2.processAllValues(processor);
    }

    @NotNull
    public static Collection<OCSymbol> resolveTemplateDeclarations(@NotNull OCNamespaceQualifierOwner element) {
        return OCSymbolReference.getLocalReference(element, OCSymbolReference.SymbolFilter.NONE).resolveToSymbols(false, false, false, OCResolveContext.forPsi(element));
    }

    @Nullable
    public static OCFunctionSymbol resolveCtorCall(@NotNull OCDeclarator declarator) {
        OCResolveContext context = OCResolveContext.forPsi(declarator);
        OCType type = declarator.getType().resolve(context);
        if (!(type instanceof OCStructType)) {
            return null;
        }
        OCStructType structType = (OCStructType)type;
        List<OCExpression> initializers = declarator.getInitializers();
        return OCResolveUtil.resolveCtorCall(initializers, structType, context, declarator);
    }

    @Nullable
    public static OCFunctionSymbol resolveCtorCall(@NotNull List<? extends OCExpression> initializers, @NotNull OCStructType structType, @NotNull OCResolveContext context, @Nullable PsiElement localContext) {
        ArrayList<OCType> initializerTypes = new ArrayList<OCType>();
        for (OCExpression oCExpression : initializers) {
            initializerTypes.add(oCExpression.getResolvedType(context));
        }
        OCArgumentsList<? extends OCExpression> argumentsList = new OCArgumentsList<OCExpression>(initializerTypes, initializers);
        return structType.findConstructor(argumentsList, context, localContext, true, null, false).getSymbol();
    }

    public static boolean stopNameLookup(OCSymbol collected) {
        if (collected instanceof OCTemplateSymbol && ((OCTemplateSymbol)collected).isSpecialization()) {
            return false;
        }
        if (collected instanceof OCNamespaceSymbol && ((OCNamespaceSymbol)collected).isQualifiedContainer()) {
            return false;
        }
        return !collected.isPredeclaration() ? !collected.getKind().isConstructorOrDestructor() && !collected.getKind().isTemplateParameter() && collected.getKind() != OCSymbolKind.SYMBOL_USING_SYMBOL : !collected.getKind().isConstructorOrDestructor() && !collected.getKind().isStructLike();
    }

    public static void checkCanceled() {
        ProgressManager.checkCanceled();
        Application app = ApplicationManager.getApplication();
        if (app.isReadAccessAllowed()) {
            app.runReadAction(() -> {});
        }
    }

    public static final class ResolveFilteringProcessor<T extends OCSymbol>
    implements Processor<T> {
        private Processor<? super T> myProcessor;
        private PsiFile myFile;
        private int myTextOffset;
        private VirtualFile myVirtualFile;
        private boolean myIgnoringImports;

        public static <T extends OCSymbol> ResolveFilteringProcessor<T> createByPsiContext(Processor<? super T> processor, @NotNull PsiElement context) {
            return ResolveFilteringProcessor.createByFileAndOffset(processor, context.getContainingFile(), context.getTextOffset(), false);
        }

        public static <T extends OCSymbol> ResolveFilteringProcessor<T> createByFileAndOffset(Processor<? super T> processor, @Nullable PsiFile file, int textOffset, boolean isIgnoringImports) {
            PsiElement context;
            if (file instanceof OCCodeFragment && (context = file.getContext()) != null) {
                file = context.getContainingFile();
                textOffset = context.getTextOffset();
            }
            VirtualFile virtualFile = OCFileUtil.getVirtualFile(file);
            return new ResolveFilteringProcessor<T>(processor, file, textOffset, virtualFile, isIgnoringImports);
        }

        public static <T extends OCSymbol> ResolveFilteringProcessor<T> createByReference(Processor<? super T> processor, @NotNull OCSymbolReference.GlobalReference reference, @NotNull OCResolveContext context) {
            return new ResolveFilteringProcessor<T>(processor, context.getFile(), OCSymbolOffsetUtil.getTextOffset(reference.getOffset()), reference.getVirtualFile(), context.isProcessNonImported());
        }

        private ResolveFilteringProcessor(Processor<? super T> processor, PsiFile file, int textOffset, VirtualFile virtualFile, boolean ignoringImports) {
            this.myProcessor = processor;
            this.myFile = file;
            this.myTextOffset = textOffset;
            this.myVirtualFile = virtualFile;
            this.myIgnoringImports = ignoringImports;
        }

        public boolean process(T symbol) {
            OCSymbolKind symbolKind = symbol.getKind();
            OCLanguageKind languageKind = OCPsiFile.getKind(this.myFile);
            if (symbolKind.isFunction() && languageKind != null && !languageKind.isCpp() || symbol instanceof OCStructSymbol && ((OCStructSymbol)symbol).isTemplateSymbol() || symbol instanceof OCInterfaceSymbol && ((OCInterfaceSymbol)symbol).getCategoryName() != null || symbolKind == OCSymbolKind.LABEL || symbolKind == OCSymbolKind.TEMPLATE_TYPE_PARAMETER || symbol instanceof OCInstanceVariableSymbol && ((OCInstanceVariableSymbol)symbol).getGeneratedFromProperty() != null || this.myIgnoringImports || this.myTextOffset == -1 || OCResolveUtil.isEarlierInCode(symbol, this.myVirtualFile, this.myTextOffset)) {
                return this.myFile != null && OCResolveUtil.isDisabledSymbol(symbol, this.myFile) || this.myProcessor.process(symbol);
            }
            return true;
        }

        public void allowResolveBelowIf(boolean allowResolveBelow) {
            this.myIgnoringImports |= allowResolveBelow;
        }
    }
}

