/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.resolve;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCFileType;
import com.jetbrains.cidr.lang.OCIncludeHelpers;
import com.jetbrains.cidr.lang.preprocessor.OCResolveRootAndConfiguration;
import com.jetbrains.cidr.lang.preprocessor.OCResolveRootAndConfigurationCache;
import com.jetbrains.cidr.lang.workspace.OCCompilerSettings;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class OCFileReferenceHelper
extends FileReferenceHelper {
    public boolean isMine(@NotNull Project project, @NotNull VirtualFile file) {
        return FileTypeRegistry.getInstance().isFileOfType(file, (FileType)OCFileType.INSTANCE);
    }

    @NotNull
    public String trimUrl(@NotNull String url) {
        return url.trim();
    }

    @NotNull
    public Collection<PsiFileSystemItem> getContexts(@NotNull Project project, @NotNull VirtualFile file) {
        OCResolveRootAndConfiguration rootAndConfig;
        OCResolveConfiguration configuration;
        ArrayList<PsiFileSystemItem> roots2 = new ArrayList<PsiFileSystemItem>();
        PsiFileSystemItem item = this.getPsiFileSystemItem(project, file);
        if (item != null) {
            ContainerUtil.addIfNotNull(roots2, (Object)item.getParent());
        }
        if ((configuration = (rootAndConfig = OCResolveRootAndConfigurationCache.getInstance(project).getResolveRootAndActiveConfiguration(file)).getConfiguration()) != null) {
            OCCompilerSettings compilerSettings = configuration.getCompilerSettings(rootAndConfig.getKind(), rootAndConfig.getRootFile());
            for (PsiFileSystemItem root : compilerSettings.getHeadersSearchRoots().getAllRoots()) {
                if (!root.isValid()) continue;
                roots2.add(root);
            }
        }
        OCIncludeHelpers.processContainingFramework(project, file, (Processor<PsiFileSystemItem>)new CommonProcessors.CollectProcessor(roots2));
        return roots2;
    }
}

