/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.resolve;

import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.resolve.OCExprValueCategory;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.expression.OCArrayIndexExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCBinaryExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCCallExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCCastExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCCommaExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCConditionalExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCInitializerListExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCLambdaExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCLiteralExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCNewExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCNoexceptExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCQualifiedExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCReferenceExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCSizeofExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCUnaryExpressionSymbolBase;
import com.jetbrains.cidr.lang.symbols.expression.OCUnknownExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCVariadicPackExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCExprSymbolClassifier {
    private final OCResolveContext myContext;

    public OCExprSymbolClassifier(OCResolveContext context) {
        this.myContext = context;
    }

    @NotNull
    private static OCExprValueCategory byBuiltInUnaryOperationSign(@NotNull OCElementType sign, boolean prefix) {
        if (sign == OCTokenTypes.MUL || prefix && (sign == OCTokenTypes.PLUSPLUS || sign == OCTokenTypes.MINUSMINUS)) {
            return OCExprValueCategory.LValue;
        }
        return OCExprValueCategory.PRValue;
    }

    @NotNull
    public OCExprValueCategory classify(OCExpressionSymbol symbol) {
        return this.classify(symbol, null);
    }

    @NotNull
    public OCExprValueCategory classify(OCExpressionSymbol symbol, @Nullable OCType exprType) {
        if (symbol instanceof OCBinaryExpressionSymbol) {
            return this.classifyBinaryExpression((OCBinaryExpressionSymbol)symbol);
        }
        if (symbol instanceof OCCallExpressionSymbol) {
            return this.classifyCallExpression((OCCallExpressionSymbol)symbol, exprType);
        }
        if (symbol instanceof OCCastExpressionSymbol) {
            return this.classifyCastExpression((OCCastExpressionSymbol)symbol);
        }
        if (symbol instanceof OCCommaExpressionSymbol) {
            return this.classifyCommaExpression((OCCommaExpressionSymbol)symbol);
        }
        if (symbol instanceof OCConditionalExpressionSymbol) {
            return this.classifyConditionalExpression((OCConditionalExpressionSymbol)symbol);
        }
        if (symbol instanceof OCInitializerListExpressionSymbol) {
            return this.classifyInitializerListExpressionSymbol((OCInitializerListExpressionSymbol)symbol);
        }
        if (symbol instanceof OCLambdaExpressionSymbol) {
            return this.classifyLambdaExpression((OCLambdaExpressionSymbol)symbol);
        }
        if (symbol instanceof OCLiteralExpressionSymbol) {
            return this.classifyLiteralExpression((OCLiteralExpressionSymbol)symbol);
        }
        if (symbol instanceof OCNewExpressionSymbol) {
            return this.classifyCppNewExpression((OCNewExpressionSymbol)symbol);
        }
        if (symbol instanceof OCUnaryExpressionSymbolBase) {
            return this.classifyUnaryExpression((OCUnaryExpressionSymbolBase)symbol);
        }
        if (symbol instanceof OCQualifiedExpressionSymbol) {
            return this.classifyQualifiedExpression((OCQualifiedExpressionSymbol)symbol);
        }
        if (symbol instanceof OCReferenceExpressionSymbol) {
            return this.classifyReferenceExpression((OCReferenceExpressionSymbol)symbol);
        }
        if (symbol instanceof OCSizeofExpressionSymbol) {
            return this.classifySizeofExpression((OCSizeofExpressionSymbol)symbol);
        }
        if (symbol instanceof OCUnknownExpressionSymbol) {
            return this.classifyUnknownExpression((OCUnknownExpressionSymbol)symbol);
        }
        if (symbol instanceof OCVariadicPackExpressionSymbol) {
            return this.classifyVariadicPackExpression((OCVariadicPackExpressionSymbol)symbol);
        }
        if (symbol instanceof OCArrayIndexExpressionSymbol) {
            return this.classifyArrayIndexExpression((OCArrayIndexExpressionSymbol)symbol);
        }
        if (symbol instanceof OCNoexceptExpressionSymbol) {
            return this.classifyNoexceptExpression((OCNoexceptExpressionSymbol)symbol);
        }
        OCLog.LOG.error("Unknown expression " + symbol);
        return OCExprValueCategory.LValue;
    }

    @NotNull
    public OCExprValueCategory classifyUnknownExpression(@NotNull OCUnknownExpressionSymbol symbol) {
        return OCExprValueCategory.LValue;
    }

    @NotNull
    public OCExprValueCategory classifyInitializerListExpressionSymbol(@NotNull OCInitializerListExpressionSymbol symbol) {
        return OCExprValueCategory.PRValue;
    }

    public OCExprValueCategory classifyCommaExpression(OCCommaExpressionSymbol e) {
        return this.classify(e.getTailExpression()) == OCExprValueCategory.LValue ? OCExprValueCategory.LValue : OCExprValueCategory.PRValue;
    }

    @NotNull
    public OCExprValueCategory classifyConditionalExpression(OCConditionalExpressionSymbol e) {
        OCType E2Type;
        OCType E1Type;
        OCExprValueCategory c2;
        OCExpressionSymbol E1 = e.getLeftOperandOrCondition();
        OCExpressionSymbol E2 = e.getRightOperand();
        if (E1 == null && E2 == null) {
            return OCExprValueCategory.PRValue;
        }
        if (E1 == null) {
            return this.classify(E2);
        }
        if (E2 == null) {
            return this.classify(E1);
        }
        OCExprValueCategory c1 = this.classify(E1);
        if (c1 == (c2 = this.classify(E2)) && c1 != OCExprValueCategory.PRValue && (E1Type = E1.getResolvedType(this.myContext)).equals(E2Type = E2.getResolvedType(this.myContext), this.myContext)) {
            return c1;
        }
        return OCExprValueCategory.PRValue;
    }

    @NotNull
    public OCExprValueCategory classifyBinaryExpression(@NotNull OCBinaryExpressionSymbol e) {
        OCType customReturnType = e.getCustomReturnType(this.myContext);
        if (customReturnType != null) {
            return OCExprValueCategory.byReturnType(customReturnType);
        }
        OCElementType sign = e.getOperator();
        if (sign == OCTokenTypes.DOT_MUL && this.isPointerToDataMember(e.getRightOperand())) {
            return this.classify(e.getLeftOperand());
        }
        if (sign == OCTokenTypes.DEREF_MUL && this.isPointerToDataMember(e.getRightOperand())) {
            return OCExprValueCategory.LValue;
        }
        return OCExprValueCategory.PRValue;
    }

    private boolean isPointerToDataMember(@NotNull OCExpressionSymbol symbol) {
        OCType type = symbol.getResolvedType(this.myContext);
        if (!(type instanceof OCPointerType)) {
            return true;
        }
        return !(((OCPointerType)type).getRefType() instanceof OCFunctionType);
    }

    @NotNull
    public OCExprValueCategory classifyCastExpression(OCCastExpressionSymbol e) {
        if (!this.myContext.isCpp() && e.getOperand() instanceof OCInitializerListExpressionSymbol) {
            return OCExprValueCategory.LValue;
        }
        OCType castType = e.getCastType().resolve(this.myContext);
        if (castType instanceof OCCppReferenceType) {
            OCCppReferenceType ref = (OCCppReferenceType)castType;
            if (ref.isRvalueRef()) {
                return OCExprValueCategory.XValue;
            }
            return OCExprValueCategory.LValue;
        }
        return OCExprValueCategory.PRValue;
    }

    @NotNull
    public OCExprValueCategory classifySizeofExpression(OCSizeofExpressionSymbol e) {
        return OCExprValueCategory.PRValue;
    }

    @NotNull
    public OCExprValueCategory classifyUnaryExpression(OCUnaryExpressionSymbolBase e) {
        OCType customReturnType = e.getCustomReturnType(this.myContext);
        if (customReturnType != null) {
            return OCExprValueCategory.byReturnType(customReturnType);
        }
        return OCExprSymbolClassifier.byBuiltInUnaryOperationSign(e.getOperator(), e.getOperatorPlacement() == OCOperatorReference.OperatorPlacement.PREFIX);
    }

    @NotNull
    public OCExprValueCategory classifyCallExpression(OCCallExpressionSymbol e, @Nullable OCType exprType) {
        OCType type;
        OCType oCType = type = exprType != null ? exprType : e.getResolvedType(this.myContext);
        if (type.isUnknown()) {
            return OCExprValueCategory.LValue;
        }
        return OCExprValueCategory.byReturnType(type);
    }

    @NotNull
    public OCExprValueCategory classifyQualifiedExpression(OCQualifiedExpressionSymbol E1) {
        if (E1.isDeref()) {
            return OCExprValueCategory.LValue;
        }
        return this.classify(E1.getQualifier());
    }

    @NotNull
    public OCExprValueCategory classifyReferenceExpression(OCReferenceExpressionSymbol e) {
        return OCExprValueCategory.LValue;
    }

    @NotNull
    public OCExprValueCategory classifyLiteralExpression(OCLiteralExpressionSymbol e) {
        if (e.getTokenType() == OCTokenTypes.STRING_LITERAL) {
            return OCExprValueCategory.LValue;
        }
        return OCExprValueCategory.PRValue;
    }

    @NotNull
    public OCExprValueCategory classifyLambdaExpression(OCLambdaExpressionSymbol lambdaExpression) {
        return OCExprValueCategory.PRValue;
    }

    @NotNull
    public OCExprValueCategory classifyCppNewExpression(OCNewExpressionSymbol e) {
        return OCExprValueCategory.PRValue;
    }

    @NotNull
    public OCExprValueCategory classifyVariadicPackExpression(OCVariadicPackExpressionSymbol e) {
        return this.classify(e.getExpression());
    }

    @NotNull
    private OCExprValueCategory classifyArrayIndexExpression(@NotNull OCArrayIndexExpressionSymbol symbol) {
        if (symbol.getIndexSymbol() == null) {
            return OCExprValueCategory.LValue;
        }
        OCArrayIndexExpressionSymbol.ResolveResult result = symbol.getResolvedTypeWithKind(this.myContext);
        if (result.kind == OCArrayIndexExpressionSymbol.Kind.Builtin) {
            return OCExprValueCategory.LValue;
        }
        return OCExprValueCategory.byReturnType(result.type);
    }

    @NotNull
    private OCExprValueCategory classifyNoexceptExpression(@NotNull OCNoexceptExpressionSymbol symbol) {
        return OCExprValueCategory.PRValue;
    }
}

