/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.util;

import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.cidr.lang.generate.OCCaretLocation;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCaseStatement;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCClassPredeclarationList;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCConceptDeclaration;
import com.jetbrains.cidr.lang.psi.OCCondition;
import com.jetbrains.cidr.lang.psi.OCConstructorInitializationList;
import com.jetbrains.cidr.lang.psi.OCCppBaseClause;
import com.jetbrains.cidr.lang.psi.OCCppBaseClauseList;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCEnum;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCForStatement;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCInstanceVariablesList;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMacroCallArgument;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.psi.OCPropertyAttributesList;
import com.jetbrains.cidr.lang.psi.OCProtocolList;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCSynthesizePropertiesList;
import com.jetbrains.cidr.lang.psi.OCSynthesizeProperty;
import com.jetbrains.cidr.lang.psi.OCTemplateArgumentList;
import com.jetbrains.cidr.lang.psi.OCTemplateParameterList;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.OCTypeParameterDeclaration;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCDeclarationKind;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCChangeUtil {
    private OCChangeUtil() {
    }

    public static <T extends PsiElement> T addBefore(@NotNull PsiElement parent, @NotNull T element, @Nullable PsiElement anchor) {
        return OCChangeUtil.addBefore(parent, element, anchor, PostponedFormatAction.Format);
    }

    public static <T extends PsiElement> T addBefore(@NotNull PsiElement parent, @NotNull T element, @Nullable PsiElement anchor, @NotNull PostponedFormatAction postponedFormatAction) {
        anchor = OCChangeUtil.getRealAnchorForInsertion(parent, element, anchor);
        return (T)OCChangeUtil.addHandlingMacros(parent, element, anchor, postponedFormatAction, true);
    }

    public static <T extends PsiElement> T addAfter(@NotNull PsiElement parent, @NotNull T element, @Nullable PsiElement anchor) {
        return OCChangeUtil.addAfter(parent, element, anchor, PostponedFormatAction.Format);
    }

    public static <T extends PsiElement> T addAfter(@NotNull PsiElement parent, @NotNull T element, @Nullable PsiElement anchor, @NotNull PostponedFormatAction postponedFormatAction) {
        anchor = OCChangeUtil.getRealAnchorForInsertion(parent, element, anchor);
        IElementType anchorType = OCElementUtil.getElementType(anchor);
        if (anchor != null && anchorType == OCElementTypes.OBJC_KEYWORD) {
            anchorType = OCElementUtil.getObjCKeywordElementType(anchor.getNode());
        }
        return (T)OCChangeUtil.addHandlingMacros(parent, element, anchor, postponedFormatAction, anchorType == OCTokenTypes.END_KEYWORD || anchorType == OCTokenTypes.RBRACE);
    }

    public static <T extends PsiElement> T add(@NotNull PsiElement parent, @NotNull T element) {
        return OCChangeUtil.addBefore(parent, element, null, PostponedFormatAction.Format);
    }

    public static <T extends PsiElement> T add(@NotNull PsiElement parent, @NotNull T element, @NotNull PostponedFormatAction postponedFormatAction) {
        return OCChangeUtil.addBefore(parent, element, null, postponedFormatAction);
    }

    @NotNull
    public static PsiElement addAfterWithinBlockStatement(@NotNull PsiElement elementToAdd, @NotNull PsiElement anchorStatement) {
        if (!(anchorStatement.getParent() instanceof OCBlockStatement) && !(anchorStatement.getParent() instanceof OCCaseStatement)) {
            elementToAdd = OCChangeUtil.copyHandlingMacros(elementToAdd);
            OCBlockStatement blockElement = OCElementFactory.surroundByBraces(anchorStatement);
            blockElement = (OCBlockStatement)anchorStatement.replace((PsiElement)blockElement);
            anchorStatement = blockElement.getStatements().get(0);
        }
        if (elementToAdd instanceof OCBlockStatement) {
            OCBlockStatement blockStatement = (OCBlockStatement)elementToAdd;
            PsiElement openingBrace = blockStatement.getOpeningBrace();
            PsiElement closingBrace = blockStatement.getClosingBrace();
            if (openingBrace != null && closingBrace != null) {
                PsiElement firstElement = openingBrace.getNextSibling();
                PsiElement lastElement = closingBrace.getPrevSibling();
                anchorStatement.getParent().addRangeAfter(firstElement, lastElement, anchorStatement);
            }
        } else {
            OCChangeUtil.addAfter(anchorStatement.getParent(), elementToAdd, anchorStatement);
        }
        return anchorStatement;
    }

    @Nullable
    public static PsiElement getRealAnchorForInsertion(@Nullable PsiElement parent, @Nullable PsiElement anchor) {
        return OCChangeUtil.getRealAnchorForInsertion(parent, null, anchor);
    }

    @Contract(value="null, _, _ -> null")
    private static PsiElement getRealAnchorForInsertion(@Nullable PsiElement parent, @Nullable PsiElement element, @Nullable PsiElement anchor) {
        List<OCMethodSelectorPart> parameters;
        int position;
        if (parent == null) {
            return null;
        }
        if (anchor != null && !Comparing.equal((Object)anchor.getContainingFile(), (Object)parent.getContainingFile())) {
            anchor = null;
        }
        if (element != null && !(element.getContainingFile() instanceof OCFile)) {
            element = null;
        }
        if (element != null && (parent instanceof OCFile || parent instanceof OCClassDeclaration)) {
            OCDeclarationKind kind = OCDeclarationKind.getDeclarationKind(element);
            if (kind != null) {
                int startOffset = kind.getChildrenStartOffset(parent);
                int endOffset = kind.getChildrenEndOffset(parent);
                if (startOffset != -1 && endOffset != -1 && (anchor == null || anchor.getTextOffset() >= endOffset)) {
                    return OCChangeUtil.getChildAt(parent, endOffset + 1);
                }
            }
        } else if (parent instanceof OCStruct) {
            OCFunctionDeclaration function;
            String name = ((OCStruct)parent).getName();
            if (element instanceof OCFunctionDeclaration && Objects.equals((function = (OCFunctionDeclaration)element).getName(), name)) {
                for (OCDeclaration member : ((OCStruct)parent).getMembers()) {
                    List<OCDeclarator> parameters2 = function.getParameters();
                    if (parameters2 == null || parameters2.size() == 0) {
                        return member;
                    }
                    if (!(member instanceof OCFunctionDeclaration)) {
                        return member;
                    }
                    if (Objects.equals(((OCFunctionDeclaration)member).getName(), name)) continue;
                    return member;
                }
            }
        }
        if (anchor != null && (position = anchor.getTextOffset() + (anchor.getTextLength() != 0 ? 1 : 0)) < parent.getTextRange().getEndOffset()) {
            return OCChangeUtil.getChildAt(parent, position);
        }
        if (parent instanceof OCParameterList) {
            if (!((OCParameterList)parent).getParameterDeclarations().isEmpty()) {
                parent.addBefore(OCElementFactory.create((OCElementType)OCTokenTypes.COMMA, parent), parent.getLastChild());
            }
            return parent.getLastChild();
        }
        if (parent instanceof OCPropertyAttributesList) {
            if (!((OCPropertyAttributesList)parent).getAttributes().isEmpty()) {
                parent.addBefore(OCElementFactory.create((OCElementType)OCTokenTypes.COMMA, parent), parent.getLastChild());
            }
            return parent.getLastChild();
        }
        if (parent instanceof OCEnum) {
            PsiElement lastChild = OCElementUtil.getPrevSignificantSibling(parent.getLastChild());
            if (!((OCEnum)parent).getFields().isEmpty()) {
                IElementType lastElement = OCElementUtil.getElementType(lastChild);
                PsiElement comma = parent.addBefore(OCElementFactory.create((OCElementType)OCTokenTypes.COMMA, parent), parent.getLastChild());
                if (lastElement == OCTokenTypes.COMMA) {
                    return comma;
                }
            }
            return parent.getLastChild();
        }
        if (parent instanceof OCConstructorInitializationList) {
            if (((OCConstructorInitializationList)parent).getInitializers().size() != 0) {
                parent.add(OCElementFactory.create((OCElementType)OCTokenTypes.COMMA, element));
            }
            return null;
        }
        if (parent instanceof OCStructLike || parent instanceof OCBlockStatement || parent instanceof OCCppNamespace) {
            return OCChangeUtil.findChildByType(parent, (IElementType)OCTokenTypes.RBRACE);
        }
        if (parent instanceof OCProtocolList) {
            PsiElement rbrace = OCChangeUtil.findChildByType(parent, (IElementType)OCTokenTypes.GT);
            if (rbrace == null) {
                PsiElement lbrace = parent.add(OCElementFactory.create((OCElementType)OCTokenTypes.LT, parent));
                CodeEditUtil.markToReformatBefore((ASTNode)lbrace.getNode(), (boolean)true);
                return parent.add(OCElementFactory.create((OCElementType)OCTokenTypes.GT, parent));
            }
            if (!((OCProtocolList)parent).getProtocols().isEmpty()) {
                parent.addBefore(OCElementFactory.create((OCElementType)OCTokenTypes.COMMA, parent), parent.getLastChild());
            }
            return parent.getLastChild();
        }
        if (parent instanceof OCCppBaseClauseList) {
            if (((OCCppBaseClauseList)parent).getBaseClauses().isEmpty()) {
                parent.add(OCElementFactory.create((OCElementType)OCTokenTypes.COLON, parent));
            } else {
                parent.add(OCElementFactory.create((OCElementType)OCTokenTypes.COMMA, parent));
            }
            return null;
        }
        if (parent instanceof OCInstanceVariablesList) {
            PsiElement rbrace = OCChangeUtil.findChildByType(parent, (IElementType)OCTokenTypes.RBRACE);
            if (rbrace == null) {
                PsiElement result = null;
                for (PsiElement child = OCElementFactory.instanceVariableList(element).getFirstChild(); child != null; child = child.getNextSibling()) {
                    IElementType type = child.getNode().getElementType();
                    PsiElement newChild = parent.add(child);
                    if (type == OCTokenTypes.RBRACE) {
                        result = newChild;
                    }
                    CodeEditUtil.markToReformatBefore((ASTNode)newChild.getNode(), (type == OCTokenTypes.LBRACE || type == OCTokenTypes.RBRACE ? 1 : 0) != 0);
                }
                return result;
            }
            return rbrace;
        }
        if (parent instanceof OCMethod && element instanceof OCMethodSelectorPart && !(parameters = ((OCMethod)parent).getParameters()).isEmpty()) {
            OCMethodSelectorPart lastParam = parameters.get(parameters.size() - 1);
            if (lastParam.getParameter() == null) {
                OCChangeUtil.delete(lastParam);
            } else {
                parent.addAfter(OCElementFactory.spaceFromText(element), (PsiElement)lastParam);
            }
            return parent.getLastChild();
        }
        return anchor != null ? parent.getLastChild() : null;
    }

    private static boolean isForConcept(@NotNull PsiElement elem) {
        PsiElement parent = elem.getParent();
        return parent instanceof OCDeclaration && ((OCDeclaration)parent).isConcept();
    }

    private static void deleteConceptTypeParameter(@NotNull OCTypeParameterDeclaration typeDecl) {
        PsiElement nameIdent = typeDecl.getNameIdentifier();
        if (nameIdent != null) {
            OCChangeUtil.deleteChildFromList(typeDecl, nameIdent, ParentCleanup.LEAVE);
        }
    }

    public static void delete(@Nullable PsiElement element) {
        ASTNode prev;
        if (element == null || !element.isValid()) {
            return;
        }
        PsiElement parent = element.getParent();
        if (parent == null) {
            return;
        }
        if (element instanceof OCTypeParameterDeclaration && OCChangeUtil.isForConcept(parent)) {
            OCChangeUtil.deleteConceptTypeParameter((OCTypeParameterDeclaration)element);
            return;
        }
        Ref parentCleanup = new Ref((Object)ParentCleanup.LEAVE);
        if (OCChangeUtil.isDeletionWithParentCleanup(element, parent, (Ref<ParentCleanup>)parentCleanup)) {
            OCChangeUtil.deleteChildFromList(parent, element, (ParentCleanup)((Object)parentCleanup.get()));
        } else if (element instanceof OCTypeElement && parent instanceof OCDeclaration) {
            OCChangeUtil.delete(parent);
        } else if (element instanceof OCStructLike && parent instanceof OCTypeElement && parent.getParent() instanceof OCDeclaration) {
            OCChangeUtil.delete(parent.getParent());
        } else if (parent instanceof OCStructLike) {
            OCChangeUtil.removeRedundantVisibilityDeclarator(element);
            OCChangeUtil.deleteHandlingMacros(element);
        } else if (element instanceof OCConceptDeclaration && parent instanceof OCDeclaration) {
            OCChangeUtil.delete(parent);
        } else if (parent instanceof OCInstanceVariablesList) {
            OCChangeUtil.removeRedundantVisibilityDeclarator(element);
            OCChangeUtil.deleteHandlingMacros(element);
            if (((OCInstanceVariablesList)parent).getDeclarations().isEmpty()) {
                OCChangeUtil.clear(parent);
            }
        } else if (parent instanceof OCMethod && element instanceof OCBlockStatement) {
            OCChangeUtil.deleteHandlingMacros(element);
            parent.add(OCElementFactory.create((OCElementType)OCTokenTypes.SEMICOLON, parent));
        } else if (parent instanceof OCSynthesizeProperty && ((OCSynthesizeProperty)parent).getInstanceVariableRef() == null && ((OCSynthesizeProperty)parent).getPropertyRef() == element) {
            OCChangeUtil.delete(parent);
        } else if (parent instanceof OCSynthesizeProperty && ((OCSynthesizeProperty)parent).getInstanceVariableRef() == element) {
            parent.deleteChildRange(((OCSynthesizeProperty)parent).getPropertyRef().getNextSibling(), parent.getLastChild());
        } else if (parent instanceof OCDeclarator && ((OCDeclarator)parent).getInitializer() == element) {
            prev = TreeUtil.skipElementsBack((ASTNode)element.getNode().getTreePrev(), (TokenSet)TokenSet.orSet((TokenSet[])new TokenSet[]{OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET, TokenSet.create((IElementType[])new IElementType[]{OCElementTypes.MACRO_CALL})}));
            if (prev != null && prev.getElementType() == OCTokenTypes.EQ) {
                OCChangeUtil.deleteHandlingMacros(prev.getPsi());
            }
            OCChangeUtil.deleteHandlingMacros(element);
        } else if (parent instanceof OCCppBaseClause) {
            OCChangeUtil.delete(parent);
        } else if (parent instanceof OCExpressionStatement) {
            OCChangeUtil.safeDeleteStatement((OCStatement)parent);
        } else if (element instanceof OCTemplateParameterList) {
            prev = TreeUtil.skipElementsBack((ASTNode)element.getNode().getTreePrev(), (TokenSet)TokenSet.orSet((TokenSet[])new TokenSet[]{OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET, TokenSet.create((IElementType[])new IElementType[]{OCElementTypes.MACRO_CALL})}));
            if (prev != null && prev.getElementType() == OCTokenTypes.TEMPLATE_CPP_KEYWORD) {
                OCChangeUtil.deleteHandlingMacros(prev.getPsi());
            }
            OCChangeUtil.deleteHandlingMacros(element);
        }
        boolean semicolonRequired = element instanceof OCStatement && !(element.getParent() instanceof OCBlockStatement) && !OCCodeInsightUtil.insideConditionalHeader(element) && !OCCodeInsightUtil.insideLoopHeader(element);
        OCChangeUtil.deleteHandlingMacros(element);
        if (semicolonRequired) {
            parent.add(OCElementFactory.create((OCElementType)OCTokenTypes.SEMICOLON, parent));
        }
    }

    public static void deleteExactly(@Nullable PsiElement element) {
        if (element == null || !element.isValid()) {
            return;
        }
        PsiElement parent = element.getParent();
        if (parent == null) {
            return;
        }
        OCChangeUtil.deleteHandlingMacros(element);
    }

    private static boolean isDeletionWithParentCleanup(@NotNull PsiElement element, @NotNull PsiElement parent, @NotNull Ref<ParentCleanup> parentCleanup) {
        boolean clearMode;
        boolean leaveMode;
        boolean deleteMode;
        boolean bl = deleteMode = parent instanceof OCClassPredeclarationList || parent instanceof OCDeclaration && element instanceof OCDeclarator || parent instanceof OCDeclarationStatement || parent instanceof OCPropertyAttributesList || parent instanceof OCProperty && element instanceof OCDeclaration || parent instanceof OCEnum || parent instanceof OCSynthesizePropertiesList || parent instanceof OCTemplateParameterList;
        if (deleteMode) {
            parentCleanup.set((Object)ParentCleanup.DELETE);
            return true;
        }
        boolean bl2 = leaveMode = parent instanceof OCParameterList || parent instanceof OCArgumentList || parent instanceof OCCompoundInitializer || parent instanceof OCTemplateArgumentList;
        if (leaveMode) {
            parentCleanup.set((Object)ParentCleanup.LEAVE);
            return true;
        }
        boolean bl3 = clearMode = parent instanceof OCProtocolList || parent instanceof OCCppBaseClauseList;
        if (clearMode) {
            parentCleanup.set((Object)ParentCleanup.CLEAR);
            return true;
        }
        return false;
    }

    private static void removeRedundantVisibilityDeclarator(PsiElement element) {
        PsiElement prev;
        PsiElement next = element.getNextSibling();
        for (prev = element.getPrevSibling(); prev != null; prev = prev.getPrevSibling()) {
            if (prev instanceof OCDeclaration || OCElementUtil.getElementType(prev) == OCTokenTypes.LBRACE) {
                return;
            }
            if (OCElementUtil.isVisibilityKeyword(prev.getNode())) break;
        }
        while (next != null) {
            if (next instanceof OCDeclaration) {
                return;
            }
            if (OCElementUtil.isVisibilityKeyword(next.getNode())) break;
            next = next.getNextSibling();
        }
        if (prev != null) {
            for (next = prev.getNextSibling(); next != null && OCElementUtil.isElementEmpty(next); next = next.getNextSibling()) {
            }
            OCChangeUtil.deleteHandlingMacros(prev);
            if (next != null && OCElementUtil.getElementType(next) == OCTokenTypes.COLON) {
                OCChangeUtil.deleteHandlingMacros(next);
            }
        }
    }

    @Nullable
    private static PsiElement findChildByType(PsiElement element, IElementType type) {
        ASTNode child = element.getNode().findChildByType(type);
        return child != null ? child.getPsi() : null;
    }

    @Nullable
    private static PsiElement getChildAt(PsiElement parent, int position) {
        PsiElement element = null;
        for (PsiElement child : OCElementUtil.getAllChildren(parent)) {
            if (child.getTextRange().getEndOffset() < position || OCElementUtil.isElementEmpty(child)) continue;
            element = child;
            break;
        }
        if (element == null && (parent instanceof OCStructLike || parent instanceof OCClassDeclaration)) {
            element = parent.getLastChild();
        }
        while (element != null && element.getPrevSibling() instanceof OCMacroCall) {
            element = element.getPrevSibling();
        }
        return element;
    }

    public static boolean canBeReplacedToBlockStatement(PsiElement statement) {
        if (!(statement instanceof OCStatement)) {
            return false;
        }
        return !(statement.getParent() instanceof OCMacroCallArgument) && !(statement.getParent() instanceof OCCondition) && (!(statement.getParent() instanceof OCForStatement) || ((OCForStatement)statement.getParent()).getBody() == statement);
    }

    public static OCStatement ensureParentIsBlockStatement(OCStatement statement) {
        if (!(statement.getParent() instanceof OCBlockStatement)) {
            OCBlockStatement blockStmt = (OCBlockStatement)OCElementFactory.statementFromText("{\n}", statement);
            PsiElement statementCopy = statement.copy();
            blockStmt = (OCBlockStatement)OCChangeUtil.replaceHandlingMacros(statement, blockStmt);
            return (OCStatement)blockStmt.addBefore(statementCopy, blockStmt.getClosingBrace());
        }
        return statement;
    }

    @Nullable
    public static PsiElement getAppropriateParent(OCSymbolKind kind, PsiElement anchor) {
        if (kind.isFunction()) {
            return PsiTreeUtil.getParentOfType((PsiElement)anchor, (Class[])new Class[]{OCFile.class, OCCppNamespace.class, OCStructLike.class});
        }
        if (kind == OCSymbolKind.LOCAL_VARIABLE) {
            return PsiTreeUtil.getParentOfType((PsiElement)anchor, OCBlockStatement.class);
        }
        if (kind == OCSymbolKind.METHOD) {
            return PsiTreeUtil.getParentOfType((PsiElement)anchor, OCClassDeclaration.class);
        }
        return PsiTreeUtil.getParentOfType((PsiElement)anchor, OCFile.class);
    }

    public static boolean changeText(@NotNull Project project, @NotNull PsiFile file, int offset, int length, @NlsSafe @NotNull String substitution, boolean formatSubstitution) {
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
        if (document == null || !file.isValid()) {
            return false;
        }
        OCChangeUtil.processPostponedFormatIfNeed(file);
        document.replaceString(offset, offset + length, (CharSequence)substitution);
        if (formatSubstitution) {
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
            int endOffset = offset + substitution.length();
            if (endOffset < file.getTextLength()) {
                ++endOffset;
            }
            OCChangeUtil.reformatTextIfNotInjected(file, offset, endOffset);
        }
        return true;
    }

    public static void reformatElementAfterInsertionIfNeed(@NotNull PsiElement element) {
        OCChangeUtil.reformatElementAfterInsertionIfNeed(element, OCChangeUtil.getRangeWithMacros(element));
    }

    public static TextRange getRangeWithMacros(@NotNull PsiElement psiElement) {
        if (psiElement instanceof OCElement) {
            return ((OCElement)psiElement).getRangeWithMacros();
        }
        return psiElement.getTextRange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reformatElementAfterInsertionIfNeed(@NotNull PsiElement element, TextRange rangeToFormat) {
        PsiFile file = element.getContainingFile();
        Document document = file.getViewProvider().getDocument();
        if (document != null) {
            RangeMarker toReformat = document.createRangeMarker(rangeToFormat);
            try {
                OCChangeUtil.processPostponedFormatIfNeed(file);
                OCChangeUtil.reformatTextIfNotInjected(file, toReformat.getStartOffset(), toReformat.getEndOffset());
            }
            finally {
                toReformat.dispose();
            }
        }
    }

    public static void processPostponedFormatIfNeed(@NotNull PsiFile source) {
        Project project = source.getProject();
        PostprocessReformattingAspect postprocessReformattingAspect = PostprocessReformattingAspect.getInstance((Project)project);
        FileViewProvider provider2 = source.getViewProvider();
        if (!InjectedLanguageManager.getInstance((Project)project).isInjectedFragment(source) && postprocessReformattingAspect.isViewProviderLocked(provider2)) {
            postprocessReformattingAspect.doPostponedFormatting(provider2);
        }
    }

    public static void reformatTextIfNotInjected(@NotNull PsiFile source, int offset, int endOffset) {
        Project project = source.getProject();
        if (!InjectedLanguageManager.getInstance((Project)project).isInjectedFragment(source)) {
            PostprocessReformattingAspect.getInstance((Project)project).assertDocumentChangeIsAllowed(source.getViewProvider());
            CodeStyleManager.getInstance((Project)project).reformatRange((PsiElement)source, offset, endOffset, true);
        }
    }

    @Nullable
    public static String indentLineIfNotInjected(@NotNull PsiFile source, int offset) {
        Project project = source.getProject();
        if (!InjectedLanguageManager.getInstance((Project)project).isInjectedFragment(source)) {
            PostprocessReformattingAspect.getInstance((Project)project).assertDocumentChangeIsAllowed(source.getViewProvider());
            return CodeStyleManager.getInstance((Project)project).getLineIndent(source, offset);
        }
        return null;
    }

    public static OCCaretLocation removeFunctions(@NotNull Collection<OCFunctionSymbol> functions, @NotNull OCCaretLocation location) {
        if (functions.isEmpty()) {
            return location;
        }
        HashMap<PsiFile, List> toRemove = new HashMap<PsiFile, List>();
        for (OCFunctionSymbol function : functions) {
            Document d;
            OCFunctionDeclaration declaration = function.locateFunctionDefinition(location.getProject());
            if (declaration == null || declaration.getContainingFile() == null) continue;
            List ranges = toRemove.computeIfAbsent(declaration.getContainingFile(), k -> new ArrayList());
            TextRange r = declaration.getRangeWithMacros();
            PsiFile file = declaration.getContainingFile();
            if (file == null || (d = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file)) == null) continue;
            ranges.add(TextRange.create((int)r.getStartOffset(), (int)CharArrayUtil.shiftForward((CharSequence)d.getCharsSequence(), (int)r.getEndOffset(), (String)"\n")));
        }
        Ref result = Ref.create((Object)location);
        int oldOffset = location.getOffsetInFile() == null ? -1 : location.getOffsetInFile();
        ApplicationManager.getApplication().runWriteAction(() -> {
            for (Map.Entry entry : toRemove.entrySet()) {
                PsiFile file = (PsiFile)entry.getKey();
                Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
                if (document == null) continue;
                List<TextRange> ranges = OCChangeUtil.mergeRanges((List)entry.getValue(), document);
                boolean shouldFixLocation = location.getElement() != null && location.getFile().equals(file) && oldOffset >= 0;
                int locationFixup = 0;
                for (TextRange range : ranges) {
                    if (!shouldFixLocation || oldOffset <= range.getStartOffset()) continue;
                    locationFixup += Math.min(oldOffset - range.getStartOffset(), range.getLength());
                }
                int fixup = 0;
                for (TextRange range : ranges) {
                    document.deleteString(range.getStartOffset() - fixup, range.getEndOffset() - fixup);
                    fixup += range.getLength();
                }
                PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(document);
                if (!shouldFixLocation) continue;
                result.set((Object)OCCaretLocation.byOffset(location.getFile(), oldOffset - locationFixup));
            }
        });
        return (OCCaretLocation)result.get();
    }

    @NotNull
    private static List<TextRange> mergeRanges(@NotNull List<TextRange> ranges, @NotNull Document document) {
        ArrayList<TextRange> result = new ArrayList<TextRange>();
        Ref currentNotAdded = Ref.create();
        ranges.stream().sorted(Comparator.comparingInt(TextRange::getStartOffset)).forEach(range -> {
            if (!currentNotAdded.isNull()) {
                if (((TextRange)currentNotAdded.get()).intersects(range) || CharArrayUtil.isEmptyOrSpaces((CharSequence)document.getCharsSequence(), (int)((TextRange)currentNotAdded.get()).getEndOffset(), (int)range.getStartOffset())) {
                    currentNotAdded.set((Object)((TextRange)currentNotAdded.get()).union(range));
                } else {
                    result.add((TextRange)currentNotAdded.get());
                    currentNotAdded.set(range);
                }
            } else {
                currentNotAdded.set(range);
            }
        });
        if (!currentNotAdded.isNull()) {
            result.add((TextRange)currentNotAdded.get());
        }
        return result;
    }

    public static void replaceAST(@NotNull PsiElement from, @NotNull PsiElement to) {
        ASTNode oldChild = from.getNode();
        ASTNode newChild = to.getNode();
        ASTNode parent = oldChild.getTreeParent();
        parent.replaceChild(oldChild, OCChangeUtil.markNodeForPPAction(newChild, PostponedFormatAction.Format));
    }

    public static void replaceAST(@NotNull PsiElement from, ASTNode @NotNull [] to) {
        ASTNode oldChild = from.getNode();
        ASTNode parent = oldChild.getTreeParent();
        ASTNode anchor = oldChild.getTreeNext();
        parent.removeChild(oldChild);
        for (ASTNode node : to) {
            parent.addChild(OCChangeUtil.markNodeForPPAction(node, PostponedFormatAction.Format), anchor);
        }
    }

    private static void deleteChildFromList(@NotNull PsiElement parent, @NotNull PsiElement child, ParentCleanup parentCleanup) {
        ASTNode prev = TreeUtil.skipElementsBack((ASTNode)child.getNode().getTreePrev(), (TokenSet)OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET);
        if (prev != null && prev.getElementType() == OCTokenTypes.COMMA) {
            CodeEditUtil.removeChild((ASTNode)parent.getNode(), (ASTNode)prev);
        } else {
            ASTNode next = TreeUtil.skipElements((ASTNode)child.getNode().getTreeNext(), (TokenSet)OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET);
            if (next != null && next.getElementType() == OCTokenTypes.COMMA) {
                CodeEditUtil.removeChild((ASTNode)parent.getNode(), (ASTNode)next);
            } else {
                if (parentCleanup == ParentCleanup.DELETE) {
                    OCChangeUtil.delete(parent);
                    return;
                }
                if (parentCleanup == ParentCleanup.CLEAR) {
                    OCChangeUtil.clear(parent);
                    return;
                }
            }
        }
        CodeEditUtil.removeChild((ASTNode)parent.getNode(), (ASTNode)child.getNode());
    }

    public static void clear(PsiElement parent) {
        parent.deleteChildRange(parent.getFirstChild(), parent.getLastChild());
    }

    public static void deleteUnsafe(PsiElement oldElement) {
        OCChangeUtil.deleteHandlingMacros(oldElement);
    }

    private static void deleteHandlingMacros(PsiElement oldElement) {
        PsiElement oldMacroCall = OCElementUtil.getPrevSiblingOrParentSibling(oldElement);
        while (oldMacroCall instanceof OCMacroCall) {
            PsiElement node = oldMacroCall;
            oldMacroCall = oldMacroCall.getPrevSibling();
            boolean nonEmpty = node.getTextLength() > 0;
            node.delete();
            if (!nonEmpty) continue;
            break;
        }
        CodeEditUtil.removeChild((ASTNode)oldElement.getParent().getNode(), (ASTNode)oldElement.getNode());
    }

    public static PsiElement addHandlingMacros(@NotNull PsiElement parent, @NotNull PsiElement child, @Nullable PsiElement anchor, @NotNull PostponedFormatAction postponedFormatAction, boolean isBefore) {
        PsiElement childMacroCall = OCElementUtil.getPrevSiblingOrParentSibling(child);
        child = anchor == null ? parent.add(child) : (isBefore ? parent.addBefore(child, anchor) : parent.addAfter(child, anchor));
        PsiElement insertAnchor = child;
        while (childMacroCall instanceof OCMacroCall) {
            PsiElement node = childMacroCall;
            childMacroCall = childMacroCall.getPrevSibling();
            boolean nonEmpty = node.getTextLength() > 0;
            OCChangeUtil.addChild(parent.getNode(), node.getNode(), insertAnchor.getNode());
            insertAnchor = node;
            if (!nonEmpty) continue;
            break;
        }
        if (OCElementTypes.DIRECTIVES.contains(OCElementUtil.getElementType(child))) {
            OCChangeUtil.addNewLinesBeforeAndAfterIfNeed(child);
        }
        return OCChangeUtil.markElementForPPAction(child, postponedFormatAction);
    }

    public static void addNewLinesBeforeAndAfterIfNeed(@Nullable PsiElement element) {
        OCChangeUtil.addNewLineIfNeed(element, false);
        OCChangeUtil.addNewLineIfNeed(element, true);
    }

    public static void addNewLineIfNeed(@Nullable PsiElement element, boolean after2) {
        if (element != null) {
            PsiElement sibling;
            PsiElement psiElement = sibling = after2 ? element.getNextSibling() : element.getPrevSibling();
            if (sibling != null && !sibling.getText().startsWith("\n") || sibling == null && after2) {
                PsiFile file = element.getContainingFile();
                PsiElement parent = element.getParent();
                if (parent != null) {
                    PsiElement newLine = OCElementFactory.newlineFromText((PsiElement)file);
                    if (after2) {
                        parent.addAfter(newLine, element);
                    } else {
                        parent.addBefore(newLine, element);
                    }
                }
            }
        }
    }

    @NotNull
    public static PsiElement copyHandlingMacros(@NotNull PsiElement element) {
        OCStatement copy2 = OCElementFactory.statementFromText(";", element);
        copy2 = OCChangeUtil.replaceHandlingMacros(copy2, element);
        return copy2;
    }

    public static PsiElement replaceHandlingMacros(PsiElement oldElement, PsiElement newElement) {
        if (oldElement == null || newElement == null) {
            return oldElement;
        }
        PsiElement oldMacroCall = OCElementUtil.getPrevSiblingOrParentSibling(oldElement);
        PsiElement newMacroCall = OCElementUtil.getPrevSiblingOrParentSibling(newElement);
        PsiElement insertAnchor = oldElement;
        while (newMacroCall instanceof OCMacroCall) {
            PsiElement node = newMacroCall;
            newMacroCall = newMacroCall.getPrevSibling();
            boolean nonEmpty = node.getTextLength() > 0;
            insertAnchor = oldElement.getParent().addBefore(node, insertAnchor);
            if (!nonEmpty) continue;
            break;
        }
        return OCChangeUtil.replaceOverwritingMacros(oldElement, newElement, oldMacroCall);
    }

    private static PsiElement replaceOverwritingMacros(PsiElement oldElement, PsiElement newElement, PsiElement oldMacroCall) {
        while (oldMacroCall instanceof OCMacroCall) {
            PsiElement node = oldMacroCall;
            oldMacroCall = oldMacroCall.getPrevSibling();
            boolean nonEmpty = node.getTextLength() > 0;
            CodeEditUtil.removeChild((ASTNode)node.getParent().getNode(), (ASTNode)node.getNode());
            if (!nonEmpty) continue;
            break;
        }
        return OCChangeUtil.markElementForPPAction(oldElement.replace(newElement), PostponedFormatAction.Format);
    }

    public static void replaceCallArgument(OCExpression toArgument, OCExpression fromArgument) {
        PsiElement existingMacroCall = OCElementUtil.getPrevSiblingOrParentSibling(toArgument);
        OCChangeUtil.copyElementsAfterArgument(toArgument, fromArgument);
        OCChangeUtil.copyElementsBeforeArgument(toArgument, fromArgument);
        OCChangeUtil.replaceOverwritingMacros(toArgument, fromArgument, existingMacroCall);
    }

    private static void copyElementsBeforeArgument(OCExpression toArgument, OCExpression fromArgument) {
        PsiElement prev;
        OCExpression copyStart = fromArgument;
        while ((prev = copyStart.getPrevSibling()) != null && !OCTokenTypes.ARGUMENT_LIST_DELIMITERS.contains(prev.getNode().getElementType())) {
            copyStart = prev;
        }
        while (copyStart != fromArgument) {
            if (copyStart instanceof OCMacroCall || OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(copyStart.getNode().getElementType())) {
                toArgument.getParent().addBefore((PsiElement)copyStart, (PsiElement)toArgument);
            }
            copyStart = copyStart.getNextSibling();
        }
    }

    private static void copyElementsAfterArgument(OCExpression toArgument, OCExpression fromArgument) {
        PsiElement next;
        OCExpression copyEnd = fromArgument;
        while ((next = copyEnd.getNextSibling()) != null && !OCTokenTypes.ARGUMENT_LIST_DELIMITERS.contains(next.getNode().getElementType())) {
            copyEnd = next;
        }
        while (copyEnd != fromArgument) {
            if (copyEnd instanceof OCMacroCall || OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(copyEnd.getNode().getElementType())) {
                toArgument.getParent().addAfter((PsiElement)copyEnd, (PsiElement)toArgument);
            }
            copyEnd = copyEnd.getPrevSibling();
        }
    }

    public static void safeDeleteReference(PsiElement element) {
        if (element instanceof OCReferenceElement) {
            element = element.getParent();
        }
        if (element instanceof OCSendMessageExpression) {
            List<OCExpression> arguments = ((OCSendMessageExpression)element).getArgumentExpressions();
            OCMethodSymbol responder = ((OCSendMessageExpression)element).getProbableResponders().getKnownResponder();
            PsiElement statement = OCParenthesesUtils.topmostParenthesized((OCExpression)element).getParent();
            if (arguments.size() == 1 && (responder == null || responder.isSynthetic() && responder.getAssociatedSymbol(element.getProject()) == null)) {
                OCExpression argument = arguments.get(0);
                if (statement instanceof OCExpressionStatement) {
                    if (!OCCodeInsightUtil.hasSideEffects(argument)) {
                        OCChangeUtil.safeDeleteStatement((OCStatement)statement);
                    } else {
                        OCChangeUtil.replaceHandlingMacros(((OCExpressionStatement)statement).getExpression(), argument);
                    }
                }
            }
        } else if (element instanceof OCReferenceExpression || element instanceof OCQualifiedExpression) {
            PsiElement assignment = OCParenthesesUtils.topmostParenthesized((OCExpression)element).getParent();
            if (!(assignment instanceof OCAssignmentExpression)) {
                return;
            }
            PsiElement statement = OCParenthesesUtils.topmostParenthesized((OCExpression)assignment).getParent();
            OCExpression sourceExpression = ((OCAssignmentExpression)assignment).getSourceExpression();
            if (statement instanceof OCExpressionStatement && (sourceExpression == null || !OCCodeInsightUtil.hasSideEffects(sourceExpression))) {
                OCChangeUtil.safeDeleteStatement((OCStatement)statement);
            } else {
                OCChangeUtil.replaceHandlingMacros(assignment, sourceExpression);
            }
        }
    }

    public static void safeDeleteStatement(OCStatement statement) {
        PsiElement parent = statement.getParent();
        if (OCChangeUtil.isElseBranchStatement(statement)) {
            CodeEditUtil.removeChildren((ASTNode)parent.getNode(), (ASTNode)Objects.requireNonNull(((OCIfStatement)parent).getElseKeyword()), (ASTNode)statement.getNode());
        } else if (parent instanceof OCBlockStatement) {
            if (((OCBlockStatement)parent).getStatements().size() == 1 && OCChangeUtil.isElseBranchStatement((OCStatement)parent)) {
                OCChangeUtil.safeDeleteStatement((OCStatement)parent);
            } else {
                OCChangeUtil.delete(statement);
            }
        } else {
            OCChangeUtil.replaceHandlingMacros(statement, OCElementFactory.statementFromText(";", statement));
        }
    }

    private static boolean isElseBranchStatement(OCStatement statement) {
        return statement.getParent() instanceof OCIfStatement && ((OCIfStatement)statement.getParent()).getElseBranch() == statement;
    }

    public static void addChild(@NotNull ASTNode parent, @NotNull ASTNode child, @Nullable ASTNode anchorBefore) {
        CodeEditUtil.addChild((ASTNode)parent, (ASTNode)OCChangeUtil.markNodeForPPAction(child, PostponedFormatAction.Format), (ASTNode)anchorBefore);
    }

    public static void replaceChild(@NotNull ASTNode parent, @NotNull ASTNode oldChild, @NotNull ASTNode newChild) {
        CodeEditUtil.replaceChild((ASTNode)parent, (ASTNode)oldChild, (ASTNode)OCChangeUtil.markNodeForPPAction(newChild, PostponedFormatAction.Format));
    }

    @Contract(value="null, _ -> null")
    public static <T extends PsiElement> T markElementForPPAction(@Nullable T element, @NotNull PostponedFormatAction postFormatAction) {
        if (element != null) {
            OCChangeUtil.markNodeForPPAction(element.getNode(), postFormatAction);
        }
        return element;
    }

    @Contract(value="_, _ -> param1")
    public static <T extends ASTNode> T markNodeForPPAction(@Nullable T node, @NotNull PostponedFormatAction postFormatAction) {
        if (node != null) {
            switch (postFormatAction) {
                case NoFormat: {
                    CodeEditUtil.setNodeGeneratedRecursively(node, (CodeEditUtil.getOldIndentation(node) < 0 ? 1 : 0) != 0);
                    break;
                }
                case Format: {
                    CodeEditUtil.setNodeGeneratedRecursively(node, (boolean)true);
                    break;
                }
                case Indent: {
                    ASTNode parent = node.getTreeParent();
                    if (parent != null && CodeEditUtil.isNodeGenerated((ASTNode)parent) && !CodeEditUtil.isMarkedToReformatBefore((TreeElement)((TreeElement)parent))) {
                        CodeEditUtil.markToReformatBefore((ASTNode)parent, (boolean)true);
                    }
                    CodeEditUtil.setNodeGenerated(node, (CodeEditUtil.getOldIndentation(node) < 0 ? 1 : 0) != 0);
                }
            }
        }
        return node;
    }

    static enum ParentCleanup {
        LEAVE,
        DELETE,
        CLEAR;

    }

    public static enum PostponedFormatAction {
        NoFormat,
        Format,
        Indent;

    }
}

