/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.unwrap;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.psi.OCCatchSection;
import com.jetbrains.cidr.lang.psi.OCTryStatement;
import com.jetbrains.cidr.lang.refactoring.unwrap.OCUnwrapper;
import org.jetbrains.annotations.NotNull;

public class OCCatchRemover
extends OCUnwrapper {
    public OCCatchRemover() {
        super(CodeInsightBundle.message((String)"remove.catch", (Object[])new Object[0]));
    }

    public boolean isApplicableTo(@NotNull PsiElement e) {
        return e instanceof OCCatchSection && OCCatchRemover.tryHasSeveralCatches(e);
    }

    private static boolean tryHasSeveralCatches(PsiElement el) {
        PsiElement parent = el.getParent();
        if (parent instanceof OCTryStatement) {
            OCTryStatement tryStatement = (OCTryStatement)parent;
            return tryStatement.getCatchSections().size() > 1;
        }
        return false;
    }

    protected void doUnwrap(PsiElement element, OCUnwrapper.Context context) throws IncorrectOperationException {
        context.deleteExactly(element);
    }
}

