/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.rename;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.refactoring.RefactoringBundle;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.parser.OCMacroRange;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.resolve.OCCompilerGeneratedFunctionSymbol;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.settings.OCRefactoringSettings;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class OCRenameUtil {
    public static final Key<CachedValue<Ref<Boolean>>> RENAME_SAME_ENTITY_CACHE = Key.create((String)"RENAME_SAME_ENTITY_CACHE");

    public static boolean isInProjectSources(@Nullable PsiElement element) {
        if (element == null || element.getContainingFile() == null || element.getContainingFile().getVirtualFile() == null) {
            return true;
        }
        return OCSearchScope.isInProjectSources(element);
    }

    @Nullable
    public static OCSymbol getSymbolToRename(@NotNull PsiElement element) {
        OCSymbol symbol = null;
        if (element instanceof OCSymbolDeclarator) {
            symbol = (OCSymbol)((OCSymbolDeclarator)element).getSymbol();
        } else {
            PsiReference maybeOperatorRef = element.getReference();
            if (maybeOperatorRef instanceof OCOperatorReference) {
                symbol = (OCSymbol)((OCOperatorReference)maybeOperatorRef).resolveToSymbol();
            }
        }
        return OCCompilerGeneratedFunctionSymbol.unwrap(symbol);
    }

    public static boolean shouldRenameSameClassOrFileEntity(@NotNull PsiElement element) {
        Ref<Boolean> cache = OCRenameUtil.getRenameSameEntityCache(element);
        return !cache.isNull() && (Boolean)cache.get() != false;
    }

    public static boolean symbolHasSameNameWithFile(@NotNull String symbolName, @NotNull OCSymbolKind symbolKind, @NotNull PsiFile file) {
        String name = symbolKind.isConstructorOrDestructor() ? StringUtil.trimStart((String)symbolName, (String)"~") : symbolName;
        return FileUtilRt.getNameWithoutExtension((String)file.getName()).equals(name);
    }

    @Nullable
    private static String needToSearchInMacros(@NotNull PsiElement element) {
        Ref macroName = new Ref();
        ReferencesSearch.search((PsiElement)element).forEach(usage -> {
            OCMacroRange range = OCElementUtil.getRangeInMacroCall(usage.getElement());
            if (range != null && !range.mapsToArguments()) {
                OCReferenceElement macro = range.getMacroCall().getMacroReferenceElement();
                macroName.set((Object)(macro != null ? macro.getName() : "unnamed"));
            }
        });
        return (String)macroName.get();
    }

    public static boolean askToRenameSameEntityIfNeed(@NotNull PsiElement element) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        PsiFile file = element.getContainingFile();
        Ref<Boolean> cache = OCRenameUtil.getRenameSameEntityCache((PsiElement)file);
        if (!OCRenameUtil.isInProjectSources(element)) {
            cache.set((Object)false);
            return true;
        }
        Supplier<Boolean> supplier = null;
        if (element instanceof OCFile) {
            OCFile headerFile;
            OCFile ocFile = (OCFile)element;
            OCFile oCFile = headerFile = ocFile.isHeader() ? ocFile : ocFile.getAssociatedFileWithSameName();
            if (headerFile != null && headerFile.getSameNamedClass() != null) {
                supplier = () -> OCRenameUtil.askToRenameSameNamedClass();
            }
        } else if (element instanceof OCStructLike) {
            OCStructSymbol structSymbol = (OCStructSymbol)((OCStructLike)element).getSymbol();
            if (structSymbol != null && OCRenameUtil.symbolHasSameNameWithFile(structSymbol.getName(), structSymbol.getKind(), file)) {
                supplier = () -> OCRenameUtil.askToRenameSameNamedFile(file.getProject());
            }
        } else if (element instanceof OCDeclarator) {
            String macroName;
            OCSymbol declaratorSymbol = ((OCDeclarator)element).getSymbol();
            if (declaratorSymbol != null && declaratorSymbol.getKind().isConstructorOrDestructor() && OCRenameUtil.symbolHasSameNameWithFile(declaratorSymbol.getName(), declaratorSymbol.getKind(), file)) {
                supplier = () -> OCRenameUtil.askToRenameSameNamedFile(file.getProject());
            }
            if (declaratorSymbol != null && declaratorSymbol.getKind().isLocal() && (macroName = OCRenameUtil.needToSearchInMacros(element)) != null) {
                int choice = OCRenameUtil.askToSearchForMacros(macroName, element.getProject());
                if (choice == 2) {
                    return false;
                }
                cache.set((Object)(choice == 0 ? 1 : 0));
            }
        }
        if (supplier == null) {
            return true;
        }
        Supplier<Boolean> finalSupplier = supplier;
        ApplicationManager.getApplication().invokeAndWait(() -> cache.set((Object)((Boolean)finalSupplier.get())));
        return true;
    }

    @TestOnly
    public static Ref<Boolean> getRenameSameEntityCacheForTests(@NotNull PsiElement element) {
        return OCRenameUtil.getRenameSameEntityCache(element);
    }

    private static Ref<Boolean> getRenameSameEntityCache(@NotNull PsiElement element) {
        CachedValuesManager manager = CachedValuesManager.getManager((Project)element.getProject());
        ModificationTracker modificationTracker = FileSymbolTablesCache.getInstance(element.getProject()).getOutOfBlockModificationTracker();
        CachedValueProvider provider2 = () -> new CachedValueProvider.Result((Object)Ref.create(), new Object[]{modificationTracker});
        return (Ref)manager.getCachedValue((UserDataHolder)element.getContainingFile(), RENAME_SAME_ENTITY_CACHE, provider2, false);
    }

    private static boolean askToRenameSameNamedFile(@NotNull Project project) {
        String message = OCRefactoringSettings.getInstance().RENAME_ASSOCIATED_FILES ? OCBundle.message("rename.renameAssociatedFiles", new Object[0]) : OCBundle.message("rename.renameContainingFile", new Object[0]);
        return MessageDialogBuilder.yesNo((String)RefactoringBundle.message((String)"rename.title"), (String)message).show() == 0;
    }

    private static boolean askToRenameSameNamedClass() {
        return MessageDialogBuilder.yesNo((String)RefactoringBundle.message((String)"rename.title"), (String)OCBundle.message("rename.renameAssociatedClass", new Object[0])).show() == 0;
    }

    private static int askToSearchForMacros(String macroName, @NotNull Project project) {
        String title = RefactoringBundle.message((String)"rename.title");
        String message = OCBundle.message("rename.searchForMacros", macroName);
        return MessageDialogBuilder.yesNoCancel((String)title, (String)message).show(project);
    }
}

