/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.move.ui;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.classMembers.MemberInfoChange;
import com.intellij.refactoring.classMembers.MemberInfoChangeListener;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.OCRefactoringBundle;
import com.jetbrains.cidr.lang.formatting.OCFormattingModelBuilder;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCCppBaseClauseList;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.refactoring.move.OCMemberInfo;
import com.jetbrains.cidr.lang.refactoring.move.OCMemberInfoStorage;
import com.jetbrains.cidr.lang.refactoring.move.OCMoveProcessor;
import com.jetbrains.cidr.lang.refactoring.move.ui.OCMemberSelectionPanel;
import com.jetbrains.cidr.lang.refactoring.move.ui.OCMoveMembersDialog;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolderVirtualPsiElement;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCAbstractMoveDialog
extends RefactoringDialog {
    protected OCMemberInfoStorage myStorage;
    protected List<OCMemberInfo> myMemberInfos;
    protected MemberInfoModel<OCSymbolHolderVirtualPsiElement, OCMemberInfo> myMemberInfoModel;
    protected OCFile mySourceFile;
    protected final OCSymbolDeclarator mySourceClass;
    protected OCSymbol myClassSymbol;
    private Condition<PsiElement> mySelectedCondition;
    private boolean myEnableValidation;
    protected OCMemberSelectionPanel myMemberSelectionPanel;

    protected OCAbstractMoveDialog(@Nullable OCSymbolDeclarator clazz, @Nullable OCSymbol classSymbol, Condition<PsiElement> selectedCondition, Project project) {
        super(project, true);
        this.mySourceClass = clazz;
        this.mySourceFile = clazz != null ? (OCFile)clazz.getContainingFile() : null;
        this.mySelectedCondition = selectedCondition;
        this.setRefactorButtonText(this.getOKButtonText());
        this.myStorage = new OCMemberInfoStorage(clazz, !(this instanceof OCMoveMembersDialog));
        this.myMemberInfoModel = this.createModel();
        this.myClassSymbol = classSymbol;
    }

    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        this.myMemberSelectionPanel = new OCMemberSelectionPanel(this.myMemberInfos, null);
        panel2.add((Component)this.myMemberSelectionPanel, "Center");
        this.myMemberSelectionPanel.getTable().setMemberInfoModel(this.myMemberInfoModel);
        for (MemberInfoModel<OCSymbolHolderVirtualPsiElement, OCMemberInfo> memberInfoModel : this.getAllModels()) {
            this.myMemberSelectionPanel.getTable().addMemberInfoChangeListener((MemberInfoChangeListener)memberInfoModel);
        }
        this.myMemberInfoModel.memberInfoChanged(new MemberInfoChange(this.myMemberInfos));
        this.myMemberSelectionPanel.getTable().addMemberInfoChangeListener((MemberInfoChangeListener)new MemberInfoChangeListener<OCSymbolHolderVirtualPsiElement, OCMemberInfo>(){

            public void memberInfoChanged(@NotNull MemberInfoChange<OCSymbolHolderVirtualPsiElement, OCMemberInfo> event) {
                OCAbstractMoveDialog.this.validateButtons();
            }
        });
        return panel2;
    }

    protected List<? extends MemberInfoModel<OCSymbolHolderVirtualPsiElement, OCMemberInfo>> getAllModels() {
        return Collections.singletonList(this.myMemberInfoModel);
    }

    protected final void canRun() throws ConfigurationException {
        if (!this.myEnableValidation) {
            return;
        }
        this.checkCanRun();
    }

    public void checkCanRun() throws ConfigurationException {
        if (!this.allowsEmptySelection() && this.getSelectedMemberInfos().isEmpty()) {
            String message = OCRefactoringBundle.message("refactoring.move.no.members.are.selected.error", new Object[0]);
            throw new ConfigurationException(message);
        }
    }

    public boolean checkConflicts() {
        return true;
    }

    protected void doAction() {
        this.myEnableValidation = true;
        this.validateButtons();
        if (this.getRefactorAction().isEnabled() && this.checkConflicts()) {
            this.invokeRefactoring();
            this.closeOKAction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Pair<OCFile[], String> invokeRefactoring() {
        OCMoveProcessor processor = this.createProcessor();
        if (processor != null) {
            MultiMap<PsiElement, String> conflicts = this.getConflicts();
            processor.setConflicts(conflicts);
            StringBuilder conflictsBuilder = new StringBuilder();
            for (OCMemberInfo info : this.myMemberInfos) {
                if (this.myMemberInfoModel.checkForProblems((MemberInfoBase)info) == 1) {
                    conflictsBuilder.append("Warning: ").append(info.getDisplayName()).append("\n");
                }
                if (this.isMemberEnabled(info)) continue;
                conflictsBuilder.append("Disabled: ").append(info.getDisplayName()).append("\n");
            }
            try {
                OCFormattingModelBuilder.requestAlwaysCreateFullModel();
                this.invokeRefactoring(processor);
            }
            finally {
                OCFormattingModelBuilder.releaseAlwaysCreateFullModel();
            }
            ArrayList conflictStrings = new ArrayList(conflicts.values());
            Collections.sort(conflictStrings);
            for (String message : conflictStrings) {
                conflictsBuilder.append("Error: ").append(message).append("\n");
            }
            return Pair.create((Object)processor.getCreatedFiles(), (Object)conflictsBuilder.toString());
        }
        return null;
    }

    @Nullable
    protected abstract OCMoveProcessor createProcessor();

    @NlsContexts.Button
    protected abstract String getOKButtonText();

    protected boolean hasPreviewButton() {
        return true;
    }

    public boolean allowsEmptySelection() {
        return false;
    }

    protected abstract MemberInfoModel<OCSymbolHolderVirtualPsiElement, OCMemberInfo> createModel();

    protected abstract String getConflictMessage(OCMemberInfo var1, OCSymbol var2);

    protected MultiMap<PsiElement, String> getConflicts() {
        MultiMap conflicts = new MultiMap();
        for (OCMemberInfo info : this.myMemberInfos) {
            String message;
            Object symbol;
            PsiElement element;
            if (this.myMemberInfoModel.checkForProblems((MemberInfoBase)info) != 2 || (element = (symbol = ((OCSymbolHolderVirtualPsiElement)info.getMember()).getSymbol()).locateDefinition(this.myProject)) == null || (message = this.getConflictMessage(info, (OCSymbol)symbol)) == null) continue;
            conflicts.putValue((Object)element, (Object)message);
        }
        return conflicts;
    }

    public List<OCMemberInfo> getMemberInfos() {
        return this.myMemberInfos;
    }

    public List<OCMemberInfo> getSelectedMemberInfos() {
        ArrayList<OCMemberInfo> result = new ArrayList<OCMemberInfo>(this.myMemberInfos.size());
        for (OCMemberInfo info : this.myMemberInfos) {
            if (!info.isChecked() || !this.isMemberEnabled(info)) continue;
            result.add(info);
        }
        return result;
    }

    protected boolean isMemberEnabled(OCMemberInfo member) {
        return true;
    }

    protected boolean selectAllMembers() {
        return false;
    }

    protected void setMembersChecked() {
        if (this.selectAllMembers()) {
            for (OCMemberInfo info : this.myMemberInfos) {
                info.setChecked(this.myMemberInfoModel.checkForProblems((MemberInfoBase)info) == 0 && this.isMemberEnabled(info));
            }
            return;
        }
        for (OCMemberInfo member : this.myMemberInfos) {
            if (!this.isMemberEnabled(member)) {
                member.setChecked(false);
                continue;
            }
            OCSymbol memberSymbol = member.getSymbol();
            if (this.mySourceClass instanceof OCClassDeclaration && memberSymbol instanceof OCProtocolSymbol) {
                PsiElement element = (PsiElement)ContainerUtil.find(((OCClassDeclaration)this.mySourceClass).getProtocolList().getProtocols(), element12 -> element12.getName().equals(memberSymbol.getName()));
                member.setChecked(this.mySelectedCondition.value((Object)element));
                continue;
            }
            if (this.mySourceClass instanceof OCStruct && memberSymbol instanceof OCStructSymbol && ((OCStructSymbol)memberSymbol).getParent() != this.myClassSymbol) {
                OCCppBaseClauseList baseClausesList = ((OCStruct)this.mySourceClass).getBaseClausesList();
                PsiElement element = baseClausesList != null ? (PsiElement)ContainerUtil.find(baseClausesList.getBaseClauses(), clause -> {
                    OCReferenceElement element1 = clause.getReferenceElement();
                    return element1 != null && element1.getName().equals(memberSymbol.getName());
                }) : null;
                member.setChecked(this.mySelectedCondition.value((Object)element));
                continue;
            }
            if (memberSymbol == null) continue;
            memberSymbol.processSameSymbols((Processor<OCSymbol>)((Processor)symbol -> {
                if (memberSymbol instanceof OCClassSymbol && !((OCClassSymbol)memberSymbol).isSameCategory((OCSymbol)symbol)) {
                    return true;
                }
                if (this.mySelectedCondition.value((Object)symbol.locateDefinition(this.myProject))) {
                    member.setChecked(true);
                }
                return true;
            }), this.myProject);
        }
    }
}

