/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.move;

import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCRefactoringBundle;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCCopyMoveProcessor<M, R, G extends R, P> {
    protected Set<PsiElement> myElements;
    protected Helper<M, R, G, P> myHelper = this.getHelper();

    protected OCCopyMoveProcessor(PsiElement[] elements) {
        this.myElements = ContainerUtil.set((Object[])elements);
        for (PsiElement element : elements) {
            if (!(element instanceof OCFile)) continue;
            VirtualFile virtualFile = ((OCFile)element).getVirtualFile();
            P project = this.myHelper.getProjectFile(elements[0].getProject(), virtualFile);
            OCFile associatedFile = ((OCFile)element).getAssociatedFile();
            if (associatedFile == null) continue;
            VirtualFile associatedVirtualFile = associatedFile.getVirtualFile();
            if (project != null && virtualFile != null && associatedVirtualFile != null) {
                Object reference = ContainerUtil.getFirstItem(this.myHelper.findReferences(virtualFile, project));
                Object associatedReference = ContainerUtil.getFirstItem(this.myHelper.findReferences(associatedVirtualFile, project));
                if (reference != null && associatedReference != null && !this.myHelper.areFromSameParent(reference, associatedReference)) continue;
            }
            if (associatedFile.getContainingDirectory() != ((OCFile)element).getContainingDirectory()) continue;
            this.myElements.add(associatedFile);
        }
    }

    public void process(Project project, PsiElement targetContainer) {
        ArrayList<VirtualFile> notInProjectFiles = new ArrayList<VirtualFile>();
        for (PsiElement element : this.myElements) {
            VirtualFile file;
            if (Comparing.equal((Object)element, (Object)targetContainer)) {
                return;
            }
            if (this.myHelper.isGroupElement(element)) continue;
            if (element instanceof PsiFile) {
                file = ((PsiFile)element).getVirtualFile();
            } else {
                if (!(element instanceof PsiDirectory)) continue;
                file = ((PsiDirectory)element).getVirtualFile();
            }
            if (file == null || OCSearchScope.getProjectSourcesScope(project).contains(file)) continue;
            notInProjectFiles.add(file);
        }
        if (!notInProjectFiles.isEmpty()) {
            Object projectFile;
            PsiDirectory targetDirectory = null;
            Object targetGroup = null;
            if (this.myHelper.isGroupElement(targetContainer)) {
                Pair<G, P> pair = this.myHelper.takeFromGroupElement(targetContainer);
                targetGroup = pair.getFirst();
                projectFile = pair.getSecond();
                targetDirectory = this.myHelper.targetDirectoryFor(targetContainer);
            } else {
                if (targetContainer instanceof PsiDirectory) {
                    targetDirectory = (PsiDirectory)targetContainer;
                } else if (targetContainer != null) {
                    PsiFile file = targetContainer.getContainingFile();
                    PsiDirectory psiDirectory = targetDirectory = file != null ? file.getContainingDirectory() : null;
                }
                if (targetDirectory == null) {
                    return;
                }
                VirtualFile directoryFile = targetDirectory.getVirtualFile();
                projectFile = this.myHelper.getProjectFile(project, directoryFile);
            }
            if (projectFile != null) {
                this.doActionForExternalFiles(project, projectFile, notInProjectFiles, targetGroup, targetDirectory);
            }
        } else if (targetContainer instanceof PsiDirectory || this.myHelper.isGroupElement(targetContainer)) {
            boolean allValid;
            Object targetProjectFile;
            Object targetGroup;
            ArrayList<R> sourceRefs = new ArrayList<R>();
            if (this.myHelper.isGroupElement(targetContainer)) {
                Pair<G, P> pair = this.myHelper.takeFromGroupElement(targetContainer);
                targetGroup = pair.getFirst();
                targetProjectFile = pair.getSecond();
            } else {
                Object dir = ((PsiDirectory)targetContainer).getVirtualFile();
                while ((targetProjectFile = this.myHelper.getProjectFile(project, (VirtualFile)dir)) == null && (dir = dir.getParent()) != null) {
                }
                if (targetProjectFile == null) {
                    return;
                }
                Collection<R> references = this.myHelper.findReferences((VirtualFile)dir, targetProjectFile);
                Object targetRef = null;
                targetGroup = this.myHelper.getTargetGroup(references, targetRef);
            }
            if (this.myHelper.badTargetGroup(targetGroup)) {
                return;
            }
            for (PsiElement element : this.myElements) {
                R sourceRef = this.getSourceRef(element, targetGroup);
                if (sourceRef == null) continue;
                sourceRefs.add(sourceRef);
            }
            boolean bl = allValid = this.myElements.size() == sourceRefs.size();
            if (allValid && !sourceRefs.isEmpty()) {
                Object finalTargetProjectFile = targetProjectFile;
                CommandProcessor.getInstance().executeCommand(project, () -> this.doAction(this.myHelper, finalTargetProjectFile, this.myHelper.targetDirectoryFor(targetContainer), targetGroup, sourceRefs), null, null);
            }
        }
    }

    protected abstract Helper<M, R, G, P> getHelper();

    @Nullable
    R getSourceRef(PsiElement element, G targetGroup) {
        if (!this.myHelper.isGroupElement(element)) {
            VirtualFile sourceFile;
            Object projectFile = null;
            if (element instanceof PsiFile) {
                sourceFile = ((PsiFile)element).getVirtualFile();
            } else if (element instanceof PsiDirectory) {
                sourceFile = ((PsiDirectory)element).getVirtualFile();
                if (this.myHelper.isGroupElement(element)) {
                    projectFile = this.myHelper.takeFromGroupElement(element).getSecond();
                }
            } else {
                return null;
            }
            if (sourceFile == null) {
                return null;
            }
            if (projectFile == null) {
                projectFile = this.myHelper.getProjectFile(element.getProject(), sourceFile);
            }
            return (R)(projectFile == null ? null : ContainerUtil.getFirstItem(this.myHelper.findReferences(sourceFile, projectFile)));
        }
        return this.myHelper.getSourceRefFromGroupElement(element, targetGroup);
    }

    @Nullable
    @NlsContexts.DialogMessage
    public static String checkOperationIsValid(@NotNull PsiFileSystemItem source, @NotNull PsiDirectory target, @NotNull String newName, boolean canBeRenamed, boolean isMove) {
        VirtualFile sourceFile = source.getVirtualFile();
        VirtualFile targetFile = target.getVirtualFile();
        if (sourceFile != null && VfsUtilCore.isAncestor((VirtualFile)sourceFile, (VirtualFile)targetFile, (boolean)false)) {
            if (isMove) {
                return OCRefactoringBundle.message("dialog.message.can.t.move.to.itself", sourceFile.getPath());
            }
            return OCRefactoringBundle.message("dialog.message.can.t.copy.to.itself", sourceFile.getPath());
        }
        if (isMove && sourceFile != null && sourceFile.getParent().equals(targetFile) && sourceFile.getName().equals(newName)) {
            return null;
        }
        if (canBeRenamed) {
            return null;
        }
        File existing = new File(targetFile.getPath(), newName);
        if (existing.exists()) {
            if (sourceFile != null) {
                if (existing.isDirectory()) {
                    return OCRefactoringBundle.message("dialog.message.directory.already.exists.at", existing.getPath());
                }
                return OCRefactoringBundle.message("dialog.message.file.already.exists.at", existing.getPath());
            }
            return OCRefactoringBundle.message("dialog.message.file.already.exists", new Object[0]);
        }
        return null;
    }

    protected abstract void doActionForExternalFiles(Project var1, @NotNull P var2, @NotNull List<VirtualFile> var3, @Nullable G var4, @NotNull PsiDirectory var5);

    protected abstract void doAction(@NotNull Helper<M, R, G, P> var1, @NotNull P var2, @NotNull PsiDirectory var3, @NotNull G var4, @NotNull List<R> var5);

    public static interface Helper<M, R, G extends R, P> {
        public boolean isGroupElement(PsiElement var1);

        public Pair<G, P> takeFromGroupElement(PsiElement var1);

        public PsiDirectory targetDirectoryFor(PsiElement var1);

        @Nullable
        public R getSourceRefFromGroupElement(PsiElement var1, G var2);

        public M getManipulator(P var1);

        public void completeManipulation(@NotNull M var1);

        public Collection<R> findReferences(VirtualFile var1, P var2);

        public boolean areFromSameParent(R var1, R var2);

        public P getProjectFile(Project var1, VirtualFile var2);

        public G getTargetGroup(Collection<R> var1, R var2);

        public boolean badTargetGroup(G var1);
    }
}

