/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.inline;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.OCRefactoringBundle;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCLambdaExpression;
import com.jetbrains.cidr.lang.psi.OCMessageArgument;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureActionHandler;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureHandler;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCFunctionUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCMethodCallUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCMethodDotCallUsage;
import com.jetbrains.cidr.lang.refactoring.inline.OCInlineActionHandlerBase;
import com.jetbrains.cidr.lang.refactoring.inline.OCInlineMethodHandler;
import com.jetbrains.cidr.lang.refactoring.move.OCCodeMoveValidator;
import com.jetbrains.cidr.lang.search.OCSearchUtil;
import com.jetbrains.cidr.lang.search.usages.OCReadWriteAccessDetector;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class OCInlineParameterHandler
extends OCInlineActionHandlerBase<PsiNamedElement> {
    @Override
    protected String getElementKind(PsiNamedElement element) {
        return "parameter";
    }

    public boolean canInlineElement(PsiElement element) {
        if (!(element instanceof OCDeclarator) && !(element instanceof OCMethodSelectorPart)) {
            return false;
        }
        Object symbol = ((OCSymbolDeclarator)element).getSymbol();
        return symbol instanceof OCDeclaratorSymbol && symbol.getKind() == OCSymbolKind.PARAMETER;
    }

    private static int getParamIndex(PsiNamedElement element, OCCallable callable) {
        if (callable instanceof OCMethod) {
            return ((OCMethod)callable).getParameters().indexOf((OCMethodSelectorPart)element);
        }
        if (callable instanceof OCFunctionDeclaration) {
            return callable.getParameterList().getParameterDeclarations().indexOf(element.getParent());
        }
        if (callable instanceof OCBlockExpression) {
            return callable.getParameterList().getParameterDeclarations().indexOf(element.getParent());
        }
        if (callable instanceof OCLambdaExpression) {
            return callable.getParameterList().getParameterDeclarations().indexOf(element.getParent());
        }
        return -1;
    }

    @Override
    protected boolean allowInlineSingleUsage() {
        return false;
    }

    protected boolean validateFunctionUsages() {
        return true;
    }

    @Override
    protected String checkValidness(@NotNull PsiNamedElement element, @NotNull List<PsiElement> usages, PsiElement selectedUsage, @NotNull @NlsSafe String elementNameWithKind, Editor editor, @NotNull Ref<PsiElement> elementData, @NotNull List<@NlsContexts.DetailedDescription String> warnings, boolean silentMode) {
        String superMessage = super.checkValidness(element, usages, selectedUsage, elementNameWithKind, editor, elementData, warnings, silentMode);
        if (superMessage != null) {
            return superMessage;
        }
        for (PsiElement usage : usages) {
            PsiElement parent;
            if (new OCReadWriteAccessDetector().getExpressionAccess(usage) != ReadWriteAccessDetector.Access.Read) {
                if (editor != null) {
                    OCInlineParameterHandler.highlightUsages(element.getProject(), editor, Collections.singletonList(usage), EditorColors.WRITE_SEARCH_RESULT_ATTRIBUTES);
                }
                OCInlineParameterHandler.showHighlightRemovalStatus(element.getProject());
                return OCRefactoringBundle.message("dialog.message.accessed.for.writing", StringUtil.capitalize((String)elementNameWithKind));
            }
            if (!(usage.getParent() instanceof OCExpression) || !((parent = OCParenthesesUtils.topmostParenthesized((OCExpression)usage.getParent()).getParent()) instanceof OCUnaryExpression) || !((OCUnaryExpression)parent).isGetAddress()) continue;
            if (editor != null) {
                OCInlineParameterHandler.highlightUsages(element.getProject(), editor, Collections.singletonList(usage), EditorColors.WRITE_SEARCH_RESULT_ATTRIBUTES);
            }
            OCInlineParameterHandler.showHighlightRemovalStatus(element.getProject());
            return OCRefactoringBundle.message("dialog.message.accessed.for.address", StringUtil.capitalize((String)elementNameWithKind));
        }
        OCCallable callable = (OCCallable)PsiTreeUtil.getParentOfType((PsiElement)element, OCCallable.class);
        if (callable == null) {
            return OCRefactoringBundle.message("dialog.message.cannot.find.method.function", new Object[0]);
        }
        if (callable instanceof OCBlockExpression) {
            return OCRefactoringBundle.message("dialog.message.cannot.inline.parameters.blocks", new Object[0]);
        }
        if (callable instanceof OCLambdaExpression) {
            return OCRefactoringBundle.message("dialog.message.cannot.inline.parameters.lambdas", new Object[0]);
        }
        OCSymbol callableSymbol = callable.getSymbol();
        if (callableSymbol == null) {
            return "SILENT_EXIT";
        }
        if (!this.validateFunctionUsages()) {
            return null;
        }
        OCCompilationContext context = OCCompilationContext.create(callable);
        OCInlineMethodHandler.checkMethodsHierarchy(callable, callableSymbol.getNameWithKindLowercase(context), warnings);
        String callableName = callableSymbol.getNameWithKindLowercase(context);
        int paramIndex = OCInlineParameterHandler.getParamIndex(element, callable);
        assert (paramIndex >= 0);
        if (!OCInlineParameterHandler.processCalls(callable, callableSymbol, paramIndex, (Processor<OCExpression>)((Processor)expression -> {
            OCReferenceElement refElement;
            OCReferenceElement oCReferenceElement = refElement = expression instanceof OCReferenceExpression ? ((OCReferenceExpression)expression).getReferenceElement() : null;
            if (refElement != null && element.equals(refElement.resolve())) {
                return true;
            }
            if (elementData.isNull()) {
                elementData.set(expression);
            } else {
                if (!OCElementUtil.areElementsEquivalent((PsiElement)elementData.get(), expression, true)) {
                    return false;
                }
                if (((PsiElement)elementData.get()).getTextOffset() > expression.getTextOffset()) {
                    elementData.set(expression);
                }
            }
            return true;
        }), callable.getProject())) {
            return OCRefactoringBundle.message("dialog.message.several.call.sites.with.different.parameter.initializers", new Object[0]);
        }
        if (elementData.isNull()) {
            return OCRefactoringBundle.message("dialog.message.there.are.no.usages", callableName);
        }
        OCCodeMoveValidator validator = new OCCodeMoveValidator(callable.getBody());
        ((PsiElement)elementData.get()).accept((PsiElementVisitor)validator);
        if (validator.isOutOfScope()) {
            warnings.add(OCRefactoringBundle.message("text.parameter.initializer.not.available.in", callableName, validator.getOutOfScopeMessage()));
        }
        return null;
    }

    private static boolean processCalls(OCCallable callable, OCSymbol callableSymbol, int paramIndex, Processor<OCExpression> processor, @NotNull Project project) {
        HashSet methodUsages = new HashSet();
        OCSearchUtil.findAllMemberUsages((OCSymbolWithParent)callableSymbol, methodUsages, true, true, project);
        for (UsageInfo usage : methodUsages) {
            List<OCExpression> arguments;
            OCExpression initializer;
            PsiElement usageElement = usage.getElement();
            if (usage instanceof OCMethodCallUsage && usageElement instanceof OCSendMessageExpression) {
                List<OCMessageArgument> arguments2 = ((OCSendMessageExpression)usageElement).getArguments();
                if (arguments2.size() <= paramIndex || processor.process((Object)arguments2.get(paramIndex).getArgumentExpression())) continue;
                return false;
            }
            if (usage instanceof OCMethodDotCallUsage && usageElement instanceof OCQualifiedExpression && paramIndex == 0) {
                OCExpression kid = OCParenthesesUtils.topmostParenthesized((OCExpression)usageElement);
                PsiElement parent = kid.getParent();
                if (!(parent instanceof OCAssignmentExpression) || ((OCAssignmentExpression)parent).getReceiverExpression() != kid || processor.process((Object)((OCAssignmentExpression)parent).getSourceExpression())) continue;
                return false;
            }
            if (!(usage instanceof OCFunctionUsage)) continue;
            OCCallExpression callExpression = null;
            if (usageElement instanceof OCReferenceElement && usageElement.getParent().getParent() instanceof OCCallExpression) {
                callExpression = (OCCallExpression)usageElement.getParent().getParent();
            } else if (usageElement instanceof OCExpression && usageElement.getParent() instanceof OCCallExpression) {
                callExpression = (OCCallExpression)usageElement.getParent();
            }
            List<PsiNamedElement> parameters = callable.getParameters();
            PsiElement parameter = parameters != null && paramIndex < parameters.size() ? (PsiElement)parameters.get(paramIndex) : null;
            OCExpression oCExpression = initializer = parameter instanceof OCDeclarator ? ((OCDeclarator)parameter).getInitializer() : null;
            if (callExpression == null || !((arguments = callExpression.getArguments()).size() > paramIndex ? !processor.process((Object)arguments.get(paramIndex)) : initializer != null && !processor.process((Object)initializer))) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void inlineUsage(PsiElement usage, PsiNamedElement element, PsiElement elementData, Project project, Map<SmartPsiElementPointer, Pair<OCSymbol, OCVisibility>> elemsToEscalateVisibility) {
        if (!(usage instanceof OCReferenceElement) || !(usage.getParent() instanceof OCReferenceExpression)) {
            return;
        }
        usage = OCParenthesesUtils.replaceExpressionAndAppendParentheses((OCExpression)usage.getParent(), (OCExpression)elementData);
        OCImportSymbolFix.fixAllSymbolsRecursively(usage);
    }

    @Override
    protected void deleteElement(PsiNamedElement element, PsiElement elementData) {
        OCCallable callable = (OCCallable)PsiTreeUtil.getParentOfType((PsiElement)element, OCCallable.class);
        OCChangeSignatureHandler handler = OCChangeSignatureActionHandler.getHandler(callable, true);
        handler.setChangeAncestors(true);
        handler.removeParameter(OCInlineParameterHandler.getParamIndex(element, callable));
        handler.invokeSynchronously();
    }

    @Override
    @NotNull
    protected String getFeatureID() {
        return "refactoring.inlineParameter";
    }
}

