/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.changeSignature;

import com.intellij.CommonBundle;
import com.intellij.lang.LanguageRefactoringSupport;
import com.intellij.lang.refactoring.RefactoringSupportProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ChangeSignatureHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCRefactoringBundle;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCCallableKind;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureDialog;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureHandler;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureHandlerImpl;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCEmptyChangeSignatureHandler;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCMethodDescriptor;
import com.jetbrains.cidr.lang.resolve.OCFunctionGroupSymbol;
import com.jetbrains.cidr.lang.search.OCSearchUtil;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCForeignSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolder;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolderVirtualPsiElement;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCChangeSignatureActionHandler
implements ChangeSignatureHandler {
    public static final DataKey<OCCallableKind> CALLABLE_KIND = DataKey.create((String)"callable_kind");

    public PsiElement findTargetMember(@NotNull PsiElement element) {
        PsiElement targetMember = OCElementUtil.findRenameTargetDefinition(element, true);
        return targetMember != null ? targetMember.getOriginalElement() : null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        OCChangeSignatureActionHandler.invoke(project, editor, this.findTargetMember(file, editor), (OCCallableKind)((Object)CALLABLE_KIND.getData(dataContext)));
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        OCChangeSignatureActionHandler.invoke(project, (Editor)CommonDataKeys.EDITOR.getData(dataContext), elements[0], (OCCallableKind)((Object)CALLABLE_KIND.getData(dataContext)));
    }

    @Nullable
    public String getTargetNotFoundMessage() {
        return OCBundle.message("changeSignature.targetNotFound", new Object[0]);
    }

    private static void invoke(Project project, Editor editor, PsiElement element, OCCallableKind callableKind) {
        Object symbol;
        String title = RefactoringBundle.message((String)"changeSignature.refactoring.name");
        if (element instanceof OCSymbolHolderVirtualPsiElement && (symbol = ((OCSymbolHolderVirtualPsiElement)element).getSymbol()) instanceof OCFunctionGroupSymbol) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)OCBundle.message("refactoring.ambiguous", new Object[0]), (String)title, null);
            return;
        }
        if (!(element instanceof OCCallable)) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)OCBundle.message("changeSignature.targetNotFound", new Object[0]), (String)title, null);
            return;
        }
        if (!OCCodeInsightUtil.isValid(element)) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RefactoringBundle.message((String)"error.out.of.project.element.default"), (String)title, null);
            return;
        }
        OCChangeSignatureHandler handler = OCChangeSignatureActionHandler.getHandler((OCCallable)element, true);
        if (OCChangeSignatureActionHandler.checkVariableArguments(project, editor, handler)) {
            return;
        }
        if (callableKind != null) {
            if (((OCCallable)element).getBody() == null) {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)OCBundle.message("change.signature.convert.action", new Object[]{callableKind}), (String)title, null);
                return;
            }
            handler.setCallableKind(callableKind);
        }
        handler.invoke();
    }

    public static boolean checkVariableArguments(Project project, Editor editor, OCChangeSignatureHandler handler) {
        OCMethodDescriptor methodDescriptor = handler.getMethodDescriptor();
        if (methodDescriptor == null) {
            return false;
        }
        OCSymbol symbol = methodDescriptor.getMethodSymbol();
        if (symbol instanceof OCMethodSymbol && ((OCMethodSymbol)symbol).isVararg() || symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).isVararg()) {
            String message = OCRefactoringBundle.message("dialog.message.can.t.refactor.with.variable.arguments", symbol.getKind().getNameLowercase());
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)RefactoringBundle.message((String)"changeSignature.refactoring.name"), null);
            return true;
        }
        return false;
    }

    public static OCChangeSignatureHandler getHandler(@NotNull OCCallable callable, @NotNull PsiElement context) {
        return OCChangeSignatureActionHandler.getHandler(callable, context, false, ApplicationManager.getApplication().isUnitTestMode());
    }

    public static OCChangeSignatureHandler getHandler(@NotNull OCCallable callable, boolean isChangeCallableKindPossible) {
        return OCChangeSignatureActionHandler.getHandler(callable, callable, isChangeCallableKindPossible, ApplicationManager.getApplication().isUnitTestMode());
    }

    public static OCChangeSignatureHandler getHandler(@NotNull OCCallable callable, @NotNull PsiElement context, boolean silentMode) {
        return OCChangeSignatureActionHandler.getHandler(callable, context, false, silentMode);
    }

    private static OCChangeSignatureHandler getHandler(@NotNull OCCallable callable, @NotNull PsiElement context, boolean isChangeCallableKindPossible, boolean silentMode) {
        return OCChangeSignatureActionHandler.getHandler(callable, context, isChangeCallableKindPossible, silentMode, !silentMode, false);
    }

    public static OCChangeSignatureHandler getHandler(@NotNull OCCallable callable, @NotNull PsiElement context, boolean isChangeCallableKindPossible, boolean silentMode, boolean askForSuperMethods, boolean sureThatConstructor) {
        return OCChangeSignatureActionHandler.getHandler(callable, context, isChangeCallableKindPossible, silentMode, askForSuperMethods, false, sureThatConstructor);
    }

    public static OCChangeSignatureHandler getHandler(@NotNull OCCallable callable, @NotNull PsiElement context, boolean isChangeCallableKindPossible, boolean silentMode, boolean askForSuperMethods, boolean ignoreOutOfProjectAncestors, boolean sureThatConstructor) {
        OCSymbol symbol = callable.getSymbol();
        Project project = callable.getProject();
        boolean refactorAncestors = false;
        if (symbol instanceof OCSymbolWithParent) {
            OCSearchUtil.Ancestor ancestor;
            OCSymbolWithParent symbolWithParent = (OCSymbolWithParent)symbol;
            OCSearchUtil.Ancestor ancestor2 = ancestor = ignoreOutOfProjectAncestors ? OCSearchUtil.findSomeInProjectAncestor(symbolWithParent, project) : OCSearchUtil.findSomeAncestor(symbolWithParent, project);
            if (ancestor != null) {
                String subject = symbol.getKind().getNameLowercase();
                OCCompilationContext compilationContext = OCCompilationContext.create(symbol, project);
                String message = OCRefactoringBundle.message("dialog.message.overrides.in.choice.which.out.project", symbol.getNameWithKindUppercase(compilationContext), subject, ancestor.getSymbol().getParent().getNameWithKindLowercase(compilationContext), ancestor.isOutOfProject() ? 0 : 1);
                if (ancestor.isOutOfProject()) {
                    int result;
                    if (askForSuperMethods && (result = Messages.showYesNoDialog((Project)project, (String)(message + " " + OCRefactoringBundle.message("dialog.message.do.you.want.to.proceed.refactoring", new Object[0])), (String)CommonBundle.getWarningTitle(), (Icon)Messages.getQuestionIcon())) != 0) {
                        return new OCEmptyChangeSignatureHandler(project);
                    }
                } else {
                    int result;
                    if (askForSuperMethods) {
                        result = Messages.showYesNoCancelDialog((Project)project, (String)(message + " " + OCRefactoringBundle.message("dialog.message.do.you.want.to.refactor.base.s", subject)), (String)CommonBundle.getWarningTitle(), (Icon)Messages.getQuestionIcon());
                    } else {
                        int n = result = ApplicationManager.getApplication().isUnitTestMode() ? 0 : 1;
                    }
                    if (result == 0) {
                        if (OCChangeSignatureActionHandler.delegateToOtherChangeSignatureHandler(project, ancestor.getSymbol())) {
                            return new OCEmptyChangeSignatureHandler(project);
                        }
                        refactorAncestors = true;
                    } else if (result != 1) {
                        return new OCEmptyChangeSignatureHandler(project);
                    }
                }
            }
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)callable)) {
            return new OCEmptyChangeSignatureHandler(project);
        }
        if (!callable.getContainingOCFile().getKind().isObjC()) {
            isChangeCallableKindPossible = false;
        }
        OCMethodDescriptor methodDescriptor = OCMethodDescriptor.createMethodDescriptor(callable);
        methodDescriptor.setChangeCallableKindPossible(isChangeCallableKindPossible);
        methodDescriptor.setSureIsConstructor(sureThatConstructor);
        OCChangeSignatureHandlerImpl handler = silentMode ? new OCChangeSignatureHandlerImpl(methodDescriptor, context, true) : new OCChangeSignatureDialog(project, methodDescriptor, context).getHandler();
        handler.setChangeAncestors(refactorAncestors);
        return handler;
    }

    private static boolean delegateToOtherChangeSignatureHandler(@NotNull Project project, @Nullable OCSymbol ancestorSymbol) {
        ChangeSignatureHandler handler;
        RefactoringSupportProvider provider2;
        PsiElement definition;
        if (ancestorSymbol instanceof OCForeignSymbol && (definition = ancestorSymbol.locateDefinition(project)) instanceof OCSymbolHolder && (provider2 = LanguageRefactoringSupport.INSTANCE.forContext(definition = definition.getOriginalElement())) != null && (handler = provider2.getChangeSignatureHandler()) != null) {
            handler.invoke(project, new PsiElement[]{definition}, null);
            return true;
        }
        return false;
    }
}

