/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.settings.NamingConventionRule;
import com.jetbrains.cidr.lang.settings.NamingConventionStyle;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class OCNamingConventionUtil {
    private static final NamingConventionRule EMPTY_RULE = new NamingConventionRule(EnumSet.of(NamingConventionRule.EntityKind.ANY), EnumSet.of(NamingConventionRule.Visibility.ANY), EnumSet.of(NamingConventionRule.Specifier.ANY), "", NamingConventionStyle.NONE, "");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public static void withNamingConventionRules(@NotNull List<NamingConventionRule> rules, @NotNull Runnable runnable, @NotNull Project project) {
        OCCodeStyleSettings codeStyleSettings = (OCCodeStyleSettings)CodeStyle.getSettings((Project)project).getCustomSettings(OCCodeStyleSettings.class);
        List<NamingConventionRule> oldRules = codeStyleSettings.NAMING_CONVENTION_RULES;
        try {
            codeStyleSettings.NAMING_CONVENTION_RULES = rules;
            runnable.run();
        }
        finally {
            codeStyleSettings.NAMING_CONVENTION_RULES = oldRules;
        }
    }

    public static boolean shouldIgnoreNamingConventionForSymbol(@Nullable OCSymbol symbol) {
        if (symbol instanceof OCFunctionSymbol) {
            OCFunctionSymbol functionSymbol = (OCFunctionSymbol)symbol;
            return functionSymbol.isUDL() || functionSymbol.isCppOperator() || functionSymbol.isMainFunction();
        }
        return false;
    }

    public static String applyNamingConvention(@NlsSafe @NotNull String name, @Nullable OCSymbolKind symbolKind, @NotNull Project project) {
        return OCNamingConventionUtil.applyNamingConvention(name, symbolKind, null, null, project);
    }

    public static String applyNamingConvention(@NlsSafe @NotNull String name, @Nullable OCSymbolKind symbolKind, @Nullable OCSymbol symbol, @Nullable OCResolveContext context, @NotNull Project project) {
        return OCNamingConventionUtil.getNamingConventionRuleForSymbol(symbolKind, symbol, context, project).apply(name);
    }

    public static Collection<String> applyNamingConvention(@NotNull Collection<String> names, @Nullable OCSymbolKind symbolKind, @NotNull Project project) {
        return OCNamingConventionUtil.applyNamingConvention(names, symbolKind, null, null, project);
    }

    public static Collection<String> applyNamingConvention(@NotNull Collection<@NlsSafe String> names, @Nullable OCSymbolKind symbolKind, @Nullable OCSymbol symbol, @Nullable OCResolveContext context, @NotNull Project project) {
        NamingConventionRule rule = OCNamingConventionUtil.getNamingConventionRuleForSymbol(symbolKind, symbol, context, project);
        return ContainerUtil.map(names, name -> rule.apply((String)name));
    }

    public static boolean matchesToNamingConvention(@NlsSafe @NotNull String name, @NotNull OCSymbolKind symbolKind, @NotNull Project project) {
        return OCNamingConventionUtil.matchesToNamingConvention(name, symbolKind, null, null, project);
    }

    public static boolean matchesToNamingConvention(@NlsSafe @NotNull String name, @NotNull OCSymbolKind symbolKind, @Nullable OCSymbol symbol, @Nullable OCResolveContext context, @NotNull Project project) {
        return OCNamingConventionUtil.getNamingConventionRuleForSymbol(symbolKind, symbol, context, project).match(name);
    }

    static NamingConventionRule getNamingConventionRuleForSymbol(@Nullable OCSymbolKind symbolKind, @Nullable OCSymbol symbol, @Nullable OCResolveContext context, @NotNull Project project) {
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyle.getSettings((Project)project).getCustomSettings(OCCodeStyleSettings.class);
        for (int i = settings.NAMING_CONVENTION_RULES.size() - 1; i >= 0; --i) {
            NamingConventionRule rule = settings.NAMING_CONVENTION_RULES.get(i);
            if (!rule.canApply(symbolKind, symbol, context, project)) continue;
            return rule;
        }
        return EMPTY_RULE;
    }
}

