/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.refactoring.OCExtractMethodProcessor;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import org.jetbrains.annotations.NotNull;

public class OCExtractMethodHandler
implements RefactoringActionHandler {
    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        SelectionModel model = editor.getSelectionModel();
        if (!model.hasSelection()) {
            model.selectLineAtCaret();
        }
        int startOffset = model.getSelectionStart();
        int endOffset = model.getSelectionEnd();
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        OCExpression expr = OCCodeInsightUtil.findExpressionAtRange(file, startOffset, endOffset);
        if (expr != null) {
            OCExtractMethodHandler.extractExpression(project, editor, dataContext, expr);
            return;
        }
        PsiElement[] statements = OCCodeInsightUtil.findStatementsAtRange(file, startOffset, endOffset, true);
        if (statements != null && statements.length > 0) {
            new OCExtractMethodProcessor(statements, project, new TextRange(startOffset, endOffset), dataContext).invoke(editor);
            return;
        }
        endOffset = CharArrayUtil.shiftBackward((CharSequence)editor.getDocument().getCharsSequence(), (int)(endOffset - 1), (String)" \t\n;") + 1;
        expr = OCCodeInsightUtil.findExpressionAtRange(file, startOffset, endOffset);
        if (expr != null) {
            OCExtractMethodHandler.extractExpression(project, editor, dataContext, expr);
        } else {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)OCBundle.message("extract.method.selected.block.hint", new Object[0]), (String)OCExtractMethodHandler.getRefactoringName(), null);
        }
    }

    private static void extractExpression(Project project, Editor editor, DataContext dataContext, OCExpression expr) {
        if (!(expr.getParent() instanceof OCExpressionStatement) && expr.getResolvedType().getGuessedType() == OCUnknownType.INSTANCE) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)OCBundle.message("extract.method.cannot.determine.hint", new Object[0]), (String)OCExtractMethodHandler.getRefactoringName(), null);
        } else {
            new OCExtractMethodProcessor(new OCExpression[]{expr}, project, expr.getRangeWithMacros(), dataContext).invoke(editor);
        }
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
    }

    @NlsContexts.DialogTitle
    public static String getRefactoringName() {
        return RefactoringBundle.message((String)"extract.method.title");
    }
}

