/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.generate.handlers.OCGenerateIvarsHandler;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCSynthesizePropertyQuickFixBase
extends OCGenerateIvarsHandler
implements IntentionAction {
    protected OCImplementationSymbol myImplementationSymbol;
    protected OCPropertySymbol myProperty;
    protected final Project myProject;

    public OCSynthesizePropertyQuickFixBase(OCImplementationSymbol implementationSymbol, OCPropertySymbol property, Project project) {
        this.myImplementationSymbol = implementationSymbol;
        this.myProperty = property;
        this.myProject = project;
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @NotNull
    public String getText() {
        if (this.myProperty == null) {
            return OCBundle.message("action.invalid.title", new Object[0]);
        }
        return OCBundle.message("quickfixes.synthesize", this.myProperty.getNameWithKindLowercase(OCCompilationContext.create(this.myProperty, this.myProject)));
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        return OCSearchScope.isInProjectSources(this.myImplementationSymbol, project) && this.myProperty != null;
    }

    @Override
    protected OCPropertySymbol locateCandidate(@NotNull Project project, Editor editor, PsiFile file) {
        return this.myProperty;
    }

    @Override
    protected OCClassSymbol getParent(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file) {
        return this.myImplementationSymbol;
    }

    @Override
    protected boolean replaceAllProperties() {
        return false;
    }

    @Override
    protected boolean enableChooseDialog(Collection<OCPropertySymbol> candidates) {
        return false;
    }
}

