/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.quickfixes.OCQuickFix;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCSymbolQuickFix<T extends OCSymbol>
extends OCQuickFix {
    @NotNull
    protected final T mySymbol;
    private final boolean myIsInProjectSources;

    protected OCSymbolQuickFix(@NotNull Project project, @NotNull T symbol) {
        this.mySymbol = symbol;
        this.myIsInProjectSources = OCSearchScope.isInProjectSources(this.mySymbol, project);
    }

    protected abstract void invoke(@NotNull Project var1, @Nullable Editor var2);

    @Override
    public boolean isAvailable() {
        return this.myIsInProjectSources;
    }

    @Override
    protected String getTextInternal() {
        return null;
    }

    @Override
    public final void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) throws IncorrectOperationException {
        OCFile containingFile = this.mySymbol.getContainingOCFile(project);
        if (containingFile != null && this.prepareDocuments(containingFile.getProject(), containingFile)) {
            this.invoke(project, editor);
        }
    }
}

