/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.daemon.OCSuppressionGroup;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSuppressClazyCheckForLine
extends SuppressIntentionAction {
    private final String mySuppressOption;
    private static final Pattern EXCLUDE_PATTERN = Pattern.compile(".*?(clazy:exclude=.*?\\s).*");

    public OCSuppressClazyCheckForLine(@Nullable OCSuppressionGroup suppressionGroup) {
        this.mySuppressOption = suppressionGroup == null ? null : suppressionGroup.suppressionOption;
    }

    @NotNull
    @IntentionFamilyName
    public String getFamilyName() {
        return OCInspectionsBundle.message("intentions.suppress.for", "line");
    }

    private static int getChecksEndOffset(@Nullable PsiElement element) {
        if (element == null) {
            return -1;
        }
        PsiFile file = element.getContainingFile();
        int offset = element.getTextOffset();
        Document document = file.getViewProvider().getDocument();
        if (document == null) {
            return -1;
        }
        int line = document.getLineNumber(offset);
        @Nullable PsiElement eolElement = file.findElementAt(document.getLineEndOffset(line) - 1);
        if (eolElement == null || !OCTokenTypes.COMMENTS.contains(OCElementUtil.getElementType(eolElement))) {
            return -1;
        }
        String commentText = eolElement.getText() + " ";
        Matcher match = EXCLUDE_PATTERN.matcher(commentText);
        if (!match.matches()) {
            return -1;
        }
        return eolElement.getTextOffset() + match.end(1) - 1;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        OCFile file = (OCFile)element.getContainingFile();
        Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument((PsiFile)file);
        if (document == null) {
            return;
        }
        int offset = OCSuppressClazyCheckForLine.getChecksEndOffset(element);
        if (offset != -1) {
            document.insertString(offset, (CharSequence)("," + this.mySuppressOption.replace("-Wclazy-", "")));
        } else {
            offset = OCElementUtil.getRangeWithMacros(element).getStartOffset();
            document.insertString(document.getLineEndOffset(document.getLineNumber(offset)), (CharSequence)("// clazy:exclude=" + this.mySuppressOption.replace("-Wclazy-", "")));
        }
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        return element.isValid() && this.mySuppressOption != null;
    }

    @NotNull
    public String getText() {
        return OCInspectionsBundle.message("intentions.suppress.option.for", this.mySuppressOption, "line");
    }
}

