/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.quickfixes.OCPsiElementsQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCRemoveExtraInitializersIntentionAction
extends OCPsiElementsQuickFix {
    private final int myStartIndex;

    public OCRemoveExtraInitializersIntentionAction(List<? extends PsiElement> initializers, int startIndex) {
        super(initializers);
        this.myStartIndex = startIndex;
    }

    @Override
    @IntentionFamilyName
    protected String getTextInternal() {
        return OCInspectionsBundle.message("intention.family.name.remove.extra.initializers", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getTextInternal();
    }

    @Override
    public boolean isAvailable() {
        return this.myElementPointers != null && this.myElementPointers.size() > this.myStartIndex && OCCodeInsightUtil.isValid(((SmartPsiElementPointer)this.myElementPointers.get(0)).getElement());
    }

    @Override
    protected void invoke(PsiFile file, @NotNull Project project) {
        for (int i = this.myElementPointers.size() - 1; i >= this.myStartIndex; --i) {
            PsiElement element = ((SmartPsiElementPointer)this.myElementPointers.get(i)).getElement();
            if (element == null) continue;
            OCChangeUtil.delete(element);
        }
    }
}

