/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.quickfixes.OCPsiElementsQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCRemoveElementsIntentionAction
extends OCPsiElementsQuickFix {
    @IntentionName
    private final String myIntentionName;
    @IntentionFamilyName
    private final String myFamilyName;

    public OCRemoveElementsIntentionAction(@Nullable PsiElement element, @IntentionFamilyName String intentionName) {
        this(element, intentionName, intentionName);
    }

    public OCRemoveElementsIntentionAction(PsiElement element, @IntentionName String intentionName, @IntentionFamilyName String familyName) {
        this(Collections.singletonList(element), intentionName, familyName);
    }

    public OCRemoveElementsIntentionAction(Collection<? extends PsiElement> elements, @IntentionName String intentionName, @IntentionFamilyName String familyName) {
        super(elements);
        this.myIntentionName = intentionName;
        this.myFamilyName = familyName;
    }

    @Override
    protected String getTextInternal() {
        return this.myIntentionName;
    }

    @NotNull
    public String getFamilyName() {
        return this.myFamilyName;
    }

    @Override
    protected void invoke(PsiFile file, @NotNull Project project) {
        this.processElements((Processor<PsiElement>)((Processor)element -> {
            if (element instanceof OCStatement) {
                OCChangeUtil.safeDeleteStatement((OCStatement)element);
            } else {
                OCChangeUtil.delete(element);
            }
            return true;
        }));
    }

    @Override
    protected boolean shouldCommitAllDocuments() {
        return false;
    }

    @Nullable
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        List<PsiElement> copyElements = this.findSameElementsInCopy(this.myElementPointers, target);
        return copyElements != null && copyElements.size() >= 1 ? new OCRemoveElementsIntentionAction(copyElements, this.myIntentionName, this.myFamilyName) : null;
    }
}

