/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.OCBundle;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCQuickFix
implements IntentionAction,
LocalQuickFix {
    @IntentionName
    protected abstract String getTextInternal();

    public abstract boolean isAvailable();

    protected void invoke(PsiFile file, @NotNull Project project) {
    }

    @NotNull
    public String getText() {
        if (!this.isAvailable()) {
            return OCBundle.message("action.invalid.title", new Object[0]);
        }
        return this.getTextInternal();
    }

    @NotNull
    public String getName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        return this.isAvailable();
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, PsiFile file) throws IncorrectOperationException {
        if (this.prepareDocuments(project, file)) {
            this.invoke(file, project);
        }
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (this.isAvailable()) {
            PsiFile file = descriptor.getPsiElement().getContainingFile();
            this.invoke(file.getProject(), null, file);
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    public boolean isSupportedInBatchMode() {
        return true;
    }

    protected boolean shouldCommitAllDocuments() {
        return true;
    }

    @Nullable
    protected PsiElement findSameElementInCopy(@NotNull SmartPsiElementPointer<? extends PsiElement> elementPointer, @NotNull PsiFile copy2) {
        PsiElement element = elementPointer.getElement();
        if (element == null || !element.isValid()) {
            return null;
        }
        return PsiTreeUtil.findSameElementInCopy((PsiElement)element, (PsiFile)copy2);
    }

    @Nullable
    protected List<PsiElement> findSameElementsInCopy(@NotNull List<SmartPsiElementPointer> elementPointers, @NotNull PsiFile copyFile) {
        ArrayList<PsiElement> copyElements = new ArrayList<PsiElement>(elementPointers.size());
        for (SmartPsiElementPointer pointer : elementPointers) {
            PsiElement element = pointer.getElement();
            if (element == null || !element.isValid()) {
                return null;
            }
            copyElements.add(PsiTreeUtil.findSameElementInCopy((PsiElement)element, (PsiFile)copyFile));
        }
        return copyElements;
    }

    protected final boolean prepareDocuments(@NotNull Project project, @NotNull PsiFile file) {
        if (file.isPhysical() && !FileModificationService.getInstance().prepareFileForWrite(file)) {
            return false;
        }
        if (this.shouldCommitAllDocuments()) {
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        } else {
            PsiDocumentManager.getInstance((Project)project).commitDocument(file.getViewProvider().getDocument());
        }
        return true;
    }
}

