/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.quickfixes.OCCreateDefinitionIntentionAction;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.refactoring.util.OCNormalizeUtil;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import org.jetbrains.annotations.NotNull;

public class OCMoveDefinitionIntentionAction
extends OCCreateDefinitionIntentionAction {
    private final OCSymbol myOldDefinitionSymbol;
    @NlsSafe
    private final String myIntentionNameSuffix;
    private PsiElement myOldDefinition;

    public OCMoveDefinitionIntentionAction(OCSymbolKind symbolKind, PsiElement usage, OCSymbol parent, OCSymbol oldDefinitionSymbol, String intentionNameSuffix) {
        super(symbolKind, usage, parent);
        this.myOldDefinitionSymbol = oldDefinitionSymbol;
        this.myIntentionNameSuffix = intentionNameSuffix;
    }

    public OCMoveDefinitionIntentionAction(OCSymbolKind symbolKind, PsiElement context, @NotNull OCSymbol parent, OCSymbol oldDefinitionSymbol) {
        super(symbolKind, context, parent);
        this.myOldDefinitionSymbol = oldDefinitionSymbol;
        this.myIntentionNameSuffix = " to " + parent.getNameWithKindLowercase(OCCompilationContext.create(this.myUsage));
    }

    @Override
    public PsiElement getDefinition(Project project, Editor editor, PsiFile file) {
        PsiElement definition = this.myOldDefinitionSymbol.locateDefinition(project);
        if (definition == null) {
            return null;
        }
        if (definition instanceof OCDeclarator) {
            definition = OCNormalizeUtil.normalizeDeclarator((OCDeclarator)definition);
        }
        if (definition == null) {
            return null;
        }
        if (this.mySymbolKind == OCSymbolKind.PROPERTY) {
            definition = PsiTreeUtil.getContextOfType((PsiElement)definition, (Class[])new Class[]{OCProperty.class});
        }
        this.myOldDefinition = definition;
        return this.myOldDefinition;
    }

    @NotNull
    public String getText() {
        if (this.myOldDefinitionSymbol == null) {
            return OCBundle.message("action.invalid.title", new Object[0]);
        }
        return OCInspectionsBundle.message("intention.name.move.declaration", this.myOldDefinitionSymbol.getNameWithKindLowercase(OCCompilationContext.create(this.myUsage)), this.myIntentionNameSuffix);
    }

    @Override
    protected boolean doCreate(Project project, Editor editor, PsiFile file) {
        if (super.doCreate(project, editor, file)) {
            OCChangeUtil.delete(this.myOldDefinition);
            return true;
        }
        return false;
    }
}

