/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.quickfixes.OCPsiElementQuickFix;
import com.jetbrains.cidr.lang.refactoring.inline.OCInlineParameterHandler;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import org.jetbrains.annotations.NotNull;

public class OCInlineParameterFix
extends OCPsiElementQuickFix<OCDeclarator> {
    private OCDeclaratorSymbol mySymbol;
    private String myValue;

    public OCInlineParameterFix(@NotNull OCDeclarator declarator, @NotNull OCDeclaratorSymbol symbol, @NotNull String value) {
        super(declarator);
        this.mySymbol = symbol;
        this.myValue = value;
    }

    @Override
    @IntentionName
    protected String getTextInternal() {
        return OCInspectionsBundle.message("intention.name.inline", this.mySymbol.getNameWithKindLowercase(OCResolveContext.forPsi(this.myElementPtr.getElement())));
    }

    @NotNull
    @IntentionFamilyName
    public String getFamilyName() {
        return OCInspectionsBundle.message("intention.family.name.inline.parameter", new Object[0]);
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    protected void invoke(PsiFile file, @NotNull OCDeclarator element) {
        new OCInlineParameterHandler(){

            @Override
            protected boolean allowNoUsages() {
                return true;
            }

            @Override
            protected boolean validateFunctionUsages() {
                return false;
            }
        }.inline(element, null, OCElementFactory.expressionFromText(this.myValue, (PsiElement)file), null, false, false);
    }
}

