/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.ShowAutoImportPass;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.HintAction;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.ExternalFormatProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.FileColorManager;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.speedSearch.SpeedSearch;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.Matcher;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCIncludeHelpers;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.autoImport.OCAutoImportHelper;
import com.jetbrains.cidr.lang.preprocessor.OCFileActiveConfigurationCache;
import com.jetbrains.cidr.lang.preprocessor.OCHeaderGuardDetector;
import com.jetbrains.cidr.lang.preprocessor.OCHeaderGuardInfo;
import com.jetbrains.cidr.lang.preprocessor.OCImportGraph;
import com.jetbrains.cidr.lang.preprocessor.OCResolveRootAndConfiguration;
import com.jetbrains.cidr.lang.preprocessor.OCResolveRootAndConfigurationCache;
import com.jetbrains.cidr.lang.psi.OCClassPredeclaration;
import com.jetbrains.cidr.lang.psi.OCClassPredeclarationList;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.psi.OCDirective;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCIncludeDirective;
import com.jetbrains.cidr.lang.psi.OCProtocolList;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCSuperClassRef;
import com.jetbrains.cidr.lang.psi.impl.symbols.OCFileGlobalSymbols;
import com.jetbrains.cidr.lang.psi.impl.symbols.OCFileGlobalSymbolsCache;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.quickfixes.OCIncludeSuggester;
import com.jetbrains.cidr.lang.quickfixes.OCNewImportLocation;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.settings.OCCodeInsightSettings;
import com.jetbrains.cidr.lang.settings.OCHeaderImportStyle;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolGroupContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.OCFileSymbols;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.workspace.OCCompilerSettings;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPath;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

public final class OCImportSymbolFix
implements HintAction,
HighPriorityAction {
    @Nullable
    private final PsiElement myElement;
    @Nullable
    private final OCFile myCurrentFile;
    private final boolean myForceIncludeMode;
    private final boolean myIgnoreFileScopeCheck;
    @NotNull
    private final List<AutoImportItem> myItems = new ArrayList<AutoImportItem>();
    private boolean myFixApplied = false;
    private boolean myAddSameChoices = false;

    public OCImportSymbolFix(@NotNull OCReferenceElement reference) {
        this(reference, (OCSymbolGroupContext)null);
    }

    private static boolean isValidIncludeForCurrentConfiguration(@NotNull VirtualFile currentFile, @NotNull VirtualFile fileToInclude, @NotNull Project project) {
        @Nullable VirtualFile currentFileParent = currentFile.getParent();
        @Nullable VirtualFile fileToIncludeParent = fileToInclude.getParent();
        if (currentFileParent != null && VfsUtilCore.isAncestor((VirtualFile)currentFileParent, (VirtualFile)fileToInclude, (boolean)true) || fileToIncludeParent != null && VfsUtilCore.isAncestor((VirtualFile)fileToIncludeParent, (VirtualFile)currentFile, (boolean)true)) {
            return true;
        }
        OCResolveConfiguration resolveConfiguration = OCFileActiveConfigurationCache.getActiveConfiguration(currentFile, project);
        if (resolveConfiguration == null) {
            return false;
        }
        OCLanguageKind languageKind = resolveConfiguration.getDeclaredLanguageKind(currentFile);
        if (languageKind == null) {
            return false;
        }
        OCCompilerSettings compilerSettings = resolveConfiguration.getCompilerSettings(languageKind);
        for (HeadersSearchPath path : compilerSettings.getHeadersSearchPaths()) {
            if (!path.isAncestorOf(fileToInclude, false)) continue;
            return true;
        }
        return false;
    }

    public OCImportSymbolFix(@NotNull OCReferenceElement reference, @Nullable OCSymbolGroupContext symbolContext, boolean addSameChoices) {
        this.myAddSameChoices = addSameChoices;
        this.myElement = reference;
        this.myCurrentFile = reference.getContainingOCFile();
        this.myForceIncludeMode = false;
        this.myIgnoreFileScopeCheck = false;
        if (symbolContext == null) {
            symbolContext = OCSymbolGroupContext.union(reference.getSymbolContext(), OCSymbolKind.MACRO);
        }
        if (this.myCurrentFile != null && reference.resolveToSymbol(symbolContext) == null) {
            HashSet<VirtualFile> addedFiles = new HashSet<VirtualFile>();
            ArrayList<AutoImportItem> possibleItems = new ArrayList<AutoImportItem>();
            ArrayList<OCSymbol> toImportList = new ArrayList<OCSymbol>();
            boolean pathsAreValid = false;
            for (OCSymbol symbol : reference.resolveToOverloadsSymbols(symbolContext, true)) {
                VirtualFile containingFile;
                OCSymbol toImport = OCImportSymbolFix.getSymbolToImport(symbol);
                if (toImport == null || toImport.isUnnamed() || (containingFile = toImport.getContainingFile()) == null || !addedFiles.add(containingFile)) continue;
                boolean valid = OCImportSymbolFix.isValidIncludeForCurrentConfiguration(this.myCurrentFile.getVirtualFile(), containingFile, this.myElement.getProject());
                if (valid && !pathsAreValid) {
                    pathsAreValid = true;
                    toImportList.clear();
                    toImportList.add(toImport);
                    continue;
                }
                if (valid != pathsAreValid) continue;
                toImportList.add(toImport);
            }
            this.collectPossibleItems(toImportList, null, this.myCurrentFile, false, pathsAreValid, possibleItems);
            this.myItems.addAll(OCImportSymbolFix.prepareAutoImportItems(possibleItems, this.myCurrentFile, this.myElement, false));
        }
    }

    public OCImportSymbolFix(@NotNull OCReferenceElement reference, @Nullable OCSymbolGroupContext symbolContext) {
        this(reference, symbolContext, false);
    }

    public OCImportSymbolFix(@Nullable PsiElement element, @Nullable OCSymbol resolvedSymbolIgnoringImports) {
        this(element, resolvedSymbolIgnoringImports, false);
    }

    public OCImportSymbolFix(@Nullable PsiElement element, @Nullable OCSymbol resolvedSymbolIgnoringImports, boolean forceIncludeMode) {
        this(element, resolvedSymbolIgnoringImports, forceIncludeMode, true);
    }

    public OCImportSymbolFix(@Nullable PsiElement element, @Nullable OCSymbol resolvedSymbolIgnoringImports, boolean forceIncludeMode, boolean allowInternalHeaders) {
        this(element, resolvedSymbolIgnoringImports, forceIncludeMode, allowInternalHeaders, false);
    }

    public OCImportSymbolFix(@Nullable PsiElement element, @Nullable OCSymbol resolvedSymbolIgnoringImports, boolean forceIncludeMode, boolean allowInternalHeaders, boolean ignoreFileScopeCheck) {
        this.myElement = element;
        this.myCurrentFile = element != null ? (OCFile)element.getContainingFile() : null;
        this.myForceIncludeMode = forceIncludeMode;
        this.myIgnoreFileScopeCheck = ignoreFileScopeCheck;
        if (resolvedSymbolIgnoringImports != null) {
            OCSymbol toImport = OCImportSymbolFix.getSymbolToImport(resolvedSymbolIgnoringImports);
            if (this.myCurrentFile != null && toImport != null && !OCFileSymbols.isSymbolImported(this.myCurrentFile, toImport, element)) {
                ArrayList<AutoImportItem> possibleItems = new ArrayList<AutoImportItem>();
                PsiElement insertBefore = this.calculateInsertBefore(toImport);
                this.collectPossibleItems(Collections.singletonList(toImport), insertBefore, this.myCurrentFile, allowInternalHeaders, true, possibleItems);
                this.myItems.addAll(OCImportSymbolFix.prepareAutoImportItems(possibleItems, this.myCurrentFile, this.myElement, false));
            }
        }
    }

    private void collectPossibleItems(@NotNull List<OCSymbol> toImport, @Nullable PsiElement insertBefore, @NotNull OCFile currentFile, boolean allowInternalHeaders, boolean validIncludePath, @NotNull List<AutoImportItem> result) {
        Collection<AutoImportFileWithSymbol> filesToImport = OCImportSymbolFix.getFilesToImport(toImport, allowInternalHeaders, currentFile);
        Set paths = CollectionFactory.createSmallMemoryFootprintSet();
        for (AutoImportFileWithSymbol fileWithSymbol : filesToImport) {
            Pair pathAndAngled;
            OCAutoImportHelper.ImportSpecification spec = OCImportSymbolFix.getFileNameToImport(fileWithSymbol.virtualFile, currentFile);
            if (spec == null || paths.contains(pathAndAngled = new Pair((Object)spec.getImportPath(), (Object)spec.getKind().isSystemHeaderSearchPath())) && (!ApplicationManager.getApplication().isUnitTestMode() || !this.myAddSameChoices)) continue;
            paths.add(pathAndAngled);
            result.add(new AutoImportItem(fileWithSymbol.symbol, insertBefore, fileWithSymbol.virtualFile, spec, OCCompilationContext.create(currentFile), validIncludePath, fileWithSymbol.data.depth));
        }
    }

    @Nullable
    private static OCSymbol getSymbolToImport(@Nullable OCSymbol symbol) {
        if (symbol == null) {
            return null;
        }
        if (symbol.isSynthetic()) {
            return null;
        }
        if (symbol.isPredeclaration() && (symbol instanceof OCClassSymbol || symbol instanceof OCStructSymbol)) {
            return null;
        }
        while (true) {
            OCSymbol parent;
            OCSymbol oCSymbol = parent = symbol instanceof OCSymbolWithParent ? ((OCSymbolWithParent)symbol).getParent() : null;
            if (parent == null || parent.getKind() == OCSymbolKind.NAMESPACE) {
                symbol = symbol.getContainingFile() == null ? null : symbol;
                break;
            }
            if (symbol instanceof OCNamespaceSymbol) break;
            symbol = parent;
        }
        if (symbol != null && !symbol.isGlobal()) {
            return null;
        }
        return symbol;
    }

    @Nullable
    private PsiElement calculateInsertBefore(@NotNull OCSymbol symbolToImport) {
        if (this.myElement != null) {
            OCFile file = (OCFile)this.myElement.getContainingFile();
            OCFileGlobalSymbols symbols = OCFileGlobalSymbolsCache.getInstance(file.getProject()).forFile(file);
            Pair<OCSymbol, VirtualFile> pair = symbols.getUndefinedClasses().get(symbolToImport.getName());
            if (pair == null) {
                pair = symbols.getUndefinedProtocols().get(symbolToImport.getName());
            }
            if (pair != null) {
                return file.findIncludeDirective((VirtualFile)pair.getSecond());
            }
        }
        return null;
    }

    public boolean hasAutoImportItems() {
        return !this.getAutoImportItems().isEmpty();
    }

    private boolean hasDifferentSymbolKinds() {
        OCSymbolKind prevKind = null;
        for (AutoImportItem each : this.getAutoImportItems()) {
            OCSymbolKind eachKind = each.mySymbolToImport.getKind();
            if (prevKind != null && prevKind != eachKind) {
                return true;
            }
            prevKind = eachKind;
        }
        return false;
    }

    @NotNull
    public synchronized List<AutoImportItem> getAutoImportItems() {
        return this.myItems;
    }

    @NotNull
    private static List<AutoImportItem> prepareAutoImportItems(@NotNull List<AutoImportItem> items, @NotNull OCFile currentFile, @NotNull PsiElement element, boolean forceIncludeMode) {
        HashSet<VirtualFile> addedFiles = new HashSet<VirtualFile>();
        ArrayList<AutoImportItem> toProcess = new ArrayList<AutoImportItem>(items);
        ArrayList<AutoImportItem> result = new ArrayList<AutoImportItem>(items.size());
        boolean hasValidItems = false;
        for (AutoImportItem item : toProcess) {
            if (!item.isValidIncludePath()) continue;
            hasValidItems = true;
            break;
        }
        while (!toProcess.isEmpty()) {
            AutoImportItem each = (AutoImportItem)toProcess.remove(0);
            if (hasValidItems && !each.isValidIncludePath()) continue;
            ImportStyle importStyle = OCImportSymbolFix.getImportStyle(each, element, forceIncludeMode);
            if (OCImportSymbolFix.isFromSameFile(each, element) && (importStyle == ImportStyle.INCLUDE || each.mySymbolToImport.getOffset() <= element.getTextOffset() || each.mySymbolToImport instanceof OCImplementationSymbol)) continue;
            OCAutoImportHelper.ImportSpecification fileSpec = each.getFileSpecToImport();
            String textToInsert = importStyle == ImportStyle.INCLUDE ? fileSpec.getImportText() : each.mySymbolToImport.getName();
            if (!OCImportSymbolFix.isImportRequired(currentFile, textToInsert, element) || !addedFiles.add(each.getFileToImport())) continue;
            result.add(each);
        }
        result.sort((o1, o2) -> {
            int segments2;
            int includeDepth2;
            int includeDepth1 = o1.getIncludeDepth();
            if (includeDepth1 != (includeDepth2 = o2.getIncludeDepth())) {
                return Comparing.compare((int)includeDepth1, (int)includeDepth2);
            }
            OCAutoImportHelper.ImportSpecification spec1 = o1.getFileSpecToImport();
            OCAutoImportHelper.ImportSpecification spec2 = o2.getFileSpecToImport();
            int segments1 = FileUtilRt.splitPath((String)spec1.getImportPath(), (char)'/').size();
            if (segments1 != (segments2 = FileUtilRt.splitPath((String)spec2.getImportPath(), (char)'/').size())) {
                return Comparing.compare((int)segments1, (int)segments2);
            }
            int result11 = Comparing.compare((Comparable)((Object)spec1.getKind()), (Comparable)((Object)spec2.getKind()));
            if (result11 != 0) {
                return result11;
            }
            OCSymbolKind k1 = o1.mySymbolToImport.getKind();
            OCSymbolKind k2 = o2.mySymbolToImport.getKind();
            result11 = Comparing.compare((boolean)k1.isClass(), (boolean)k2.isClass());
            if (result11 != 0) {
                return -result11;
            }
            result11 = Comparing.compare((boolean)k1.isStructLike(), (boolean)k2.isStructLike());
            if (result11 != 0) {
                return -result11;
            }
            result11 = Comparing.compare((boolean)k1.isTypedefOrAlias(), (boolean)k2.isTypedefOrAlias());
            if (result11 != 0) {
                return -result11;
            }
            result11 = Comparing.compare((k1 == OCSymbolKind.MACRO ? 1 : 0) != 0, (k2 == OCSymbolKind.MACRO ? 1 : 0) != 0);
            if (result11 != 0) {
                return -result11;
            }
            result11 = Comparing.compare((boolean)k1.isCallable(), (boolean)k2.isCallable());
            if (result11 != 0) {
                return -result11;
            }
            result11 = Comparing.compare((boolean)k1.isVariable(), (boolean)k2.isVariable());
            if (result11 != 0) {
                return -result11;
            }
            result11 = k1.compareTo(k2);
            if (result11 != 0) {
                return result11;
            }
            VirtualFile f1 = o1.getFileToImport();
            VirtualFile f2 = o2.getFileToImport();
            return StringUtil.compare((String)f1.getPath(), (String)f2.getPath(), (boolean)true);
        });
        return result;
    }

    public boolean showHint(@NotNull Editor editor) {
        if (!OCCodeInsightSettings.getInstance().SHOW_IMPORT_POPUP || HintManager.getInstance().hasShownHintsThatWillHideByOtherHint(true)) {
            return false;
        }
        OCLog.LOG.assertTrue(this.myElement != null);
        Pair<String, Boolean> text = this.getText(true);
        String hintText = ShowAutoImportPass.getMessage((boolean)((Boolean)text.second), (String)StringUtil.escapeXmlEntities((String)((String)text.first)));
        TextRange range = OCElementUtil.getRangeWithMacros(this.myElement);
        PsiFile file = this.myElement.getContainingFile();
        Project project = file.getProject();
        HintManager.getInstance().showQuestionHint(editor, hintText, range.getStartOffset(), range.getEndOffset(), () -> {
            if (this.myElement.isValid() && this.isAvailable(project, editor, file)) {
                this.invoke(project, editor, file);
            }
            return true;
        });
        return true;
    }

    @NotNull
    public String getFamilyName() {
        return OCBundle.message("quickfixes.import.symbol", new Object[0]);
    }

    @NotNull
    public String getText() {
        if (!this.hasAutoImportItems()) {
            return this.getFamilyName();
        }
        return (String)this.getText((boolean)false).first;
    }

    public @NotNull Pair<@Nls String, Boolean> getText(boolean forPopup) {
        List<AutoImportItem> items = this.getAutoImportItems();
        Object text = this.hasDifferentSymbolKinds() ? OCInspectionsBundle.message("intention.name.import.which", forPopup ? 0 : 1, items.get((int)0).mySymbolToImport.getName()) : (String)items.get((int)0).getTitleAndLocation().first;
        if (!forPopup) {
            text = OCInspectionsBundle.message("intention.name.import", text);
        }
        if (items.size() == 1) {
            text = (String)text + " " + OCInspectionsBundle.message("intention.name.import.from", items.get((int)0).getTitleAndLocation().second);
        }
        return Pair.create((Object)text, (Object)(items.size() > 1 ? 1 : 0));
    }

    @NotNull
    private static String getTextToInsert(@NotNull AutoImportItem item, @NotNull ImportStyle importStyle, @NotNull PsiElement element) {
        if (!element.isValid()) {
            return "";
        }
        if (importStyle == ImportStyle.PREDECLARE) {
            @NlsSafe String qualifier = item.mySymbolToImport instanceof OCProtocolSymbol ? "@protocol " : "@class ";
            return qualifier + item.mySymbolToImport.getName() + ";";
        }
        PsiFile targetFile = element.getContainingFile();
        @NlsSafe String directive = targetFile instanceof OCFile && ((OCFile)targetFile).getKind().isObjC() ? "#import" : "#include";
        return directive + " " + item.getFileSpecToImport().getImportText();
    }

    @NotNull
    private static ImportStyle getImportStyle(@NotNull AutoImportItem item, @NotNull PsiElement element, boolean forceIncludeMode) {
        if (forceIncludeMode || !(item.mySymbolToImport instanceof OCClassSymbol)) {
            return ImportStyle.INCLUDE;
        }
        boolean isSuperclass = element.getParent() instanceof OCSuperClassRef;
        boolean isSuperProtocol = element.getParent() instanceof OCProtocolList;
        if (isSuperclass || isSuperProtocol) {
            return ImportStyle.INCLUDE;
        }
        if (OCImportSymbolFix.isFromSameFile(item, element)) {
            return ImportStyle.PREDECLARE;
        }
        boolean isInclude = OCCodeInsightSettings.getInstance().HEADER_IMPORT_STYLE == OCHeaderImportStyle.IMPORT || !((OCFile)element.getContainingFile()).isHeader();
        return isInclude ? ImportStyle.INCLUDE : ImportStyle.PREDECLARE;
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, PsiFile file) {
        if (this.myFixApplied) {
            return false;
        }
        if (!(file instanceof OCFile) || file instanceof OCCodeFragment) {
            return false;
        }
        if (this.myElement == null || !this.myElement.isValid()) {
            return false;
        }
        if (!this.myIgnoreFileScopeCheck && !OCSearchScope.isInProjectSources(this.myElement)) {
            return false;
        }
        return this.hasAutoImportItems();
    }

    private static boolean isImportRequired(@NotNull PsiFile file, @NotNull String textToInsert, @NotNull PsiElement unresolvedElement) {
        for (PsiElement element : file.getChildren()) {
            if (element instanceof OCIncludeDirective && element.getText().contains(textToInsert)) {
                return false;
            }
            if (element instanceof OCClassPredeclarationList) {
                for (OCClassPredeclaration predefinition : ((OCClassPredeclarationList)element).getPredeclarations()) {
                    if (!textToInsert.equals(predefinition.getName())) continue;
                    return false;
                }
            }
            if (element.getTextOffset() >= unresolvedElement.getTextOffset()) break;
        }
        return true;
    }

    private static boolean isFromSameFile(@NotNull AutoImportItem item, @NotNull PsiElement element) {
        return element.isValid() && Comparing.equal((Object)item.mySymbolToImport.getContainingFile(), (Object)element.getContainingFile().getVirtualFile());
    }

    private static boolean accumulateImportCandidates(@NotNull Project project, @NotNull VirtualFile mainCandidate, @NotNull Map<VirtualFile, AutoImportCandidateData> acc, boolean isProxy, int depth) {
        if (acc.containsKey(mainCandidate)) {
            return false;
        }
        acc.put(mainCandidate, new AutoImportCandidateData(isProxy, depth));
        FileSymbolTablesCache cache = FileSymbolTablesCache.getInstance(project);
        FileSymbolTablesCache.getInstance(project).ensurePendingFilesProcessed();
        for (VirtualFile includer : OCImportSymbolFix.getIncludingFiles(mainCandidate, project)) {
            if (includer == null || !includer.isValid() || !OCFileTypeHelpers.isHeaderFile((String)includer.getName()) || acc.containsKey(includer)) continue;
            boolean includerIsProxy = isProxy && OCImportSymbolFix.isUmbrellaFile(cache, includer, project);
            OCImportSymbolFix.accumulateImportCandidates(project, includer, acc, includerIsProxy, depth + 1);
        }
        return true;
    }

    private static boolean isUmbrellaFile(@NotNull FileSymbolTablesCache cache, @NotNull VirtualFile includer, @NotNull Project project) {
        Ref proxyFile = new Ref((Object)true);
        for (FileSymbolTable table : cache.allTablesForFile(includer)) {
            table.shallowProcessSymbols((Processor<? super OCSymbol>)((Processor)symbol -> {
                OCSymbolKind kind = symbol.getKind();
                if (!(kind == OCSymbolKind.MACRO || kind == OCSymbolKind.UNDEF_MACRO || kind == OCSymbolKind.SYMBOL_USING_SYMBOL || kind == OCSymbolKind.NAMESPACE_USING_SYMBOL || kind == OCSymbolKind.NAMESPACE_ALIAS || kind == OCSymbolKind.IMPORT || kind == OCSymbolKind.TYPEDEF || kind == OCSymbolKind.FUNCTION_PREDECLARATION || kind == OCSymbolKind.FUNCTION_DECLARATION || kind == OCSymbolKind.STRUCT && ((OCStructSymbol)symbol).isPOD(OCResolveContext.forSymbol(symbol, project)))) {
                    proxyFile.set((Object)false);
                    return false;
                }
                return true;
            }));
            if (((Boolean)proxyFile.get()).booleanValue()) continue;
            break;
        }
        return (Boolean)proxyFile.get();
    }

    @NotNull
    private static Collection<VirtualFile> getIncludingFiles(@NotNull VirtualFile file, @NotNull Project project) {
        return OCImportGraph.getInstance(project).findImmediateIncludingFiles(file, false);
    }

    private static AutoImportItem findPreferredInclude(@NotNull List<AutoImportItem> items) {
        AutoImportItem systemHeader = null;
        int systemHeaderCount = 0;
        int withoutExtension = 0;
        for (AutoImportItem item : items) {
            if (!item.getFileSpecToImport().getKind().isSystemHeaderSearchPath()) continue;
            ++systemHeaderCount;
            if (!item.getFileSpecToImport().getImportText().contains(".")) {
                ++withoutExtension;
            }
            if (withoutExtension >= 2) break;
            systemHeader = item;
        }
        if (systemHeaderCount == 1 || withoutExtension == 1) {
            return systemHeader;
        }
        return null;
    }

    public void invoke(final @NotNull Project project, @NotNull Editor editor, final PsiFile file) throws IncorrectOperationException {
        @NotNull List<AutoImportItem> items = this.getAutoImportItems();
        if (items.size() == 1) {
            items.get(0).invoke(project, file);
            return;
        }
        BaseListPopupStep<AutoImportItem> step = new BaseListPopupStep<AutoImportItem>(OCInspectionsBundle.message("intention.import.popup.title", new Object[0]), this.getAutoImportItems()){

            public boolean isAutoSelectionEnabled() {
                return false;
            }

            public boolean isSpeedSearchEnabled() {
                return true;
            }

            public PopupStep onChosen(AutoImportItem selectedValue, boolean finalChoice) {
                if (finalChoice && selectedValue != null) {
                    this.doFinalStep(() -> selectedValue.invoke(project, file));
                }
                return FINAL_CHOICE;
            }

            public boolean hasSubstep(AutoImportItem item) {
                return false;
            }

            @NotNull
            public String getTextFor(AutoImportItem item) {
                Pair<@Nls String, @NlsSafe String> titleAndLocation = item.getTitleAndLocation();
                return (String)titleAndLocation.first + " @ " + (String)titleAndLocation.second;
            }

            public Icon getIconFor(AutoImportItem item) {
                return item.mySymbolToImport.getIcon(project);
            }
        };
        ListPopupImpl popup = new ListPopupImpl(project, (ListPopupStep)step){

            protected ListCellRenderer getListElementRenderer() {
                return new MyRenderer(this.mySpeedSearch, project);
            }
        };
        popup.showInBestPositionFor(editor);
    }

    @NotNull
    public static OCNewImportLocation calcNewImportLocation(@NotNull OCFile file, int beforeOffset, @NlsSafe @NotNull String insertText, @NotNull ImportStyle importStyle, @Nullable OCIncludeDirective.Delimiters delimiters) {
        PsiElement sibling;
        OCDirective beginIfndefDirective;
        PsiElement firstImport = null;
        PsiElement lastImport = null;
        PsiElement lastLibraryImport = null;
        PsiElement lastProjectImport = null;
        PsiElement lastClassPredef = null;
        OCHeaderGuardInfo headerGuardInfo = OCHeaderGuardDetector.findHeaderGuard(file, false);
        OCDirective oCDirective = beginIfndefDirective = headerGuardInfo != null ? headerGuardInfo.getBeginIfndefDirective() : null;
        PsiElement firstScanNode = beginIfndefDirective != null ? ((sibling = OCElementUtil.getNextNonWhitespaceSibling(beginIfndefDirective)) == null ? null : sibling.getNextSibling()) : file.getFirstChild();
        boolean skipInessentialNodes = true;
        PsiElement lastInessential = null;
        for (PsiElement kid = firstScanNode; kid != null && (beforeOffset == -1 || kid.getTextOffset() < beforeOffset); kid = kid.getNextSibling()) {
            if (skipInessentialNodes) {
                if (OCElementUtil.isEssentialNode(kid)) {
                    skipInessentialNodes = false;
                } else {
                    lastInessential = kid;
                }
            }
            if (kid instanceof OCIncludeDirective) {
                if (kid.getText().contains(insertText)) {
                    return new OCNewImportLocation(null, false, kid);
                }
                lastImport = kid;
                if (firstImport == null) {
                    firstImport = kid;
                }
                if (((OCIncludeDirective)kid).isAngleBrackets()) {
                    lastLibraryImport = kid;
                } else {
                    lastProjectImport = kid;
                }
            }
            if (!(kid instanceof OCClassPredeclarationList)) continue;
            lastClassPredef = kid;
        }
        PsiElement insertAnchor = lastImport;
        boolean insertBefore = false;
        if (importStyle == ImportStyle.INCLUDE) {
            if (delimiters == OCIncludeDirective.Delimiters.ANGLE_BRACKETS) {
                if (lastLibraryImport != null) {
                    insertAnchor = lastLibraryImport;
                } else {
                    insertAnchor = firstImport;
                    insertBefore = true;
                }
            } else if (lastProjectImport != null) {
                insertAnchor = lastProjectImport;
            }
        } else {
            insertAnchor = lastClassPredef;
            if (insertAnchor == null) {
                insertAnchor = lastImport;
            }
        }
        if (insertAnchor == null) {
            insertAnchor = lastInessential;
            insertBefore = false;
        }
        if (insertAnchor == null) {
            insertAnchor = file.getFirstChild();
            insertBefore = true;
        }
        return new OCNewImportLocation(insertAnchor, insertBefore, null);
    }

    private static PsiElement addImportAndSortWithExternalFormatter(OCFile file, PsiElement newElement, OCNewImportLocation location) {
        PsiElement newImport = location.getInsertAnchor() == null ? file.add(newElement) : (location.getInsertBefore() ? file.addBefore(newElement, location.getInsertAnchor()) : file.addAfter(newElement, location.getInsertAnchor()));
        VirtualFile virtualFile = file.getViewProvider().getVirtualFile();
        @Nullable Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        OCLog.LOG.assertTrue(document != null);
        RangeMarker marker = document.createRangeMarker(newImport.getTextRange().getStartOffset(), newImport.getTextRange().getEndOffset());
        OCChangeUtil.addNewLineIfNeed(newImport, true);
        PsiDocumentManager.getInstance((Project)file.getProject()).doPostponedOperationsAndUnblockDocument(document);
        PsiDocumentManager.getInstance((Project)file.getProject()).performForCommittedDocument(document, () -> CommandProcessor.getInstance().runUndoTransparentAction(() -> ApplicationManager.getApplication().runWriteAction(() -> {
            int _startOffset = marker.getStartOffset();
            int _endOffset = marker.getEndOffset();
            marker.dispose();
            ExternalFormatProcessor.formatRangeInFile((PsiFile)file, (TextRange)new TextRange(_startOffset, _endOffset), (boolean)false, (boolean)false, (boolean)false, (int)-1);
        })));
        return newImport;
    }

    public static PsiElement addImportToFile(OCFile file, @NlsSafe String insertText, @NotNull ImportStyle importStyle, int beforeOffset) {
        PsiElement newElement = OCElementFactory.topLevelDeclarationFromText(insertText, file);
        OCIncludeDirective.Delimiters delimiters = newElement instanceof OCIncludeDirective ? ((OCIncludeDirective)newElement).getDelimiters() : null;
        OCNewImportLocation location = OCImportSymbolFix.calcNewImportLocation(file, beforeOffset, insertText, importStyle, delimiters);
        if (location.getExisting() != null) {
            return location.getExisting();
        }
        if (ExternalFormatProcessor.useExternalFormatter((PsiFile)file) && OCCodeInsightSettings.getInstance().TRY_TO_SORT_IMPORTS) {
            return OCImportSymbolFix.addImportAndSortWithExternalFormatter(file, newElement, location);
        }
        PsiElement newImport = OCChangeUtil.addHandlingMacros(file, newElement, location.getInsertAnchor(), OCChangeUtil.PostponedFormatAction.Format, location.getInsertBefore());
        OCChangeUtil.addNewLineIfNeed(newImport, true);
        return newImport;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public static void fixAfterCompletionAtCaret(Editor editor, PsiFile file, OCSymbol symbol) {
        if (!OCCodeInsightSettings.getInstance().ALLOW_IMPORT_IN_COMPLETION) {
            return;
        }
        int offset = OCImportSymbolFix.calculateOffset(editor);
        if (offset >= 0) {
            OCImportSymbolFix.fixAfterCompletionAtOffset(editor, file, offset, symbol);
        }
    }

    public static void fixAfterCompletionAtCaret(Editor editor, PsiFile file, OCSymbolGroupContext symbolContext) {
        OCReferenceElement ref;
        if (!OCCodeInsightSettings.getInstance().ALLOW_IMPORT_IN_COMPLETION) {
            return;
        }
        int offset = OCImportSymbolFix.calculateOffset(editor);
        if (offset >= 0 && (ref = (OCReferenceElement)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)offset, OCReferenceElement.class, (boolean)false)) != null) {
            new OCImportSymbolFix(ref, symbolContext).fixBestItem(file.getProject(), file);
        }
    }

    private static int calculateOffset(Editor editor) {
        CharSequence text = editor.getDocument().getCharsSequence();
        int offset = editor.getCaretModel().getOffset();
        if (offset >= text.length()) {
            return -1;
        }
        while (offset > 0 && Character.isJavaIdentifierPart(text.charAt(offset))) {
            --offset;
        }
        if (offset <= 0) {
            return -1;
        }
        while (offset > 0 && Character.isWhitespace(text.charAt(offset))) {
            --offset;
        }
        if (offset <= 0) {
            return -1;
        }
        --offset;
        while (offset > 0 && Character.isWhitespace(text.charAt(offset))) {
            --offset;
        }
        if (offset <= 0) {
            return -1;
        }
        return offset;
    }

    public static void fixAfterCompletionAtOffset(Editor editor, PsiFile file, int offset, OCSymbol symbol) {
        if (!OCCodeInsightSettings.getInstance().ALLOW_IMPORT_IN_COMPLETION) {
            return;
        }
        OCElement ref = (OCElement)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)offset, OCElement.class, (boolean)false);
        new OCImportSymbolFix(ref, symbol).fixBestItem(file.getProject(), file);
    }

    public static void fixAllSymbolsRecursively(PsiElement element) {
        OCImportSymbolFix.fixAllSymbolsRecursively(element, null);
    }

    public static void fixAllSymbolsRecursively(PsiElement element, @Nullable TextRange range) {
        final PsiFile containingFile = element.getContainingFile();
        final Project project = containingFile.getProject();
        element.accept((PsiElementVisitor)new OCRecursiveVisitor(range){

            @Override
            public void visitReferenceElement(OCReferenceElement referenceElement) {
                new OCImportSymbolFix(referenceElement).fixBestItem(project, containingFile);
            }
        });
    }

    public boolean fixBestItem(@NotNull Project project, @NotNull PsiFile file) {
        if (this.isAvailable(project, null, file)) {
            @NotNull List<AutoImportItem> items = this.getAutoImportItems();
            AutoImportItem preferredItem = OCImportSymbolFix.findPreferredInclude(items);
            if (preferredItem == null) {
                preferredItem = (AutoImportItem)ContainerUtil.getFirstItem(this.getAutoImportItems());
            }
            if (preferredItem != null) {
                preferredItem.invoke(project, file);
                return true;
            }
        }
        return false;
    }

    private static boolean isUnderProjectPath(Project project, VirtualFile fileToImport) {
        @Nullable @SystemIndependent @NonNls String projectPath = project.getBasePath();
        if (projectPath == null) {
            return false;
        }
        @Nullable VirtualFile root = LocalFileSystem.getInstance().findFileByPath(projectPath);
        if (root == null) {
            return false;
        }
        return VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)fileToImport, (boolean)true);
    }

    @Nullable
    public static OCAutoImportHelper.ImportSpecification getFileNameToImport(@NotNull VirtualFile fileToImport, @NotNull VirtualFile targetFile, @NotNull Project project) {
        if (!OCFileTypeHelpers.isHeaderFile((String)fileToImport.getName())) {
            return null;
        }
        Ref result = Ref.create(null);
        Ref bestSegmentsCount = Ref.create((Object)Integer.MAX_VALUE);
        OCResolveRootAndConfiguration rootAndConfiguration = OCResolveRootAndConfigurationCache.getInstance(project).getResolveRootAndActiveConfiguration(targetFile);
        OCIncludeHelpers.processImportSpecifications(project, rootAndConfiguration, targetFile, fileToImport, (Processor<OCAutoImportHelper.ImportSpecification>)((Processor)specification -> {
            @NotNull String importPath = specification.getImportPath();
            int segments = FileUtilRt.splitPath((String)importPath, (char)'/').size();
            if (segments > 1 && specification.getKind().isFrameworkSearchPath()) {
                --segments;
            }
            if (segments >= (Integer)bestSegmentsCount.get()) {
                return true;
            }
            if (!specification.isUnderSearchPath() && importPath.contains("..") && !OCImportSymbolFix.isUnderProjectPath(project, fileToImport)) {
                return true;
            }
            bestSegmentsCount.set((Object)segments);
            result.set(specification);
            return segments > 1;
        }));
        return (OCAutoImportHelper.ImportSpecification)result.get();
    }

    @Nullable
    public static OCAutoImportHelper.ImportSpecification getFileNameToImport(@NotNull VirtualFile fileToImport, @NotNull PsiFile currentFile) {
        return OCImportSymbolFix.getFileNameToImport(fileToImport, currentFile.getVirtualFile(), currentFile.getProject());
    }

    @NotNull
    private static List<AutoImportFileWithSymbol> listWithSymbol(@NotNull Set<VirtualFile> files, OCSymbol symbol) {
        ArrayList<AutoImportFileWithSymbol> result = new ArrayList<AutoImportFileWithSymbol>();
        for (VirtualFile file : files) {
            result.add(new AutoImportFileWithSymbol(file, symbol, new AutoImportCandidateData(false, 0)));
        }
        return result;
    }

    @NotNull
    private static Collection<AutoImportFileWithSymbol> getFilesToImport(@NotNull List<OCSymbol> symbols, boolean allowInternalHeaders, @NotNull PsiFile currentFile) {
        ArrayList<AutoImportFileWithSymbol> shortestPathFiles = new ArrayList<AutoImportFileWithSymbol>();
        int currentDepth = Integer.MAX_VALUE;
        String commonPath = "";
        boolean currentHasExtension = true;
        boolean collectingUmbrellaHeaders = false;
        OCFile currentOCFile = OCLanguageUtils.asOCFile(currentFile);
        boolean isCurrentFileCpp = currentOCFile != null && currentOCFile.isCpp();
        Project project = currentFile.getProject();
        Map allAcc = CollectionFactory.createSmallMemoryFootprintMap();
        for (int i = 0; i < symbols.size(); ++i) {
            Set<Object> best;
            OCSymbol symbol = symbols.get(i);
            OCFile file = symbol.getContainingOCFile(project);
            if (file == null) continue;
            VirtualFile vf = file.getVirtualFile();
            Map acc = CollectionFactory.createSmallMemoryFootprintMap();
            if (vf != null) {
                OCImportSymbolFix.accumulateImportCandidates(file.getProject(), vf, acc, true, 0);
            }
            allAcc.putAll(acc);
            String idealName = symbol.getName();
            Collection<String> recommended = OCIncludeSuggester.getRecommendedHeaderNames(symbol, currentFile);
            if (isCurrentFileCpp && !(best = ContainerUtil.filter((Map)acc, virtualFile -> {
                String extension = virtualFile.getExtension();
                if (extension != null && !extension.isEmpty()) {
                    return false;
                }
                String name = virtualFile.getName();
                return name.equalsIgnoreCase(idealName) || recommended.contains(name);
            }).keySet()).isEmpty()) {
                return OCImportSymbolFix.listWithSymbol(best, symbol);
            }
            if (i == symbols.size() - 1 && !(best = ContainerUtil.filter((Map)allAcc, virtualFile -> {
                String extension;
                if (!isCurrentFileCpp && ((extension = virtualFile.getExtension()) == null || extension.isEmpty())) {
                    return false;
                }
                String name = virtualFile.getName();
                String nameBase = FileUtilRt.getNameWithoutExtension((String)name);
                return nameBase.equalsIgnoreCase(idealName) || recommended.contains(name);
            }).keySet()).isEmpty()) {
                return OCImportSymbolFix.listWithSymbol(best, symbol);
            }
            for (Map.Entry candidate : acc.entrySet()) {
                boolean hasExtension;
                OCAutoImportHelper.ImportSpecification importSpecification;
                if (!allowInternalHeaders && ((VirtualFile)candidate.getKey()).getName().startsWith("_") && OCSearchScope.isInLibraries((VirtualFile)candidate.getKey(), project) || (importSpecification = OCImportSymbolFix.getFileNameToImport((VirtualFile)candidate.getKey(), currentFile)) == null) continue;
                VirtualFile parent = ((VirtualFile)candidate.getKey()).getParent();
                String parentPath = parent != null ? parent.getPath() : "";
                String extension = ((VirtualFile)candidate.getKey()).getExtension();
                boolean bl = hasExtension = extension != null && !extension.isEmpty();
                if (!isCurrentFileCpp && !hasExtension || isCurrentFileCpp && hasExtension && !currentHasExtension) continue;
                AutoImportCandidateData candidateData = (AutoImportCandidateData)candidate.getValue();
                if (isCurrentFileCpp && !hasExtension && currentHasExtension) {
                    currentHasExtension = false;
                    shortestPathFiles.clear();
                    shortestPathFiles.add(new AutoImportFileWithSymbol((VirtualFile)candidate.getKey(), symbol, (AutoImportCandidateData)candidate.getValue()));
                    commonPath = parentPath;
                    currentDepth = candidateData.depth;
                    collectingUmbrellaHeaders = candidateData.isProxy;
                } else if (candidateData.depth == currentDepth || StringUtil.equalsIgnoreCase((CharSequence)parentPath, (CharSequence)commonPath) && currentDepth == 0 && candidateData.depth == 1) {
                    if (candidateData.isProxy && !collectingUmbrellaHeaders) {
                        shortestPathFiles.clear();
                        shortestPathFiles.add(new AutoImportFileWithSymbol((VirtualFile)candidate.getKey(), symbol, (AutoImportCandidateData)candidate.getValue()));
                        collectingUmbrellaHeaders = true;
                    } else if (candidateData.isProxy == collectingUmbrellaHeaders) {
                        shortestPathFiles.add(new AutoImportFileWithSymbol((VirtualFile)candidate.getKey(), symbol, (AutoImportCandidateData)candidate.getValue()));
                    }
                } else if (candidateData.depth < currentDepth) {
                    if (currentDepth > 1 || !StringUtil.equalsIgnoreCase((CharSequence)parentPath, (CharSequence)commonPath) || candidateData.isProxy && !collectingUmbrellaHeaders) {
                        shortestPathFiles.clear();
                    }
                    shortestPathFiles.add(new AutoImportFileWithSymbol((VirtualFile)candidate.getKey(), symbol, (AutoImportCandidateData)candidate.getValue()));
                    commonPath = parentPath;
                    collectingUmbrellaHeaders = candidateData.isProxy;
                }
                currentDepth = Math.min(currentDepth, candidateData.depth);
            }
        }
        return shortestPathFiles;
    }

    private static class MyRenderer
    extends JPanel
    implements ListCellRenderer<AutoImportItem> {
        final ColoredListCellRenderer<AutoImportItem> myLeft;
        final ColoredListCellRenderer<AutoImportItem> myRight;
        @NotNull
        final Project myProject;

        MyRenderer(final SpeedSearch speedSearch, @NotNull Project project) {
            super(new BorderLayout());
            this.myProject = project;
            this.myLeft = new ColoredListCellRenderer<AutoImportItem>(){

                protected void customizeCellRenderer(@NotNull JList<? extends AutoImportItem> list, AutoImportItem value, int index, boolean selected, boolean hasFocus) {
                    myLeft.clear();
                    Pair<@Nls String, @NlsSafe String> titleAndLocation = value.getTitleAndLocation();
                    myLeft.setIcon(value.mySymbolToImport.getIcon(myProject));
                    SpeedSearchUtil.appendColoredFragmentForMatcher((String)((String)titleAndLocation.first), (SimpleColoredComponent)this, (SimpleTextAttributes)SimpleTextAttributes.REGULAR_ATTRIBUTES, (Matcher)speedSearch.getMatcher(), (Color)this.getBackground(), (boolean)selected);
                }
            };
            this.myRight = new ColoredListCellRenderer<AutoImportItem>(){

                protected void customizeCellRenderer(@NotNull JList<? extends AutoImportItem> list, AutoImportItem value, int index, boolean selected, boolean hasFocus) {
                    Pair<@Nls String, @NlsSafe String> titleAndLocation = value.getTitleAndLocation();
                    SpeedSearchUtil.appendColoredFragmentForMatcher((String)((String)titleAndLocation.second), (SimpleColoredComponent)this, (SimpleTextAttributes)SimpleTextAttributes.GRAY_ATTRIBUTES, (Matcher)speedSearch.getMatcher(), (Color)this.getBackground(), (boolean)selected);
                }
            };
            this.add((Component)this.myLeft, "Center");
            this.add((Component)this.myRight, "East");
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends AutoImportItem> list, AutoImportItem value, int index, boolean isSelected, boolean cellHasFocus) {
            Color fileColor;
            FileColorManager colorManager;
            PsiFile file;
            Color bgColor;
            Color color = bgColor = isSelected ? UIUtil.getListSelectionBackground((boolean)true) : UIUtil.getListBackground();
            if (!isSelected && value != null && (file = value.mySymbolToImport.getContainingPsiFile(this.myProject)) != null && (colorManager = FileColorManager.getInstance((Project)this.myProject)).isEnabled() && (fileColor = colorManager.getRendererBackground(file)) != null) {
                bgColor = fileColor;
            }
            this.setBackground(bgColor);
            this.myLeft.getListCellRendererComponent(list, (Object)value, index, isSelected, false);
            this.myRight.getListCellRendererComponent(list, (Object)value, index, isSelected, false);
            return this;
        }
    }

    public class AutoImportItem {
        @NotNull
        private final OCSymbol mySymbolToImport;
        @Nullable
        private final PsiElement myInsertBefore;
        @NotNull
        private final VirtualFile myFileToImport;
        @NotNull
        private final OCAutoImportHelper.ImportSpecification myFileNameToImport;
        @NotNull
        private final OCCompilationContext myCompilationContext;
        @Nullable
        private Pair<String, String> myCachedTitleAndLocation;
        private boolean myValidIncludePath;
        private int myIncludeDepth;

        public AutoImportItem(@Nullable OCSymbol symbolToImport, @NotNull PsiElement insertBefore, @NotNull VirtualFile fileToImport, @NotNull OCAutoImportHelper.ImportSpecification fileNameToImport, OCCompilationContext context, boolean validIncludePath, int includeDepth) {
            this.mySymbolToImport = symbolToImport;
            this.myInsertBefore = insertBefore;
            this.myFileToImport = fileToImport;
            this.myFileNameToImport = fileNameToImport;
            this.myCompilationContext = context;
            this.myValidIncludePath = validIncludePath;
            this.myIncludeDepth = includeDepth;
        }

        public boolean isValidIncludePath() {
            return this.myValidIncludePath;
        }

        public String toString() {
            Pair<String, String> titleAndLocation = this.getTitleAndLocation();
            return (String)titleAndLocation.first + "@" + (String)titleAndLocation.second;
        }

        public @NotNull Pair<@Nls String, @NlsSafe String> getTitleAndLocation() {
            OCResolveContext context;
            OCQualifiedName resolvedName;
            if (this.myCachedTitleAndLocation != null) {
                return this.myCachedTitleAndLocation;
            }
            Object kind = this.mySymbolToImport.getKindLowercase(this.myCompilationContext);
            if (this.mySymbolToImport instanceof OCClassSymbol) {
                kind = "@" + (String)kind;
            }
            String name = this.mySymbolToImport.getName();
            if (this.mySymbolToImport instanceof OCSymbolWithQualifiedName && (resolvedName = ((OCSymbolWithQualifiedName)this.mySymbolToImport).getResolvedQualifiedName(true, false, context = OCResolveContext.forSymbol(this.mySymbolToImport, this.myCompilationContext.getProject()))) != null) {
                name = resolvedName.getCanonicalName(OCType.Presentation.FULL, false, context, 0);
            }
            this.myCachedTitleAndLocation = Pair.create((Object)((String)kind + " '" + name + "'"), (Object)this.getFileSpecToImport().getImportText());
            return this.myCachedTitleAndLocation;
        }

        @NotNull
        private OCAutoImportHelper.ImportSpecification getFileSpecToImport() {
            return this.myFileNameToImport;
        }

        @NotNull
        public VirtualFile getFileToImport() {
            return this.myFileToImport;
        }

        public int getIncludeDepth() {
            return this.myIncludeDepth;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file) throws IncorrectOperationException {
            OCImportSymbolFix.this.myFixApplied = true;
            VirtualFile virtualFile = file.getViewProvider().getVirtualFile();
            @Nullable Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
            DaemonCodeAnalyzerEx.processHighlights((Document)document, (Project)file.getProject(), (HighlightSeverity)HighlightSeverity.ERROR, (int)0, (int)document.getTextLength(), error -> {
                error.unregisterQuickFix(action -> {
                    if (!(action instanceof OCImportSymbolFix)) {
                        return false;
                    }
                    OCImportSymbolFix otherImport = (OCImportSymbolFix)action;
                    return otherImport.myElement != null && otherImport.myElement.equals(OCImportSymbolFix.this.myElement);
                });
                return false;
            });
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            VirtualFile targetFile = file.getVirtualFile();
            for (OCAutoImportHelper each : OCAutoImportHelper.EP_NAME.getExtensionList()) {
                if (!this.myFileNameToImport.shouldAddSearchPath()) continue;
                each.addHeaderSearchPath(project, targetFile, this.myFileToImport);
            }
            PsiElement element = OCImportSymbolFix.this.myElement;
            assert (element != null);
            ImportStyle importStyle = OCImportSymbolFix.getImportStyle(this, element, OCImportSymbolFix.this.myForceIncludeMode);
            OCFile associatedFile = importStyle == ImportStyle.PREDECLARE ? ((OCFile)file).getAssociatedFile() : null;
            WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{file, associatedFile}).withName(OCInspectionsBundle.message("intention.import.command.name", this.getTitleAndLocation().first)).run(() -> {
                int beforeOffset = element.getTextOffset();
                if (this.myInsertBefore != null) {
                    beforeOffset = Math.min(beforeOffset, this.myInsertBefore.getTextOffset());
                }
                OCImportSymbolFix.addImportToFile((OCFile)file, OCImportSymbolFix.getTextToInsert(this, importStyle, element), importStyle, beforeOffset);
                if (associatedFile != null) {
                    OCImportSymbolFix.addImportToFile(associatedFile, OCImportSymbolFix.getTextToInsert(this, ImportStyle.INCLUDE, element), ImportStyle.INCLUDE, beforeOffset);
                }
            });
        }
    }

    private static class AutoImportFileWithSymbol {
        final VirtualFile virtualFile;
        final OCSymbol symbol;
        final AutoImportCandidateData data;

        AutoImportFileWithSymbol(VirtualFile virtualFile, OCSymbol symbol, AutoImportCandidateData data) {
            this.virtualFile = virtualFile;
            this.symbol = symbol;
            this.data = data;
        }
    }

    private static class AutoImportCandidateData {
        final boolean isProxy;
        final int depth;

        AutoImportCandidateData(boolean isProxy, int depth) {
            this.isProxy = isProxy;
            this.depth = depth;
        }
    }

    public static enum ImportStyle {
        INCLUDE,
        PREDECLARE;

    }
}

