/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.util.CommonProcessors;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.generate.actions.OCOverrideImplementActionContext;
import com.jetbrains.cidr.lang.generate.handlers.implement.OCImplementOCMethodsHandler;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCImplementPropertyAccessorsQuickFix
extends OCImplementOCMethodsHandler
implements IntentionAction {
    private OCPropertySymbol myProperty;
    private final Project myProject;

    public OCImplementPropertyAccessorsQuickFix(OCPropertySymbol property, Project project) {
        this.myProperty = property;
        this.myProject = project;
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @NotNull
    public String getText() {
        return OCInspectionsBundle.message("intentions.implement.accessor.methods.for", this.myProperty.getNameWithKindLowercase(OCCompilationContext.create(this.myProperty, this.myProject)));
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        return OCSearchScope.isInProjectSources(this.myProperty, project);
    }

    @Override
    protected OCClassSymbol getParent(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        return this.myProperty.getParent();
    }

    @Override
    protected boolean defaultShowSynthesizedAccessors() {
        return true;
    }

    @Override
    @NotNull
    protected Collection<OCMethodSymbol> getSelectedCandidates(@NotNull OCOverrideImplementActionContext context, Editor editor, @NotNull PsiFile file, @NotNull List<OCMethodSymbol> candidates) {
        CommonProcessors.CollectProcessor<OCMethodSymbol> collector = new CommonProcessors.CollectProcessor<OCMethodSymbol>(){

            public boolean process(OCMethodSymbol method) {
                if (method.getGeneratedFromProperty() == OCImplementPropertyAccessorsQuickFix.this.myProperty) {
                    return super.process((Object)method);
                }
                return true;
            }
        };
        this.myProperty.getParent().processMembers(OCMethodSymbol.class, collector);
        return collector.getResults();
    }
}

