/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCFileType;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileActionBase;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import icons.CidrLangIcons;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;

public class OCImplementInterfaceIntentionAction
extends OCNewFileActionBase
implements IntentionAction {
    private final OCInterfaceSymbol myInterface;
    private final Project myProject;

    public OCImplementInterfaceIntentionAction(OCInterfaceSymbol anInterface, Project project) {
        super((FileType)OCFileType.INSTANCE, OCBundle.message("create.implementation.title", new Object[0]), OCBundle.message("create.implementation.description", new Object[0]), CidrLangIcons.CodeAssistantClass);
        this.myInterface = anInterface;
        this.myProject = project;
    }

    @NotNull
    public String getText() {
        if (this.myInterface == null) {
            return OCBundle.message("action.invalid.title", new Object[0]);
        }
        return OCInspectionsBundle.message("intentions.create.implementation", this.myInterface.getNameWithKindLowercase(OCCompilationContext.create(this.myInterface, this.myProject)));
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @NotNull
    protected String getDefaultName() {
        return "Implementation";
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        return super.isAvailable() && OCSearchScope.isInProjectSources(this.myInterface, project);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.performAction(project, file.getParent(), file, this.myInterface.getName());
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    protected String getFileTemplate(String fileName) {
        return "Objective-C Class.m";
    }

    @NotNull
    protected OCNewFileActionBase.NewFileNames getNewFileNames(String selectedName) {
        return new OCNewFileActionBase.NewFileNames(selectedName + ".m", null);
    }

    protected void setAdditionalProperties(Properties properties, String fileName, PsiFile sampleFile, Project project) {
        VirtualFile file = this.myInterface.getContainingFile();
        OCLog.LOG.assertTrue(file != null);
        properties.setProperty("HEADER_FILENAME", file.getName());
    }

    @NotNull
    protected CreateImplementationDialog createDialog(@NotNull @NlsContexts.Label String defaultName) {
        return new CreateImplementationDialog(defaultName);
    }

    protected class CreateImplementationDialog
    extends OCNewFileActionBase.CreateFileDialogBase {
        public CreateImplementationDialog(String defaultName) {
            super((OCNewFileActionBase)OCImplementInterfaceIntentionAction.this, OCImplementInterfaceIntentionAction.this.getText(), defaultName, null);
        }
    }
}

