/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.quickfixes.OCSymbolQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.refactoring.util.OCElementsMover;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;

public class OCAddSuperProtocolIntentionAction
extends OCSymbolQuickFix<OCClassSymbol> {
    private String myProtocol;
    private boolean myPrivateCategoryMode;

    public OCAddSuperProtocolIntentionAction(@NotNull OCClassSymbol anInterface, String protocol, boolean privateCategoryMode, @NotNull Project project) {
        super(project, anInterface);
        this.myProtocol = protocol;
        this.myPrivateCategoryMode = privateCategoryMode;
    }

    @Override
    @NlsSafe
    protected String getTextInternal() {
        return "Adopt '" + this.myProtocol + "' by " + (this.myPrivateCategoryMode ? "private category '" + ((OCClassSymbol)this.mySymbol).getName() + "()'" : "class '" + ((OCClassSymbol)this.mySymbol).getName() + "'");
    }

    @NotNull
    public String getFamilyName() {
        return this.myPrivateCategoryMode ? OCInspectionsBundle.message("intentions.add.super.protocol.by.class", new Object[0]) : OCInspectionsBundle.message("intentions.add.super.protocol.by.private.category", new Object[0]);
    }

    @Override
    public boolean isAvailable() {
        return super.isAvailable() && this.myProtocol != null && !((OCClassSymbol)this.mySymbol).isPredeclaration();
    }

    @Override
    protected void invoke(@NotNull Project project, Editor editor) {
        OCClassDeclaration declaration = OCElementUtil.resolveClassDeclaration(this.mySymbol, project);
        if (declaration == null) {
            return;
        }
        if (this.myPrivateCategoryMode) {
            OCClassDeclaration privateCategory = OCCodeInsightUtil.getPrivateCategory(declaration);
            if (privateCategory == null) {
                privateCategory = OCElementFactory.interfaceByName(((OCClassSymbol)this.mySymbol).getName() + "()", declaration);
                privateCategory = OCChangeUtil.addBefore((PsiElement)declaration.getContainingFile(), privateCategory, declaration);
            }
            declaration = privateCategory;
        }
        this.addProtocol(declaration);
    }

    private void addProtocol(OCClassDeclaration declaration) {
        new OCElementsMover().addBaseProtocol(declaration, this.myProtocol);
    }
}

