/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.ide.util.EditorHelper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.quickfixes.OCPsiElementQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCAddInitializerIntentionAction
extends OCPsiElementQuickFix<OCDeclarator> {
    private final OCSymbol mySymbol;

    public OCAddInitializerIntentionAction(@NotNull OCDeclarator declarator, OCSymbol symbol) {
        super(declarator);
        this.mySymbol = symbol;
    }

    @Override
    protected String getTextInternal() {
        return OCInspectionsBundle.message("intention.name.initialize", this.mySymbol.getNameWithKindLowercase(OCCompilationContext.create(this.mySymbol, this.getProject())));
    }

    @NotNull
    public String getFamilyName() {
        return OCInspectionsBundle.message("intentions.add.initializer", new Object[0]);
    }

    @Override
    protected boolean isAvailable(@NotNull OCDeclarator declarator) {
        if (this.mySymbol != null) {
            OCDeclaratorSymbol declaratorSymbol;
            OCResolveContext context = OCResolveContext.forPsi(declarator);
            OCType type = this.mySymbol.getResolvedType(context);
            if (this.mySymbol instanceof OCDeclaratorSymbol && (declaratorSymbol = (OCDeclaratorSymbol)this.mySymbol).hasInitializer()) {
                return false;
            }
            return !(type instanceof OCStructType) || type.isCppStructType(context) || ((OCStructType)type).isEnum();
        }
        return false;
    }

    @Override
    public void invoke(@NotNull Project project, @Nullable Editor editor, PsiFile file) throws IncorrectOperationException {
        OCDeclarator declarator = (OCDeclarator)this.myElementPtr.getElement();
        if (declarator != null) {
            this.invoke(file, declarator, editor);
        }
    }

    protected void invoke(PsiFile file, @NotNull OCDeclarator declarator, Editor editor) {
        OCResolveContext context = OCResolveContext.forPsi(declarator);
        OCType type = this.mySymbol.getResolvedType(context);
        @NlsSafe String declarationText = "int " + declarator.getTextWithMacros() + "=" + type.getDefaultValue(context);
        OCDeclaration declaration = OCElementFactory.declarationFromText(declarationText, (PsiElement)file, true);
        OCExpression initializer = (declarator = (OCDeclarator)OCChangeUtil.replaceHandlingMacros(declarator, declaration.getDeclarators().get(0))).getInitializer();
        if (initializer != null) {
            OCAddInitializerIntentionAction.invokeSmartCompletion(initializer, type);
        }
    }

    public static void invokeSmartCompletion(final @NotNull OCExpression expression, @NotNull OCType type) {
        OCFile file = expression.getContainingOCFile();
        final boolean deleteOnEsc = type.isPointerToObjectCompatible() && !OCCompilerFeaturesHelper.isArcDisabled(file);
        TextRange initializerRange = expression.getRangeWithMacros();
        final Editor editor = EditorHelper.openInEditor((PsiElement)expression);
        if (editor == null) {
            return;
        }
        editor.getCaretModel().moveToOffset(initializerRange.getEndOffset());
        editor.getSelectionModel().setSelection(initializerRange.getStartOffset(), initializerRange.getEndOffset());
        ApplicationManager.getApplication().invokeLater(() -> {
            if (file.getProject().isDisposed() || !file.isValid()) {
                return;
            }
            CodeCompletionHandlerBase base = new CodeCompletionHandlerBase(CompletionType.SMART, false, false, true);
            base.invokeCompletion(file.getProject(), editor, 1, true);
            LookupEx lookup = LookupManager.getActiveLookup((Editor)editor);
            if (lookup != null) {
                lookup.addLookupListener(new LookupListener(){

                    public void lookupCanceled(@NotNull LookupEvent event) {
                        if (deleteOnEsc && expression.isValid()) {
                            ApplicationManager.getApplication().runWriteAction(() -> {
                                Document document = PsiDocumentManager.getInstance((Project)expression.getProject()).getDocument(expression.getContainingFile());
                                if (document != null) {
                                    PsiDocumentManager.getInstance((Project)expression.getProject()).commitDocument(document);
                                }
                                OCChangeUtil.delete(expression);
                            });
                        } else {
                            editor.getSelectionModel().removeSelection();
                        }
                    }
                });
            }
        }, ModalityState.stateForComponent((Component)editor.getComponent()));
    }

    @Override
    protected boolean shouldCommitAllDocuments() {
        return false;
    }

    @Nullable
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        PsiElement copyPsiElement = this.findSameElementInCopy((SmartPsiElementPointer<? extends PsiElement>)this.myElementPtr, target);
        return copyPsiElement instanceof OCDeclarator ? new OCAddInitializerIntentionAction((OCDeclarator)copyPsiElement, this.mySymbol) : null;
    }
}

