/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl.symbols;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.preprocessor.OCFileUtil;
import com.jetbrains.cidr.lang.preprocessor.OCHeaderContextCache;
import com.jetbrains.cidr.lang.preprocessor.OCImmutableInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.psi.impl.symbols.OCFileGlobalSymbols;
import com.jetbrains.cidr.lang.psi.impl.symbols.OCLightFileGlobalSymbols;
import com.jetbrains.cidr.lang.psi.impl.symbols.SLRUSynchronizedCache;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceLikeSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFileGlobalSymbolsCache {
    private static final Logger LOG = Logger.getInstance(OCFileGlobalSymbolsCache.class);
    private static final int CACHE_SIZE = 2 * Runtime.getRuntime().availableProcessors();
    private final CachedValue<Cache> myCache;

    public static OCFileGlobalSymbolsCache getInstance(Project project) {
        return (OCFileGlobalSymbolsCache)project.getService(OCFileGlobalSymbolsCache.class);
    }

    @NotNull
    public OCFileGlobalSymbols forFile(@NotNull PsiFile file) {
        return this.getCache().main.get(file);
    }

    @NotNull
    public OCNamespaceLikeSymbol lightTableForFile(@NotNull PsiFile file) {
        Cache cache = this.getCache();
        OCFileGlobalSymbols symbols = cache.main.getIfCached(file);
        if (symbols != null) {
            return symbols;
        }
        return cache.lightCache.get(file);
    }

    @NotNull
    public OCNamespaceLikeSymbol typesOnlyTableForFile(@NotNull PsiFile file) {
        Cache cache = this.getCache();
        OCFileGlobalSymbols symbols = cache.main.getIfCached(file);
        if (symbols != null) {
            return symbols;
        }
        OCLightFileGlobalSymbols lSymbols = cache.lightCache.getIfCached(file);
        if (lSymbols != null) {
            return lSymbols;
        }
        return cache.typesOnlyCache.get(file);
    }

    @NotNull
    private Cache getCache() {
        return (Cache)this.myCache.getValue();
    }

    public OCFileGlobalSymbolsCache(@NotNull Project project) {
        this.myCache = CachedValuesManager.getManager((Project)project).createCachedValue(() -> new CachedValueProvider.Result((Object)new Cache(), new Object[]{FileSymbolTablesCache.getInstance(project).getOutOfBlockModificationTracker()}), false);
    }

    @ApiStatus.Internal
    public static void processFile(@NotNull PsiFile file, @NotNull Processor<OCSymbol> symbols, @Nullable Map<OCSymbol, VirtualFile> importsMap) {
        if (!OCFileGlobalSymbolsCache.processFileImpl(file, symbols, importsMap) && !OCFileGlobalSymbolsCache.processFileImpl(file, symbols, importsMap)) {
            LOG.error("Symbols were collected incorrectly");
        }
    }

    private static boolean processFileImpl(@NotNull PsiFile file, @NotNull Processor<OCSymbol> symbols, @Nullable Map<OCSymbol, VirtualFile> importsMap) {
        FileSymbolTable fileSymbolTable;
        FileSymbolTable fileSymbolTable2;
        if (!FileSymbolTablesCache.areSymbolsLoaded(file.getProject()) || !OCLanguageUtils.supportsResolve(file)) {
            return true;
        }
        VirtualFile virtualFile = OCFileUtil.getVirtualFile(file);
        List<Object> precompiledHeaders = Collections.emptyList();
        OCImmutableInclusionContext precompiledContext = null;
        OCInclusionContext initial = null;
        OCImmutableInclusionContext context = OCHeaderContextCache.headerContext(file);
        PsiFile importHolder = context.getRootFile();
        OCResolveConfiguration configuration = context.getConfiguration();
        if (configuration != null) {
            precompiledContext = OCInclusionContext.initialPCHContextWithoutRoot(configuration, context.getLanguageKind(), importHolder);
            precompiledHeaders = precompiledContext.getPrecompiledHeaders();
            initial = OCInclusionContext.beforePCHFileContext(configuration, precompiledContext.getLanguageKind(), importHolder);
        }
        if (initial == null) {
            initial = OCInclusionContext.beforePCHFileContext(file);
        }
        assert (initial != null) : "file without OC resolve";
        FileSymbolTable.ProcessingState state = new FileSymbolTable.ProcessingState(initial, false);
        boolean contextWasProcessed = false;
        for (VirtualFile virtualFile2 : precompiledHeaders) {
            FileSymbolTable tableForPch = FileSymbolTable.forFile(virtualFile2, initial);
            if (tableForPch == null) continue;
            if (!precompiledContext.isProcessed(virtualFile)) {
                tableForPch.processSymbols(symbols, null, state, importsMap, virtualFile2, null);
                continue;
            }
            tableForPch.processSymbols(symbols, null, state, importsMap, virtualFile2, virtualFile);
            contextWasProcessed = true;
            break;
        }
        VirtualFile vfImportHolder = OCFileUtil.getVirtualFile(importHolder);
        if (!contextWasProcessed && !vfImportHolder.equals(virtualFile) && (fileSymbolTable2 = FileSymbolTable.forFile(importHolder, initial)) != null) {
            fileSymbolTable2.processSymbols(symbols, null, state, importsMap, null, virtualFile);
            if (initial.isProcessed(virtualFile)) {
                return false;
            }
        }
        if ((fileSymbolTable = FileSymbolTable.forFile(file, initial)) != null) {
            fileSymbolTable.processSymbols(symbols, null, state, importsMap, null, null);
        }
        return true;
    }

    static class Cache {
        private final SLRUSynchronizedCache<PsiFile, OCFileGlobalSymbols> main = new SLRUSynchronizedCache<PsiFile, OCFileGlobalSymbols>(CACHE_SIZE, CACHE_SIZE){

            @Override
            @NotNull
            public OCFileGlobalSymbols createValue(@NotNull PsiFile key) {
                return OCFileGlobalSymbols.buildSymbols(key);
            }
        };
        private final SLRUSynchronizedCache<PsiFile, OCLightFileGlobalSymbols> lightCache = new SLRUSynchronizedCache<PsiFile, OCLightFileGlobalSymbols>(20, 20){

            @Override
            @NotNull
            public OCLightFileGlobalSymbols createValue(@NotNull PsiFile key) {
                return OCLightFileGlobalSymbols.buildSymbols(key, false);
            }
        };
        private final SLRUSynchronizedCache<PsiFile, OCLightFileGlobalSymbols> typesOnlyCache = new SLRUSynchronizedCache<PsiFile, OCLightFileGlobalSymbols>(150, 150){

            @Override
            @NotNull
            public OCLightFileGlobalSymbols createValue(@NotNull PsiFile key) {
                return OCLightFileGlobalSymbols.buildSymbols(key, true);
            }
        };

        Cache() {
        }
    }
}

