/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCRequiresClause;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.impl.OCStructLikeImpl;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCStructImpl
extends OCStructLikeImpl
implements OCStruct {
    public OCStructImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        visitor.visitStruct(this);
    }

    @Override
    public OCSymbolKind getKind() {
        return OCSymbolKind.STRUCT;
    }

    @Override
    @NotNull
    public List<OCDeclaration> getMembers() {
        return PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)this, OCDeclaration.class);
    }

    @Override
    @NotNull
    public List<OCFunctionDeclaration> getConstructors() {
        String name = this.getName();
        ArrayList<OCFunctionDeclaration> result = new ArrayList<OCFunctionDeclaration>();
        OCFunctionDeclaration[] functions = (OCFunctionDeclaration[])PsiTreeUtil.getChildrenOfType((PsiElement)this, OCFunctionDeclaration.class);
        if (functions != null) {
            for (OCFunctionDeclaration declaration : functions) {
                if (!Objects.equals(name, declaration.getName())) continue;
                result.add(declaration);
            }
        }
        return result;
    }

    @Override
    @Nullable
    public OCRequiresClause getRequiresClause() {
        PsiElement parent = this.getParent();
        if (parent == null) {
            return null;
        }
        PsiElement declaration = parent.getParent();
        if (!(declaration instanceof OCDeclaration)) {
            return null;
        }
        return ((OCDeclaration)declaration).getRequiresClause();
    }
}

