/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.OCFileType;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.psi.OCPsiFile;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculator;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCPsiFileBaseImpl
extends PsiFileBase
implements OCPsiFile {
    @Nullable
    private volatile OCLanguageKind myFileKindCache;

    public OCPsiFileBaseImpl(FileViewProvider viewProvider, Language language) {
        super(viewProvider, language);
    }

    @NotNull
    public FileType getFileType() {
        return OCFileType.INSTANCE;
    }

    @Override
    public boolean isHeader() {
        return OCFileTypeHelpers.isHeaderFile((String)this.getName());
    }

    @Override
    @NotNull
    public OCLanguageKind getRootKind(@Nullable OCResolveConfiguration config) {
        return OCLanguageKindCalculator.calculateLanguageKind(config, this, false);
    }

    @Override
    @NotNull
    public final OCLanguageKind getKind() {
        OCLanguageKind result = this.myFileKindCache;
        if (result == null) {
            this.myFileKindCache = result = this.calculateKind();
        }
        return result;
    }

    @NotNull
    @ApiStatus.Internal
    protected OCLanguageKind calculateKind() {
        return OCLanguageKindCalculator.calculateLanguageKind(this);
    }

    public void clearCaches() {
        this.myFileKindCache = null;
        super.clearCaches();
    }

    @Override
    public boolean isInProjectSources() {
        return OCSearchScope.isInProjectSources((PsiElement)this);
    }

    @Override
    public boolean isInLibraries() {
        return OCSearchScope.isInLibraries((PsiElement)this);
    }
}

