/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCPostfixExpression;
import com.jetbrains.cidr.lang.psi.impl.OCExpressionWithReferenceBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCPostfixExpressionImpl
extends OCExpressionWithReferenceBase<OCOperatorReference>
implements OCPostfixExpression {
    public OCPostfixExpressionImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    @Nullable
    protected OCOperatorReference createReference() {
        String name = this.getOperationSign().getName();
        return new OCOperatorReference((PsiElement)this, name, OCOperatorReference.OperatorPlacement.POSTFIX, this.getOperationSignNode().getPsi(), this.getOperand());
    }

    @Override
    @NotNull
    public OCExpression getOperand() {
        return (OCExpression)this.findChildByType(OCElementTypes.EXPRESSIONS);
    }

    @Override
    @NotNull
    public OCElementType getOperationSign() {
        return (OCElementType)this.getOperationSignNode().getElementType();
    }

    @Override
    @NotNull
    public ASTNode getOperationSignNode() {
        return this.getNode().getLastChildNode();
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        visitor.visitPostfixExpression(this);
    }

    @Override
    @NotNull
    protected OCType getType(@NotNull OCResolveContext context) {
        OCOperatorReference reference = (OCOperatorReference)this.getReference();
        if (reference != null) {
            for (OCSymbol operator : reference.resolveToSymbols(context)) {
                if (!(operator instanceof OCFunctionSymbol)) continue;
                return ((OCFunctionSymbol)operator).getEffectiveType(this);
            }
        }
        return this.getOperand().getResolvedType(context);
    }
}

