/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCMacroRange;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCMacroForeignLeafElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMacroCallArgument;
import com.jetbrains.cidr.lang.psi.OCMacroParameterList;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.impl.OCElementBase;
import com.jetbrains.cidr.lang.psi.impl.OCMacroReferenceElementImpl;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCImmutableList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCMacroCallImpl
extends OCElementBase
implements OCMacroCall {
    public OCMacroCallImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    @Nullable
    public OCReferenceElement getMacroReferenceElement() {
        return (OCReferenceElement)this.findChildByType((IElementType)OCElementTypes.MACRO_REF);
    }

    @Override
    @Nullable
    public OCExpression getExpansionExpression() {
        OCMacroRange range;
        OCExpression next;
        OCMacroRange range2;
        OCMacroCallImpl element = this;
        PsiElement nextElement = element.getNextSibling();
        while (nextElement instanceof OCMacroCall) {
            element = nextElement;
            nextElement = element.getNextSibling();
        }
        PsiElement firstLeaf = OCMacroCallImpl.nextLeaf(element);
        OCExpression expression = (OCExpression)PsiTreeUtil.getContextOfType((PsiElement)firstLeaf, (Class[])new Class[]{OCExpression.class});
        while (!(expression == null || (range2 = OCElementUtil.getRangeInMacroCall(expression)) != null && range2.getMacroCall().equals(this))) {
            expression = (OCExpression)PsiTreeUtil.getContextOfType((PsiElement)expression, (Class[])new Class[]{OCExpression.class});
        }
        while (expression != null && (next = (OCExpression)PsiTreeUtil.getContextOfType((PsiElement)expression, (Class[])new Class[]{OCExpression.class})) != null && (range = OCElementUtil.getRangeInMacroCall(next)) != null && range.getMacroCall().equals(this)) {
            expression = next;
        }
        return expression;
    }

    @Override
    public PsiElement getLastExpansionLeaf() {
        PsiElement next;
        PsiElement leaf = this.getFirstExpansionLeaf();
        while (leaf != null && (next = OCMacroCallImpl.nextLeaf(leaf)) instanceof ForeignLeafPsiElement) {
            leaf = next;
        }
        return leaf;
    }

    private int processExpansionLeavesAndReturnLastOffsetForInlining(@NotNull Processor<? super PsiElement> processor) {
        Pair<PsiElement, Integer> exp = this.getFirstExpansionLeafAndEndOffset();
        PsiElement leaf = (PsiElement)exp.first;
        while (leaf instanceof OCMacroForeignLeafElement && processor.process((Object)leaf)) {
            PsiElement next = OCMacroCallImpl.nextLeaf(leaf);
            if (!(next instanceof OCMacroForeignLeafElement)) {
                PsiElement maybeMacroCallAsContinuation;
                if (next == null || !((maybeMacroCallAsContinuation = next.getParent()) instanceof OCMacroCallImpl)) break;
                exp = ((OCMacroCallImpl)maybeMacroCallAsContinuation).getFirstExpansionLeafAndEndOffset();
                leaf = (PsiElement)exp.first;
                continue;
            }
            leaf = next;
        }
        return (Integer)exp.second;
    }

    @Override
    public void processExpansionLeaves(@NotNull Processor<? super PsiElement> processor) {
        this.processExpansionLeavesAndReturnLastOffsetForInlining(processor);
    }

    @Override
    public PsiElement getFirstExpansionLeaf() {
        return (PsiElement)this.getFirstExpansionLeafAndEndOffset().first;
    }

    @NotNull
    private Pair<PsiElement, Integer> getFirstExpansionLeafAndEndOffset() {
        PsiElement firstLeaf;
        OCMacroCallImpl endAnchor = this;
        PsiElement nextElement = endAnchor.getNextSibling();
        while (nextElement instanceof OCMacroCall) {
            endAnchor = nextElement;
            nextElement = endAnchor.getNextSibling();
        }
        PsiElement maybeMacroParametersList = endAnchor.getFirstChild();
        if (maybeMacroParametersList instanceof OCMacroParameterList) {
            endAnchor = maybeMacroParametersList;
        }
        return Pair.create((Object)((firstLeaf = OCMacroCallImpl.nextLeaf(endAnchor)) instanceof OCMacroForeignLeafElement ? firstLeaf : null), (Object)endAnchor.getTextRange().getEndOffset());
    }

    @Override
    public OCMacroSymbol resolveToSymbol() {
        OCMacroReferenceElementImpl macroRef = (OCMacroReferenceElementImpl)this.getMacroReferenceElement();
        if (macroRef == null) {
            return null;
        }
        OCSymbol symbol = macroRef.resolveToSymbol();
        return symbol instanceof OCMacroSymbol ? (OCMacroSymbol)symbol : null;
    }

    @Override
    public List<OCMacroCallArgument> getArguments() {
        return this.findChildrenByType((IElementType)OCElementTypes.MACRO_ARGUMENT);
    }

    @Override
    @NotNull
    public OCMacroCall.ParameterCheckResult checkParameters(@NotNull OCMacroSymbol symbol) {
        int minArgCount;
        List<OCMacroCallArgument> args = this.getArguments();
        int argCount = args.size();
        if (!symbol.hasParameterList()) {
            return argCount == 0 ? new OCMacroCall.ParameterCheckResult(-1, -1) : new OCMacroCall.ParameterCheckResult(argCount, 0);
        }
        OCImmutableList<String> parameterNames = symbol.getParameterNames();
        if (parameterNames.isEmpty() && (argCount == 0 || argCount == 1 && OCElementUtil.isWhitespace(args.get(0)))) {
            return new OCMacroCall.ParameterCheckResult(0, 0);
        }
        boolean isVararg = symbol.isVararg();
        int n = minArgCount = isVararg ? parameterNames.size() - 1 : parameterNames.size();
        if (argCount < minArgCount || argCount > minArgCount && !isVararg) {
            return new OCMacroCall.ParameterCheckResult(argCount, minArgCount);
        }
        return new OCMacroCall.ParameterCheckResult(argCount, argCount);
    }

    @Override
    @NotNull
    public Pair<String, TextRange> getReplacementTextAndRange() {
        StringBuilder answer = new StringBuilder();
        boolean[] wasIdent = new boolean[]{false};
        int endOfSubstitution = this.processExpansionLeavesAndReturnLastOffsetForInlining((Processor<? super PsiElement>)((Processor)leaf -> {
            if (PsiTreeUtil.getContextOfType((PsiElement)leaf, (Class[])new Class[]{OCMacroCall.class}) == null) {
                IElementType type = ((ForeignLeafPsiElement)leaf).getElementType();
                if (type != OCTokenTypes.AT && (type == OCTokenTypes.IDENTIFIER || OCTokenTypes.KEYWORDS.contains(type) || OCTokenTypes.LITERALS.contains(type))) {
                    if (wasIdent[0]) {
                        answer.append(' ');
                    }
                    wasIdent[0] = true;
                } else {
                    wasIdent[0] = false;
                }
                answer.append(leaf.getText());
            }
            return true;
        }));
        return Pair.create((Object)answer.toString(), (Object)TextRange.create((int)this.getTextRange().getStartOffset(), (int)endOfSubstitution));
    }

    @Override
    public boolean processExpansionDependencies(@NotNull Processor<PsiElement> processor) {
        return this.processExpansionDependenciesWithIdent(null, processor);
    }

    @Override
    public boolean processExpansionDependenciesWithIdent(@Nullable String ident, @NotNull Processor<PsiElement> processor) {
        PsiElement leaf = OCMacroCallImpl.nextLeaf(this);
        while (leaf instanceof PsiComment) {
            leaf = OCMacroCallImpl.nextLeaf(leaf);
        }
        HashSet<PsiElement> processed = new HashSet<PsiElement>();
        OCReferenceElement ref = this.getMacroReferenceElement();
        if (ref == null) {
            return true;
        }
        String macroName = ref.getName();
        while (leaf instanceof OCMacroForeignLeafElement && macroName.equals(((OCMacroForeignLeafElement)leaf).getMacroName())) {
            if (PsiTreeUtil.getContextOfType((PsiElement)leaf, (Class[])new Class[]{OCMacroCall.class}) == null) {
                if (ident == null || leaf.getText().equals(ident)) {
                    for (PsiElement parent = leaf; parent != null && !processed.contains(parent); parent = parent.getContext()) {
                        if (!processor.process((Object)parent)) {
                            return false;
                        }
                        processed.add(parent);
                    }
                }
            }
            leaf = OCMacroCallImpl.nextLeaf(leaf);
        }
        return true;
    }

    @Nullable
    private static PsiElement nextLeaf(PsiElement node) {
        PsiElement leaf;
        while ((leaf = PsiTreeUtil.nextLeaf((PsiElement)node)) != null && !(leaf.getNode() instanceof LeafElement)) {
            node = leaf;
        }
        return leaf;
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        visitor.visitMacroCall(this);
    }
}

