/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCIncludeDirective;
import com.jetbrains.cidr.lang.psi.impl.OCIncludeDirectiveImpl;
import com.jetbrains.cidr.lang.qualifiedName.QualifiedName;
import com.jetbrains.cidr.lang.resolve.references.OCImportModuleReference;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCImportModuleStatementImpl
extends OCIncludeDirectiveImpl {
    public OCImportModuleStatementImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    @NotNull
    public PsiElement getHeaderToken() {
        PsiElement importKeyword = this.findChildByType((IElementType)OCTokenTypes.IMPORT_MODULE_KEYWORD);
        return importKeyword == null ? super.getHeaderToken() : importKeyword;
    }

    @Nullable
    public QualifiedName getModuleName() {
        ArrayList<String> parts2 = new ArrayList<String>();
        for (ASTNode node = this.getNode().getFirstChildNode(); node != null; node = node.getTreeNext()) {
            IElementType tt = node.getElementType();
            if (tt != OCTokenTypes.IDENTIFIER) continue;
            parts2.add(node.getText());
        }
        if (parts2.isEmpty()) {
            return null;
        }
        return QualifiedName.of(parts2);
    }

    @Override
    @NotNull
    public OCIncludeDirective.Delimiters getDelimiters() {
        return OCIncludeDirective.Delimiters.NONE;
    }

    @Override
    public boolean isAngleBrackets() {
        return true;
    }

    @Override
    public PsiReference @NotNull [] getReferences() {
        return new PsiReference[]{new OCImportModuleReference(this)};
    }

    @Override
    @NotNull
    public String getReferenceText() {
        QualifiedName moduleName = this.getModuleName();
        if (moduleName == null) {
            return "";
        }
        return moduleName.toString();
    }

    @Override
    public boolean isValidDirective() {
        PsiReference[] references;
        for (PsiReference reference : references = this.getReferences()) {
            if (!(reference instanceof OCImportModuleReference) || ((OCImportModuleReference)reference).isValid()) continue;
            return false;
        }
        return references.length > 0;
    }
}

