/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileInfoManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.OCIncludeHelpers;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.autoImport.OCAutoImportHelper;
import com.jetbrains.cidr.lang.preprocessor.OCFileUtil;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.preprocessor.OCResolveRootAndConfiguration;
import com.jetbrains.cidr.lang.preprocessor.OCResolveRootAndConfigurationCache;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCIncludeDirective;
import com.jetbrains.cidr.lang.symbols.cpp.OCIncludeSymbol;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class OCFileReference
extends FileReference {
    private static final Logger LOG = Logger.getInstance(OCFileReference.class);
    private final OCIncludeDirective myDirective;
    private final Project myProject;
    private String myIncludedFilePath = null;
    private boolean myRenameOnly = false;
    private OCAutoImportHelper.ImportSpecification myNewImportSpecification = null;
    private OCIncludeDirective.Delimiters myNewDelimiters = null;
    private OCResolveRootAndConfiguration myResolveRootAndConfiguration = null;

    public OCFileReference(@NotNull FileReferenceSet fileReferenceSet, TextRange range, int index, String text, @NotNull OCIncludeDirective directive, @NotNull Project project) {
        super(fileReferenceSet, range, index, text);
        this.myDirective = directive;
        this.myProject = project;
    }

    public void preprocessHeaderRootsAndActiveConfiguration() {
        VirtualFile targetFile;
        Application application = ApplicationManager.getApplication();
        LOG.assertTrue(application.isUnitTestMode() || !application.isDispatchThread());
        PsiFile includedPsiFile = this.myDirective.getIncludedFile();
        if (includedPsiFile != null) {
            VirtualFile includedVirtualFile = OCElementUtil.getFilePath(includedPsiFile);
            String string = this.myIncludedFilePath = includedVirtualFile != null ? includedVirtualFile.getPath() : null;
        }
        if ((targetFile = OCFileUtil.getVirtualFile(this.getContainingOCFile())) != null) {
            this.myResolveRootAndConfiguration = OCResolveRootAndConfigurationCache.getInstance(this.myProject).getResolveRootAndActiveConfiguration(targetFile);
        }
    }

    public PsiElement bindToElement(@NotNull PsiElement element, boolean absolute) throws IncorrectOperationException {
        String newFilePath;
        VirtualFile newVirtualFile;
        if (this.myIncludedFilePath != null && element instanceof PsiFile && (newVirtualFile = OCElementUtil.getVirtualFile(element)) != null && !OCFileReference.shouldChangePath(PathUtil.getParentPath((String)(newFilePath = newVirtualFile.getPath())), PathUtil.getParentPath((String)this.myIncludedFilePath))) {
            this.myRenameOnly = true;
            return super.bindToElement(element, absolute);
        }
        class ImportProcessor
        implements Processor<OCAutoImportHelper.ImportSpecification> {
            public OCAutoImportHelper.ImportSpecification bestImportSpecification = null;
            public OCIncludeDirective.Delimiters bestDelimiters = null;
            public boolean exactMatch = false;
            public boolean renameOnly = false;

            ImportProcessor() {
            }

            public boolean process(OCAutoImportHelper.ImportSpecification specification) {
                OCIncludeDirective.Delimiters delimiters;
                assert (!this.exactMatch && !this.renameOnly);
                OCIncludeDirective.Delimiters currentDelimiters = OCFileReference.this.myDirective.getDelimiters();
                if (specification.areDelimitersAllowed(currentDelimiters)) {
                    if (!OCFileReference.shouldChangePath(specification.getImportPath(), OCFileReference.this.getReferenceText())) {
                        this.exactMatch = true;
                    } else if (!OCFileReference.shouldChangePath(PathUtil.getParentPath((String)specification.getImportPath()), PathUtil.getParentPath((String)OCFileReference.this.getReferenceText()))) {
                        this.renameOnly = true;
                    }
                    if (this.exactMatch || this.renameOnly) {
                        this.bestImportSpecification = specification;
                        this.bestDelimiters = currentDelimiters;
                        return false;
                    }
                }
                OCIncludeDirective.Delimiters delimiters2 = delimiters = specification.areDelimitersAllowed(currentDelimiters) ? currentDelimiters : specification.getPreferredDelimiters();
                if (this.bestImportSpecification == null || this.bestDelimiters != currentDelimiters && delimiters == currentDelimiters) {
                    this.bestImportSpecification = specification;
                    this.bestDelimiters = delimiters;
                }
                return true;
            }
        }
        ImportProcessor processor = new ImportProcessor();
        VirtualFile fileToImport = element instanceof PsiFile ? OCFileUtil.getVirtualFile((PsiFile)element) : null;
        VirtualFile targetFile = OCFileUtil.getVirtualFile(this.getContainingOCFile());
        if (OCInclusionContextUtil.isLongLived(fileToImport) && targetFile != null) {
            OCResolveRootAndConfiguration resolveRootAndConfiguration = this.getResolveRootAndConfiguration(targetFile);
            OCIncludeHelpers.processImportSpecifications(this.myProject, resolveRootAndConfiguration, targetFile, fileToImport, processor);
        }
        this.myRenameOnly = processor.renameOnly;
        if (processor.bestImportSpecification == null || processor.exactMatch) {
            return this.myDirective;
        }
        this.myNewImportSpecification = processor.bestImportSpecification;
        this.myNewDelimiters = processor.bestDelimiters;
        return super.bindToElement(element, absolute);
    }

    protected PsiElement rename(String newName) throws IncorrectOperationException {
        if (this.myRenameOnly) {
            return super.rename(this.myDirective.getDelimiters().getBeforeText() + this.getNewImportText(newName) + this.myDirective.getDelimiters().getAfterText());
        }
        if (this.myNewImportSpecification == null || this.myNewDelimiters == null) {
            OCLog.LOG.error("Invalid rename for include directive");
            return super.rename(newName);
        }
        return super.rename(this.myNewImportSpecification.getImportText(this.myNewDelimiters));
    }

    @NotNull
    private String getNewImportText(@NotNull String newName) {
        File oldFilePath = new File(this.getReferenceText());
        File newFilePath = new File(newName);
        String oldFileName = oldFilePath.getName();
        String newFileName = newFilePath.getName();
        int fileNameIndex = this.getReferenceText().lastIndexOf(oldFileName);
        if (fileNameIndex < 0) {
            LOG.error("Failed to rename import directive: ImportText: " + this.getReferenceText() + "; FileName: " + oldFileName + "; NewFileName: " + newFileName);
            return this.getReferenceText();
        }
        return this.getReferenceText().substring(0, fileNameIndex) + newFileName;
    }

    protected ResolveResult @NotNull [] innerResolve(boolean caseSensitive, @NotNull PsiFile containingFile) {
        PsiFile file;
        OCIncludeSymbol include = this.getContainingOCFile().findSymbol(this.myDirective, OCIncludeSymbol.class);
        if (include != null && include.getTargetFile() != null && include.getTargetFile().isValid() && (file = PsiManager.getInstance((Project)this.myProject).findFile(include.getTargetFile())) != null) {
            return new ResolveResult[]{new PsiElementResolveResult((PsiElement)file)};
        }
        return super.innerResolve(caseSensitive, containingFile);
    }

    protected Object createLookupItem(PsiElement candidate) {
        if (candidate instanceof PsiFile) {
            PsiFile file = (PsiFile)candidate;
            return new LookupElementDecorator<LookupElement>((LookupElement)FileInfoManager.getFileLookupItem((PsiElement)file, (String)file.getName(), (Icon)file.getIcon(0))){

                public boolean requiresCommittedDocuments() {
                    return false;
                }
            };
        }
        return super.createLookupItem(candidate);
    }

    @NotNull
    private OCResolveRootAndConfiguration getResolveRootAndConfiguration(@NotNull VirtualFile targetFile) {
        if (this.myResolveRootAndConfiguration != null) {
            return this.myResolveRootAndConfiguration;
        }
        this.myResolveRootAndConfiguration = OCResolveRootAndConfigurationCache.getInstance(this.myProject).getResolveRootAndActiveConfiguration(targetFile);
        return this.myResolveRootAndConfiguration;
    }

    private OCFile getContainingOCFile() {
        return this.myDirective.getContainingOCFile();
    }

    private String getReferenceText() {
        return this.myDirective.getReferenceText();
    }

    private static boolean shouldChangePath(@NotNull String candidate, @NotNull String existing) {
        return existing.contains("\\") || !FileUtil.toCanonicalPath((String)candidate, (boolean)false).equals(FileUtil.toCanonicalPath((String)existing, (boolean)false));
    }
}

