/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.psi.OCReference;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.impl.OCElementWithReferenceBase;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public abstract class OCElementWithReferenceId<S extends OCSymbol>
extends OCElementWithReferenceBase<OCReference<S>>
implements PsiNameIdentifierOwner,
OCSymbolDeclarator<S> {
    public OCElementWithReferenceId(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    @NotNull
    protected OCReference<S> createReference() {
        return new OCReference<S>(){

            @NotNull
            public PsiElement getElement() {
                return OCElementWithReferenceId.this;
            }

            @NotNull
            public TextRange getRangeInElement() {
                PsiElement ident = OCElementWithReferenceId.this.getNameIdentifier();
                if (ident == null) {
                    return TextRange.EMPTY_RANGE;
                }
                TextRange range = ident.getTextRange();
                if (range.isEmpty()) {
                    return TextRange.EMPTY_RANGE;
                }
                return range.shiftLeft(OCElementWithReferenceId.this.getTextRange().getStartOffset());
            }

            public PsiElement resolve() {
                Object symbol = this.resolveToSymbol();
                return symbol != null ? symbol.locateDefinition(OCElementWithReferenceId.this.getProject()) : null;
            }

            @NotNull
            public String getCanonicalText() {
                return StringUtil.notNullize((String)OCElementWithReferenceId.this.getName());
            }

            @Contract(pure=true)
            public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
                return OCElementWithReferenceId.this;
            }

            @Override
            public PsiElement bindToSymbol(@NotNull OCSymbol symbol) {
                return this.handleElementRename(symbol.getName());
            }

            public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
                Object symbol = ((OCSymbolDeclarator)element).getSymbol();
                return symbol != null ? this.bindToSymbol((OCSymbol)symbol) : element;
            }

            public boolean isReferenceTo(@NotNull PsiElement element) {
                return element == OCElementWithReferenceId.this;
            }

            public boolean isSoft() {
                return false;
            }

            @Override
            public S resolveToSymbol() {
                return OCElementWithReferenceId.this.getSymbol();
            }
        };
    }
}

