/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.CommonProcessors;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCConceptDeclaration;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCRequiresClause;
import com.jetbrains.cidr.lang.psi.impl.OCElementBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.symbols.DeclarationContext;
import com.jetbrains.cidr.lang.symbols.OCBuilderDriver;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbolReferenceResolver;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCConceptSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCConceptDeclarationImpl
extends OCElementBase
implements OCConceptDeclaration {
    public OCConceptDeclarationImpl(@NotNull ASTNode node) {
        super(node);
    }

    public String getName() {
        PsiElement nameNode = this.getNameIdentifier();
        return nameNode != null ? nameNode.getText() : null;
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        visitor.visitConcept(this);
    }

    @Override
    public int getTextOffset() {
        return OCSymbolOffsetUtil.getTextOffset(this.getComplexOffset());
    }

    @Override
    public long getComplexOffset() {
        PsiElement ident = this.getNameIdentifier();
        return ident == null ? super.getComplexOffset() : OCSymbolOffsetUtil.getComplexOffset(ident);
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        PsiElement ident = this.findChildByType((IElementType)OCTokenTypes.IDENTIFIER);
        if (ident == null) {
            OCReferenceElement ref = (OCReferenceElement)this.findChildByType((IElementType)OCElementTypes.REFERENCE_ELEMENT);
            return ref != null ? ref.getLastChild() : null;
        }
        return ident;
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        OCElementUtil.replaceWithIdentifier(this.getNameIdentifier(), name, this);
        return this;
    }

    @Override
    @Nullable
    public OCConceptSymbol getLocalSymbol() {
        OCFile file = this.getContainingOCFile();
        OCSymbolWithQualifiedName parent = OCSymbolReferenceResolver.getGlobalContextFromLocal(this);
        DeclarationContext declarationContext = new DeclarationContext(null, null, parent, OCVisibility.PUBLIC, null, false);
        CommonProcessors.FindFirstProcessor<OCSymbol> finder = new CommonProcessors.FindFirstProcessor<OCSymbol>(){

            protected boolean accept(OCSymbol symbol) {
                return symbol instanceof OCConceptSymbol;
            }
        };
        OCBuilderDriver<ASTNode> builderDriver = OCBuilderDriver.createForASTNode(this.getNode(), file, (Processor<OCSymbol>)finder);
        builderDriver.processConceptDeclaration(this.getNode(), (Processor<OCSymbol>)finder, declarationContext);
        return (OCConceptSymbol)finder.getFoundValue();
    }

    @Override
    @Nullable
    public OCConceptSymbol getSymbol() {
        OCConceptSymbol symbol = this.getContainingOCFile().findSymbol(this, OCConceptSymbol.class);
        return symbol != null ? symbol : this.getLocalSymbol();
    }

    @Override
    @Nullable
    public String getSymbolName() {
        return this.getName();
    }

    @Override
    @Nullable
    public OCRequiresClause getRequiresClause() {
        return (OCRequiresClause)this.findChildByType((IElementType)OCElementTypes.CPP_REQUIRES_CLAUSE);
    }
}

