/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializerMember;
import com.jetbrains.cidr.lang.psi.OCDesignatedInitializer;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.impl.OCExpressionBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.resolve.v2.TypeProperties;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCBracedInitListType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCExpectedTypeUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCompoundInitializerImpl
extends OCExpressionBase
implements OCCompoundInitializer {
    public OCCompoundInitializerImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        visitor.visitCompoundInitializer(this);
    }

    @Override
    @NotNull
    public List<OCCompoundInitializerMember> getInitializers() {
        ArrayList<OCCompoundInitializerMember> list = new ArrayList<OCCompoundInitializerMember>();
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType tt = child.getElementType();
            if (OCElementTypes.EXPRESSIONS.contains(tt)) {
                list.add((OCCompoundInitializerMember)child.getPsi());
                continue;
            }
            if (tt != OCElementTypes.DESIGNATED_INITIALIZER) continue;
            list.add((OCCompoundInitializerMember)child.getPsi());
        }
        return list;
    }

    @Override
    @NotNull
    public List<OCExpression> getInitializerExpressions() {
        return ContainerUtil.map(this.getInitializers(), member -> member instanceof OCDesignatedInitializer ? ((OCDesignatedInitializer)member).getInitializer() : (OCExpression)member);
    }

    @NotNull
    public OCArgumentsList<OCExpression> getArgumentList(@Nullable OCResolveContext context) {
        return OCArgumentsList.getArgumentList(this.getInitializerExpressions(), context);
    }

    @Override
    @Nullable
    public OCType inferType() {
        return OCExpectedTypeUtil.getExpectedType((OCExpression)this, false);
    }

    @Override
    @Nullable
    public OCType inferChildType(OCElement element) {
        OCType refType = this.inferType();
        if (refType == null) {
            return null;
        }
        List children = this.findChildrenByType(OCElementTypes.COMPOUND_INITIALIZER_EXPRESSIONS);
        OCType type = refType.resolve(this);
        if (refType instanceof OCArrayType) {
            return new ChildTypeInference(this, (List<PsiElement>)children, element).traverseArray((OCArrayType)type, null);
        }
        if (type instanceof OCStructType) {
            return new ChildTypeInference(this, (List<PsiElement>)children, element).traverseStruct((OCStructType)type, new HashSet<OCSymbol>());
        }
        return null;
    }

    @Override
    public void inferChildTypes(Map<PsiElement, Pair<OCType, OCSymbol>> acc, Set<OCSymbol> initedFields) {
        Pair refType;
        if (acc.containsKey(this)) {
            refType = acc.get(this);
        } else {
            refType = new Pair((Object)this.inferType(), null);
            acc.put(this, (Pair<OCType, OCSymbol>)refType);
        }
        if (refType == null) {
            return;
        }
        List children = this.findChildrenByType(OCElementTypes.COMPOUND_INITIALIZER_EXPRESSIONS);
        OCType type = ((OCType)refType.first).resolve(this);
        if (type instanceof OCArrayType) {
            new ChildTypeInference(this, (List<PsiElement>)children, acc).traverseArray((OCArrayType)type, null);
        } else if (type instanceof OCStructType) {
            new ChildTypeInference(this, (List<PsiElement>)children, acc).traverseStruct((OCStructType)type, initedFields);
        }
    }

    @Override
    @NotNull
    protected OCType getType(@NotNull OCResolveContext context) {
        return OCBracedInitListType.INSTANCE;
    }

    private static class ChildTypeInference {
        private final PsiElement myTarget;
        private final List<PsiElement> myChildren;
        private final Map<PsiElement, Pair<OCType, OCSymbol>> myAcc;
        @NotNull
        private final OCCompoundInitializerImpl myInitializer;
        private final int myChildrenSize;
        int myChildCounter;

        private ChildTypeInference(@NotNull OCCompoundInitializerImpl initializer, List<PsiElement> children, PsiElement target) {
            this.myInitializer = initializer;
            this.myChildren = children;
            this.myChildrenSize = this.myChildren.size();
            this.myChildCounter = 0;
            this.myTarget = target;
            this.myAcc = null;
        }

        ChildTypeInference(@NotNull OCCompoundInitializerImpl initializer, List<PsiElement> children, Map<PsiElement, Pair<OCType, OCSymbol>> acc) {
            this.myInitializer = initializer;
            this.myChildren = children;
            this.myChildrenSize = this.myChildren.size();
            this.myChildCounter = 0;
            this.myTarget = null;
            this.myAcc = acc;
        }

        @Nullable
        private OCType traverseStruct(OCStructType struct, Set<OCSymbol> initedFields) {
            List<OCDeclaratorSymbol> fields = struct.getFields();
            int fieldsSize = struct.getKind() == OCSymbolKind.UNION ? Math.min(fields.size(), 1) : fields.size();
            int fieldCounter = 0;
            while (fieldCounter < fieldsSize && this.myChildCounter < this.myChildrenSize) {
                OCType result;
                OCExpression expression;
                OCDeclaratorSymbol field = fields.get(fieldCounter);
                PsiElement child = this.myChildren.get(this.myChildCounter);
                if (field.getKind() != OCSymbolKind.STRUCT_FIELD || initedFields.contains(field)) {
                    ++fieldCounter;
                    continue;
                }
                if (child instanceof OCDesignatedInitializer) {
                    if (this.myAcc != null) {
                        this.myAcc.put(child, (Pair<OCType, OCSymbol>)new Pair((Object)field.getType(), (Object)field));
                    }
                    if (child == this.myTarget) {
                        return field.getType();
                    }
                    OCDesignatedInitializer initializer = (OCDesignatedInitializer)child;
                    OCSymbol symbol = initializer.getDesignation().resolveToSymbol();
                    initedFields.add(symbol);
                    ++this.myChildCounter;
                    continue;
                }
                if (child instanceof OCCompoundInitializer) {
                    if (this.myAcc != null) {
                        this.myAcc.put(child, (Pair<OCType, OCSymbol>)new Pair((Object)field.getType(), (Object)field));
                        ((OCCompoundInitializer)child).inferChildTypes(this.myAcc, (Set<OCSymbol>)(field.isUnnamed() ? initedFields : new HashSet<OCSymbol>()));
                    }
                    if (child == this.myTarget) {
                        return field.getType();
                    }
                    initedFields.add(field);
                    ++fieldCounter;
                    ++this.myChildCounter;
                    continue;
                }
                boolean sameType = false;
                OCResolveContext context = OCResolveContext.forPsi(child);
                OCType fieldType = field.getType().resolve(context);
                if (child instanceof OCExpression && fieldType.isCompatible((expression = (OCExpression)child).getResolvedType(), context)) {
                    sameType = true;
                }
                if (!sameType && TypeProperties.isAggregateType(fieldType)) {
                    result = this.traverseStruct((OCStructType)fieldType, (Set<OCSymbol>)(field.isUnnamed() ? initedFields : new HashSet<OCSymbol>()));
                    if (result != null) {
                        return result;
                    }
                    initedFields.add(field);
                    ++fieldCounter;
                    continue;
                }
                if (!sameType && fieldType instanceof OCArrayType) {
                    result = this.traverseArray((OCArrayType)fieldType, field);
                    if (result != null) {
                        return result;
                    }
                    initedFields.add(field);
                    ++fieldCounter;
                    continue;
                }
                if (this.myAcc != null) {
                    this.myAcc.put(child, (Pair<OCType, OCSymbol>)new Pair((Object)field.getType(), (Object)field));
                }
                if (child == this.myTarget) {
                    return field.getType();
                }
                initedFields.add(field);
                ++fieldCounter;
                ++this.myChildCounter;
            }
            return null;
        }

        @Nullable
        private OCType traverseArray(OCArrayType array, @Nullable OCSymbol symbol) {
            OCType elementType = array.getRefType();
            if (!this.myChildren.isEmpty()) {
                elementType = elementType.resolve(this.myChildren.get(0));
            }
            int elementCounter = 0;
            OCResolveContext context = OCResolveContext.forPsi(this.myInitializer);
            boolean emptyArray = elementType instanceof OCStructType && ((OCStructType)elementType).isEmpty(new HashSet<OCStructSymbol>(), context) || elementType instanceof OCArrayType && ((OCArrayType)elementType).isEmpty(new HashSet<OCStructSymbol>(), context);
            int length = array.getLength(context);
            while ((length == -1 || elementCounter < length) && this.myChildCounter < this.myChildrenSize) {
                OCSymbol curSymbol;
                OCType type;
                OCType result;
                OCType type2;
                PsiElement child = this.myChildren.get(this.myChildCounter);
                boolean sameType = false;
                if (child instanceof OCDesignatedInitializer || child instanceof OCCompoundInitializer) {
                    sameType = true;
                } else if (child instanceof OCExpression && elementType.isCompatible(type2 = ((OCExpression)child).getResolvedType(context), context)) {
                    sameType = true;
                }
                if (sameType) {
                    if (this.myAcc != null) {
                        this.myAcc.put(child, (Pair<OCType, OCSymbol>)new Pair((Object)array.getRefType(), null));
                    }
                    if (child == this.myTarget) {
                        if (child instanceof OCExpression && emptyArray) break;
                        return array.getRefType();
                    }
                    ++this.myChildCounter;
                    ++elementCounter;
                    continue;
                }
                if (elementType instanceof OCStructType && ((OCStructType)elementType).getKind() == OCSymbolKind.STRUCT) {
                    if (emptyArray) break;
                    result = this.traverseStruct((OCStructType)elementType, new HashSet<OCSymbol>());
                    if (result != null) {
                        return result;
                    }
                    ++elementCounter;
                    continue;
                }
                if (elementType instanceof OCArrayType) {
                    if (emptyArray) break;
                    result = this.traverseArray((OCArrayType)elementType, null);
                    if (result != null) {
                        return result;
                    }
                    ++elementCounter;
                    continue;
                }
                boolean isCharArray = false;
                OCExpression innerChild = null;
                if (child instanceof OCExpression) {
                    innerChild = OCParenthesesUtils.diveIntoParentheses((OCExpression)child);
                }
                if (innerChild instanceof OCLiteralExpression && array.isCString() && (type = ((OCExpression)child).getResolvedType()).isCString()) {
                    isCharArray = true;
                }
                type = isCharArray ? array : array.getRefType();
                OCSymbol oCSymbol = curSymbol = isCharArray ? symbol : null;
                if (this.myAcc != null) {
                    this.myAcc.put(child, (Pair<OCType, OCSymbol>)Pair.create((Object)type, (Object)curSymbol));
                }
                if (child == this.myTarget) {
                    return type;
                }
                ++this.myChildCounter;
                if (isCharArray) break;
                ++elementCounter;
            }
            return null;
        }
    }
}

