/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi;

import com.jetbrains.cidr.lang.parser.OCKeywordElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public enum OCCastKind {
    STATIC_CAST(OCTokenTypes.STATIC_CAST_CPP_KEYWORD),
    CONST_CAST(OCTokenTypes.CONST_CAST_CPP_KEYWORD),
    DYNAMIC_CAST(OCTokenTypes.DYNAMIC_CAST_CPP_KEYWORD),
    REINTERPRET_CAST(OCTokenTypes.REINTERPRET_CAST_CPP_KEYWORD),
    C_STYLE_CAST(null);

    @NotNull
    private final String myTokenText;

    private OCCastKind(OCKeywordElementType keyword) {
        this.myTokenText = keyword != null ? keyword.getName() : "";
    }

    @NotNull
    public String getTokenText() {
        return this.myTokenText;
    }

    @Contract(value="_, null -> null; _, !null -> !null")
    public static OCCastKind fromToken(OCKeywordElementType keyword, OCCastKind defaultValue) {
        for (OCCastKind kind : OCCastKind.values()) {
            if (!kind.myTokenText.contentEquals(keyword.getName())) continue;
            return kind;
        }
        return defaultValue;
    }
}

