/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.preprocessor;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.preprocessor.MapUtil;
import com.jetbrains.cidr.lang.preprocessor.OCHeaderContextCache;
import com.jetbrains.cidr.lang.preprocessor.OCImportGraph;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextListener;
import com.jetbrains.cidr.lang.preprocessor.OCResolveRootAndConfiguration;
import com.jetbrains.cidr.lang.preprocessor.OCResolveRootAndConfigurationProvider;
import com.jetbrains.cidr.lang.preprocessor.OCRootUtil;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculator;
import com.jetbrains.cidr.lang.workspace.OCPCHCache;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCResolveConfigurations;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class OCResolveRootAndConfigurationCache {
    @NotNull
    private final Project myProject;
    private final Map<VirtualFile, OCResolveRootAndConfiguration> myCache = new ConcurrentHashMap<VirtualFile, OCResolveRootAndConfiguration>();

    public OCResolveRootAndConfigurationCache(@NotNull Project project) {
        this.myProject = project;
    }

    @NotNull
    public static OCResolveRootAndConfigurationCache getInstance(@NotNull Project project) {
        return (OCResolveRootAndConfigurationCache)project.getService(OCResolveRootAndConfigurationCache.class);
    }

    @Nullable
    public OCResolveRootAndConfiguration getResolveRootAndActiveConfigurationSafe(@NotNull VirtualFile virtualFile) {
        try {
            return this.inferAndCache(virtualFile, true);
        }
        catch (IndexNotReadyException e) {
            return null;
        }
    }

    @Deprecated
    @NotNull
    public OCResolveRootAndConfiguration getResolveRootAndActiveConfiguration(@NotNull VirtualFile virtualFile) {
        return this.inferAndCache(virtualFile, false);
    }

    @NotNull
    private OCResolveRootAndConfiguration inferAndCache(@NotNull VirtualFile virtualFile, boolean checkSymbolsAreLoaded) {
        OCResolveRootAndConfiguration cached = this.myCache.get(virtualFile);
        if (cached != null) {
            return cached;
        }
        OCResolveRootAndConfiguration result = this.inferResolveRootAndActiveConfiguration(virtualFile, checkSymbolsAreLoaded);
        this.myCache.put(virtualFile, result);
        ((OCInclusionContextListener)this.myProject.getMessageBus().syncPublisher(OCInclusionContextListener.TOPIC)).resolveRootAndActiveConfigurationChanged(virtualFile, result);
        return result;
    }

    @NotNull
    private OCResolveRootAndConfiguration inferResolveRootAndActiveConfiguration(@NotNull VirtualFile virtualFile, boolean checkSymbolsAreLoaded) {
        OCResolveRootAndConfiguration resolveRootAndConfiguration = OCResolveRootAndConfigurationProvider.inferResolveRootAndConfiguration(virtualFile, this.myProject);
        if (resolveRootAndConfiguration != null) {
            return resolveRootAndConfiguration;
        }
        if (OCRootUtil.isNeedToFindRoot(virtualFile, this.myProject)) {
            if (checkSymbolsAreLoaded && !FileSymbolTablesCache.areSymbolsLoaded(this.myProject)) {
                throw IndexNotReadyException.create();
            }
            OCResolveRootAndConfiguration headerResult = this.inferResolveRootAndActiveConfigurationForHeader(virtualFile);
            if (headerResult != null) {
                return headerResult;
            }
        }
        OCResolveConfiguration preselectedConfiguration = OCResolveConfigurations.getPreselectedConfiguration((VirtualFile)virtualFile, (Project)this.myProject);
        return this.createResolveRootAndConfiguration(preselectedConfiguration, virtualFile);
    }

    public void invalidateForAll() {
        this.invalidateForAllExcept(null);
    }

    public void invalidateForAllExcept(@Nullable VirtualFile virtualFile) {
        this.invalidateExcept(virtualFile);
        OCHeaderContextCache.invalidateHeaderContextsExcept(virtualFile, this.myProject);
    }

    public void invalidateFor(@Nullable VirtualFile virtualFileInEditor) {
        if (virtualFileInEditor == null) {
            return;
        }
        this.myCache.remove(virtualFileInEditor);
        OCHeaderContextCache.invalidateHeaderContextsExcept(null, this.myProject);
    }

    private void invalidateExcept(@Nullable VirtualFile virtualFile) {
        MapUtil.removeExcept(this.myCache, virtualFile);
    }

    @Nullable
    private OCResolveRootAndConfiguration inferResolveRootAndActiveConfigurationForHeader(@NotNull VirtualFile virtualHeaderFile) {
        String headerNameWithoutExtension = virtualHeaderFile.getNameWithoutExtension();
        OCImportGraph importGraph = OCImportGraph.getInstance(this.myProject);
        ArrayList<VirtualFile> roots2 = new ArrayList<VirtualFile>(importGraph.getAllHeaderRoots(virtualHeaderFile));
        roots2.sort(new VirtualFileComparator(this.myProject, headerNameWithoutExtension));
        ArrayList<Pair> rootsThatMayMatchSelectedConfiguration = new ArrayList<Pair>();
        for (VirtualFile root : roots2) {
            Ref scoreRef;
            Collection configs = OCResolveConfigurations.getAllBuildConfigurationsOfTargetsOfFile((VirtualFile)root, (Project)this.myProject);
            if (OCResolveConfigurations.findPreselectedConfiguration((Project)this.myProject, (Collection)configs, (Ref)(scoreRef = new Ref((Object)0))) == null) continue;
            rootsThatMayMatchSelectedConfiguration.add(Pair.create((Object)root, (Object)((Integer)scoreRef.get())));
        }
        rootsThatMayMatchSelectedConfiguration.sort((o1, o2) -> Comparing.compare((Comparable)((Integer)o1.second), (Comparable)((Integer)o2.second)));
        OCResolveRootAndConfiguration fallBack = null;
        HashSet<VirtualFile> visitedRoots = new HashSet<VirtualFile>(rootsThatMayMatchSelectedConfiguration.size());
        for (Pair info : rootsThatMayMatchSelectedConfiguration) {
            VirtualFile rootFile = (VirtualFile)info.first;
            visitedRoots.add(rootFile);
            HashSet<OCResolveConfiguration> configurations = new HashSet<OCResolveConfiguration>();
            importGraph.fillHeaderConfigurationsForRoot(virtualHeaderFile, rootFile, configurations, null);
            if (configurations.isEmpty()) continue;
            OCResolveConfiguration configuration = OCResolveConfigurations.findPreselectedConfiguration((Project)this.myProject, configurations, null);
            if (configuration != null) {
                return this.createResolveRootAndConfiguration(configuration, rootFile);
            }
            if (fallBack != null) continue;
            Pair c = OCResolveConfigurations.findPreselectedOrSuitableConfiguration((Project)this.myProject, configurations);
            if (c.first == null) continue;
            fallBack = this.createResolveRootAndConfiguration((OCResolveConfiguration)c.first, rootFile);
        }
        for (VirtualFile rootFile : roots2) {
            if (visitedRoots.contains(rootFile)) {
                if (fallBack == null || !rootFile.equals(fallBack.getRootFile())) continue;
                return fallBack;
            }
            HashSet<OCResolveConfiguration> configurations = new HashSet<OCResolveConfiguration>();
            importGraph.fillHeaderConfigurationsForRoot(virtualHeaderFile, rootFile, configurations, null);
            Pair c = OCResolveConfigurations.findPreselectedOrSuitableConfiguration((Project)this.myProject, configurations);
            if (c.first == null) continue;
            return this.createResolveRootAndConfiguration((OCResolveConfiguration)c.first, rootFile);
        }
        return null;
    }

    @NotNull
    private OCResolveRootAndConfiguration createResolveRootAndConfiguration(@Nullable OCResolveConfiguration configuration, @NotNull VirtualFile rootFile) {
        OCLanguageKind kind = OCLanguageKindCalculator.calculateLanguageKind(configuration, rootFile, this.myProject, false);
        return new OCResolveRootAndConfiguration(configuration, kind, rootFile);
    }

    private static class VirtualFileComparator
    implements Comparator<VirtualFile> {
        private final Project myProject;
        private final String myHeaderNameWithoutExtension;

        VirtualFileComparator(Project project, String headerNameWithoutExtension) {
            this.myProject = project;
            this.myHeaderNameWithoutExtension = headerNameWithoutExtension.toUpperCase(Locale.getDefault());
        }

        @Override
        public int compare(@NotNull VirtualFile root1, @NotNull VirtualFile root2) {
            int result = Comparing.compare((boolean)OCPCHCache.isPrecompiledHeader((VirtualFile)root1, (Project)this.myProject), (boolean)OCPCHCache.isPrecompiledHeader((VirtualFile)root2, (Project)this.myProject));
            if (result != 0) {
                return -result;
            }
            result = Comparing.compare((boolean)OCFileTypeHelpers.isSourceFile((String)root1.getName()), (boolean)OCFileTypeHelpers.isSourceFile((String)root2.getName()));
            if (result != 0) {
                return -result;
            }
            String rootName1 = root1.getNameWithoutExtension().toUpperCase(Locale.getDefault());
            String rootName2 = root2.getNameWithoutExtension().toUpperCase(Locale.getDefault());
            result = Comparing.compare((boolean)this.myHeaderNameWithoutExtension.equals(rootName1), (boolean)this.myHeaderNameWithoutExtension.equals(rootName2));
            if (result != 0) {
                return -result;
            }
            result = Comparing.compare((Comparable)((Object)rootName1), (Comparable)((Object)rootName2));
            if (result != 0) {
                return result;
            }
            return Comparing.compare((Comparable)((Object)root1.getPath()), (Comparable)((Object)root2.getPath()));
        }
    }
}

