/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.preprocessor;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.preprocessor.OCFileUtil;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.preprocessor.OCRootUtil;
import com.jetbrains.cidr.lang.psi.OCConfigurationOwner;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTableCacheListener;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculator;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCResolveConfigurations;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceModificationTrackers;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class OCImportGraph {
    private static final boolean USE_STRICT = Registry.is((String)"cidr.indexer.strictImportGraph", (boolean)false);
    private static final NotNullLazyKey<Map<VirtualFile, Set<VirtualFile>>, OCResolveConfiguration> ROOT_TO_ALL_HEADERS_CACHE = NotNullLazyKey.create((String)"ROOT_TO_ALL_HEADERS_CACHE", dom -> new ConcurrentHashMap());
    private final Project myProject;
    private final SimpleModificationTracker myModificationTracker = new SimpleModificationTracker();
    private final CachedValue<MultiMap<VirtualFile, VirtualFile>> myHeaderToAllRootsCache;
    private final AtomicInteger isEnsuringFilesProcessed = new AtomicInteger();
    private final Object myLock = new Object();
    private final MultiMap<VirtualFile, VirtualFile> myHeaderToIncluders = MultiMap.createSet();
    private final MultiMap<VirtualFile, VirtualFile> myAddOnlyHeaderToIncluders = MultiMap.createSet();

    @NotNull
    public static OCImportGraph getInstance(@NotNull Project project) {
        return (OCImportGraph)project.getService(OCImportGraph.class);
    }

    public OCImportGraph(@NotNull Project project) {
        this.myProject = project;
        this.myHeaderToAllRootsCache = CachedValuesManager.getManager((Project)project).createCachedValue(() -> {
            OCWorkspaceModificationTrackers trackers = OCWorkspace.getInstance((Project)this.myProject).getModificationTrackers();
            return new CachedValueProvider.Result((Object)MultiMap.createConcurrent(), new Object[]{trackers.getResolveConfigurationsTracker(), trackers.getSourceFilesTracker(), trackers.getCompilerSettingsTracker()});
        }, false);
        project.getMessageBus().connect().subscribe(FileSymbolTableCacheListener.TOPIC, (Object)new FileSymbolTableCacheListener.Adaptor(){

            @Override
            public void onSymbolsUpToDate() {
                OCImportGraph.this.onUpToDate();
            }
        });
    }

    @NotNull
    public ModificationTracker getModificationTracker() {
        return this.myModificationTracker;
    }

    public void invalidateHeaderRootsCache() {
        ((MultiMap)this.myHeaderToAllRootsCache.getValue()).clear();
    }

    @NotNull
    public Collection<VirtualFile> getAllHeaderRoots(@NotNull VirtualFile header) {
        MultiMap value = (MultiMap)this.myHeaderToAllRootsCache.getValue();
        if (!value.containsKey((Object)header)) {
            Collection<VirtualFile> roots2 = this.findAllRootsThatInclude(header, true);
            assert (!roots2.isEmpty());
            value.put((Object)header, roots2);
        }
        return value.get((Object)header);
    }

    public boolean isFileIncluded(@NotNull VirtualFile file) {
        return this.myHeaderToIncluders.containsKey((Object)file);
    }

    public void buildSymbolAndRootHeaderCache(@NotNull OCResolveConfiguration configuration, @NotNull VirtualFile rootFile, boolean isSurrogate, @Nullable ProgressIndicator indicator) {
        if (indicator != null) {
            indicator.checkCanceled();
        }
        if (!rootFile.isValid()) {
            return;
        }
        if (!OCRootUtil.isNeedToFindRoot(rootFile, this.myProject)) {
            OCImportGraph.invalidateRootHeadersCache(configuration, rootFile);
            this.getAllRootHeaders(configuration, rootFile, indicator, isSurrogate);
        } else {
            PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(rootFile);
            if (psiFile instanceof OCConfigurationOwner) {
                OCLanguageKind kind = OCLanguageKindCalculator.calculateLanguageKind(configuration, rootFile, this.myProject, false);
                OCImportGraph.traverseWithIncludes(configuration, kind, rootFile, (OCConfigurationOwner)psiFile, isSurrogate, true);
            }
        }
    }

    @NotNull
    private static OCInclusionContext traverseWithIncludes(@NotNull OCResolveConfiguration configuration, @NotNull OCLanguageKind attemptedKind, @NotNull VirtualFile rootFile, @NotNull OCConfigurationOwner rootCO, boolean isSurrogate, boolean allowLanguageKindFallback) {
        try {
            OCInclusionContext context;
            VirtualFile file = OCFileUtil.getVirtualFile(rootCO);
            if (file.isValid()) {
                context = OCInclusionContext.sourceParsingContext(configuration, attemptedKind, rootCO, isSurrogate);
                context.setInheritProcessedFiles(true);
                context.setAbortOnLanguageKindMismatch(true);
                FileSymbolTable.forFile(rootCO, context);
                context.setAbortOnLanguageKindMismatch(false);
                if (context.isProcessed(file)) {
                    return context;
                }
            }
            context = OCInclusionContext.sourceParsingContext(configuration, attemptedKind, rootCO, isSurrogate);
            context.setAbortOnLanguageKindMismatch(true);
            context.preprocessInclude(rootCO, true);
            context.setAbortOnLanguageKindMismatch(false);
            return context;
        }
        catch (OCInclusionContext.LanguageKindMismatchException e) {
            OCLanguageKind requiredLanguageKind = OCInclusionContext.handleLanguageKindMismatch(rootFile, e, allowLanguageKindFallback);
            return OCImportGraph.traverseWithIncludes(configuration, requiredLanguageKind, rootFile, rootCO, isSurrogate, false);
        }
    }

    @NotNull
    private static Map<VirtualFile, Set<VirtualFile>> getRootToAllHeadersCache(@NotNull OCResolveConfiguration configuration) {
        return (Map)ROOT_TO_ALL_HEADERS_CACHE.getValue((UserDataHolder)configuration);
    }

    public static void invalidateRootHeadersCache(@NotNull OCResolveConfiguration configuration, @NotNull VirtualFile file) {
        OCImportGraph.getRootToAllHeadersCache(configuration).remove(file);
    }

    public static void invalidateRootHeadersCache(@NotNull OCResolveConfiguration configuration) {
        OCImportGraph.getRootToAllHeadersCache(configuration).clear();
    }

    @NotNull
    public Set<VirtualFile> getAllRootHeaders(@NotNull OCResolveConfiguration configuration, @NotNull VirtualFile root, @Nullable ProgressIndicator indicator, boolean isSurrogate) {
        assert (!OCRootUtil.isNeedToFindRoot(root, this.myProject)) : "Not a root file";
        Map<VirtualFile, Set<VirtualFile>> value = OCImportGraph.getRootToAllHeadersCache(configuration);
        Set<Object> result = value.get(root);
        if (result == null) {
            PsiFile rootPsi;
            PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
            PsiFile psiFile = rootPsi = root.isValid() ? psiManager.findFile(root) : null;
            if (rootPsi instanceof OCConfigurationOwner) {
                if (OCInclusionContext.isPrecompiledHeader(root, configuration)) {
                    result = OCImportGraph.getAllPCHRootHeaders(psiManager, configuration, root, indicator);
                } else {
                    OCConfigurationOwner rootCO = (OCConfigurationOwner)rootPsi;
                    OCLanguageKind kind = rootCO.getRootKind(configuration);
                    OCInclusionContext context = OCImportGraph.traverseWithIncludes(configuration, kind, root, rootCO, isSurrogate, true);
                    result = context.getProcessedFiles();
                }
            } else {
                result = Collections.emptySet();
            }
            value.put(root, result);
        }
        return result;
    }

    private static Set<VirtualFile> getAllPCHRootHeaders(@NotNull PsiManager psiManager, @NotNull OCResolveConfiguration configuration, @NotNull VirtualFile pch, @Nullable ProgressIndicator indicator) {
        HashSet<Pair> sources = new HashSet<Pair>();
        for (VirtualFile vRoot : configuration.getSources()) {
            OCLanguageKind kind;
            PsiFile rootPsi;
            if (!OCFileTypeHelpers.isSourceFile((String)vRoot.getName()) || pch.equals(vRoot)) continue;
            if (indicator != null) {
                indicator.checkCanceled();
            }
            if (!((rootPsi = vRoot.isValid() ? psiManager.findFile(vRoot) : null) instanceof OCConfigurationOwner) || !(kind = ((OCConfigurationOwner)rootPsi).getRootKind(configuration)).supportsPrecompiledHeaders()) continue;
            sources.add(Pair.create((Object)kind, (Object)rootPsi));
        }
        THashSet result = new THashSet();
        for (Pair src : sources) {
            if (indicator != null) {
                indicator.checkCanceled();
            }
            result.addAll(OCInclusionContext.initialPCHContextWithoutRoot(configuration, (OCLanguageKind)src.first, (PsiFile)src.second).getProcessedFiles());
        }
        result.remove((Object)pch);
        return Collections.unmodifiableSet(result);
    }

    @NotNull
    public Set<OCResolveConfiguration> getAllHeaderConfigurations(@NotNull PsiFile header, @Nullable ProgressIndicator progress) {
        if (!OCLanguageUtils.supportsResolve(header)) {
            return Collections.emptySet();
        }
        VirtualFile file = OCFileUtil.getVirtualFile(header);
        if (!OCInclusionContextUtil.isLongLived(file)) {
            return Collections.emptySet();
        }
        HashSet<OCResolveConfiguration> ret = new HashSet<OCResolveConfiguration>();
        for (VirtualFile root : this.getAllHeaderRoots(file)) {
            this.fillHeaderConfigurationsForRoot(file, root, ret, progress);
        }
        return Collections.unmodifiableSet(ret);
    }

    public void fillHeaderConfigurationsForRoot(@NotNull VirtualFile header, @NotNull VirtualFile root, @NotNull Set<OCResolveConfiguration> result, @Nullable ProgressIndicator progress) {
        Collection configs;
        if (progress != null) {
            progress.checkCanceled();
        }
        Collection collection = configs = OCInclusionContextUtil.isLongLived(root) ? OCResolveConfigurations.getAllBuildConfigurationsOfTargetsOfFile((VirtualFile)root, (Project)this.myProject) : OCWorkspace.getInstance((Project)this.myProject).getConfigurations();
        if (!OCRootUtil.isNeedToFindRoot(root, this.myProject)) {
            for (OCResolveConfiguration config : configs) {
                if (progress != null) {
                    progress.checkCanceled();
                }
                if (!this.getAllRootHeaders(config, root, progress, false).contains(header)) continue;
                result.add(config);
            }
        } else {
            result.addAll(configs);
        }
    }

    public boolean processIncludingFiles(@NotNull VirtualFile headerFile, boolean strict, boolean rootsOnly, @NotNull Processor<? super VirtualFile> processor) {
        ArrayList<VirtualFile> importers = new ArrayList<VirtualFile>();
        HashSet<VirtualFile> processed = new HashSet<VirtualFile>();
        importers.add(headerFile);
        while (!importers.isEmpty()) {
            ProgressManager.checkCanceled();
            ArrayList<VirtualFile> upperImporters = new ArrayList<VirtualFile>();
            for (VirtualFile headerHolder : importers) {
                ProgressManager.checkCanceled();
                if (headerHolder == null || !processed.add(headerHolder)) continue;
                Collection<VirtualFile> maybeUpperImporter = this.findImmediateIncludingFiles(headerHolder, strict);
                for (VirtualFile importHolder : maybeUpperImporter) {
                    ProgressManager.checkCanceled();
                    if (!importHolder.isValid()) continue;
                    PsiFile psiImportHolder = PsiManager.getInstance((Project)this.myProject).findFile(importHolder);
                    if (!(!OCLanguageUtils.supportsResolve(psiImportHolder) || rootsOnly && OCRootUtil.isNeedToFindRoot(psiImportHolder) || processor.process((Object)importHolder))) {
                        return false;
                    }
                    upperImporters.add(importHolder);
                }
            }
            importers = upperImporters;
        }
        return true;
    }

    @NotNull
    public Collection<VirtualFile> findAllRootsThatInclude(@NotNull VirtualFile original, boolean strict) {
        if (!OCRootUtil.isNeedToFindRoot(original, this.myProject) || !original.isValid()) {
            return Collections.singletonList(original);
        }
        PsiFile originalFile = PsiManager.getInstance((Project)this.myProject).findFile(original);
        if (!OCLanguageUtils.supportsResolve(originalFile)) {
            return Collections.singletonList(original);
        }
        THashSet result = new THashSet();
        this.processIncludingFiles(original, strict, true, (Processor<? super VirtualFile>)((Processor)virtualFile -> {
            result.add(virtualFile);
            return true;
        }));
        return result.isEmpty() ? Collections.singletonList(original) : new ArrayList(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onUpToDate() {
        Object object = this.myLock;
        synchronized (object) {
            if (!this.myAddOnlyHeaderToIncluders.isEmpty()) {
                this.myAddOnlyHeaderToIncluders.clear();
                this.myModificationTracker.incModificationCount();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Collection<VirtualFile> findImmediateIncludingFiles(@NotNull VirtualFile header, boolean strict) {
        boolean useStrict;
        Application app = ApplicationManager.getApplication();
        boolean bl = useStrict = USE_STRICT || app.isUnitTestMode();
        if (strict) {
            app.assertReadAccessAllowed();
            boolean sync = app.isUnitTestMode() || useStrict && !app.isDispatchThread();
            this.ensureFilesProcessed(sync);
        }
        Object object = this.myLock;
        synchronized (object) {
            Collection<VirtualFile> ns = null;
            if (!strict || !useStrict) {
                ns = this.getInner(header, true);
            }
            Collection<VirtualFile> sr = this.getInner(header, false);
            if (ns == null || ns.isEmpty()) {
                return sr;
            }
            if (sr.isEmpty()) {
                return ns;
            }
            THashSet fs = new THashSet(ns);
            fs.addAll(sr);
            return fs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @Contract(value="_, false -> !null")
    private Collection<VirtualFile> getInner(@NotNull VirtualFile header, boolean fromAddOnlyCache) {
        Object object = this.myLock;
        synchronized (object) {
            MultiMap<VirtualFile, VirtualFile> h2is;
            MultiMap<VirtualFile, VirtualFile> multiMap = h2is = fromAddOnlyCache ? this.myAddOnlyHeaderToIncluders : this.myHeaderToIncluders;
            if (fromAddOnlyCache && !h2is.containsKey((Object)header)) {
                return null;
            }
            Collection files = h2is.get((Object)header);
            boolean allValid = true;
            for (VirtualFile file : files) {
                if (file.isValid()) continue;
                allValid = false;
                break;
            }
            if (!allValid) {
                for (VirtualFile file : files.toArray(VirtualFile.EMPTY_ARRAY)) {
                    if (file.isValid()) continue;
                    h2is.remove((Object)header, (Object)file);
                }
                files = h2is.get((Object)header);
                if (!fromAddOnlyCache) {
                    this.invalidateHeaderRootsCache();
                }
            }
            return ContainerUtil.immutableList((Object[])files.toArray(VirtualFile.EMPTY_ARRAY));
        }
    }

    private void ensureFilesProcessed(boolean sync) {
        if (FileSymbolTablesCache.getInstance(this.myProject).isUpToDate(true)) {
            this.onUpToDate();
            return;
        }
        if (sync) {
            this.isEnsuringFilesProcessed.incrementAndGet();
            try {
                this.ensurePendingFilesProcessed();
                return;
            }
            finally {
                this.isEnsuringFilesProcessed.decrementAndGet();
            }
        }
        if (this.isEnsuringFilesProcessed.get() > 0) {
            return;
        }
        ReadAction.nonBlocking(() -> {
            if (this.isEnsuringFilesProcessed.incrementAndGet() > 1) {
                this.isEnsuringFilesProcessed.decrementAndGet();
                return;
            }
            try {
                this.ensurePendingFilesProcessed();
            }
            finally {
                this.isEnsuringFilesProcessed.decrementAndGet();
            }
        }).coalesceBy(new Object[]{this}).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    private void ensurePendingFilesProcessed() {
        if (this.myProject.isDisposed() || !FileSymbolTablesCache.areSymbolsLoaded(this.myProject)) {
            return;
        }
        FileSymbolTablesCache cache = FileSymbolTablesCache.getInstance(this.myProject);
        cache.ensurePendingFilesProcessed(true);
        this.onUpToDate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHeaderIncluder(@NotNull VirtualFile header, @NotNull VirtualFile includer) {
        Object object = this.myLock;
        synchronized (object) {
            this.myHeaderToIncluders.putValue((Object)header, (Object)includer);
            if (this.myAddOnlyHeaderToIncluders.containsKey((Object)header)) {
                this.myAddOnlyHeaderToIncluders.putValue((Object)header, (Object)includer);
            }
            this.invalidateHeaderRootsCache();
            this.myModificationTracker.incModificationCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHeaderIncluder(@NotNull VirtualFile header, @NotNull VirtualFile includer) {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myHeaderToIncluders.remove((Object)header, (Object)includer)) {
                if (!this.myAddOnlyHeaderToIncluders.containsKey((Object)header)) {
                    this.myAddOnlyHeaderToIncluders.putValues((Object)header, this.myHeaderToIncluders.get((Object)header));
                    this.myAddOnlyHeaderToIncluders.putValue((Object)header, (Object)includer);
                }
                this.invalidateHeaderRootsCache();
                this.myModificationTracker.incModificationCount();
            }
        }
    }
}

