/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.preprocessor;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.preprocessor.MapUtil;
import com.jetbrains.cidr.lang.preprocessor.OCContextChanges;
import com.jetbrains.cidr.lang.preprocessor.OCFileUtil;
import com.jetbrains.cidr.lang.preprocessor.OCImmutableInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextImpl;
import com.jetbrains.cidr.lang.preprocessor.OCResolveRootAndConfiguration;
import com.jetbrains.cidr.lang.preprocessor.OCResolveRootAndConfigurationCache;
import com.jetbrains.cidr.lang.preprocessor.OCRootUtil;
import com.jetbrains.cidr.lang.psi.OCPsiFile;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCResolveConfigurations;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
public final class OCHeaderContextCache {
    private final Map<VirtualFile, OCImmutableInclusionContext> myCache = ContainerUtil.createConcurrentSoftValueMap();

    @NotNull
    public static OCInclusionContext calculateHeaderContext(@NotNull PsiFile file, @Nullable OCLanguageKind languageKind) {
        PsiFile original = OCFileUtil.getOriginalFile(file);
        if (original == null) {
            return OCInclusionContextImpl.emptyWithBuiltinMacros(languageKind, file);
        }
        return OCHeaderContextCache.innerCalculateHeaderContext(original, languageKind);
    }

    @NotNull
    public static OCImmutableInclusionContext headerContext(@NotNull PsiFile file) {
        PsiFile original = OCFileUtil.getOriginalFile(file);
        if (original == null) {
            return OCInclusionContextImpl.emptyWithBuiltinMacros(null, file);
        }
        Project project = original.getProject();
        VirtualFile virtualFile = OCFileUtil.getVirtualFile(original);
        Map<VirtualFile, OCImmutableInclusionContext> cache = OCHeaderContextCache.getHeaderContextCache(project);
        OCImmutableInclusionContext cached = cache.get(virtualFile);
        if (cached != null) {
            return cached;
        }
        OCInclusionContext result = OCHeaderContextCache.innerCalculateHeaderContext(original, null);
        cache.put(virtualFile, result);
        return result;
    }

    public static void invalidateHeaderContextsExcept(@Nullable VirtualFile virtualFile, @NotNull Project project) {
        MapUtil.removeExcept(OCHeaderContextCache.getHeaderContextCache(project), virtualFile);
        OCContextChanges.invalidateContextChangeCacheExcept(virtualFile, project);
    }

    @NotNull
    private static Map<VirtualFile, OCImmutableInclusionContext> getHeaderContextCache(@NotNull Project project) {
        return ((OCHeaderContextCache)project.getService(OCHeaderContextCache.class)).myCache;
    }

    @NotNull
    private static OCInclusionContext innerCalculateHeaderContext(@NotNull PsiFile original, @Nullable OCLanguageKind kind) {
        Project project = original.getProject();
        VirtualFile virtualFile = OCFileUtil.getVirtualFile(original);
        if (OCRootUtil.isNeedToFindRoot(virtualFile, project)) {
            PsiFile importHolder;
            OCResolveRootAndConfiguration rootAndConfiguration = OCResolveRootAndConfigurationCache.getInstance(project).getResolveRootAndActiveConfiguration(virtualFile);
            VirtualFile rootFile = rootAndConfiguration.getRootFile();
            PsiFile psiFile = importHolder = rootFile != null && rootFile.isValid() ? OCLanguageUtils.asFileWithOCResolve(project, rootFile) : null;
            if (importHolder != null && !rootFile.equals(virtualFile)) {
                OCResolveConfiguration config = rootAndConfiguration.getConfiguration();
                if (config != null) {
                    OCImmutableInclusionContext precompiledContext = OCInclusionContext.tryFindInCachedPCHPrecompiledContexts(config, virtualFile, rootFile);
                    if (precompiledContext == null) {
                        OCLanguageKind importHolderKind = OCPsiFile.getKind(importHolder);
                        assert (importHolderKind != null) : "file without OC resolve";
                        precompiledContext = OCInclusionContext.initialPCHContextWithoutRoot(config, importHolderKind, importHolder);
                    } else {
                        precompiledContext = precompiledContext.getParent();
                        assert (precompiledContext != null && precompiledContext.getParent() == null);
                    }
                    OCInclusionContext result = precompiledContext.derive(importHolder);
                    result.preprocessContextOf(importHolder, virtualFile);
                    return result;
                }
            } else if (kind == null) {
                kind = rootAndConfiguration.getKind();
            }
        }
        return OCHeaderContextCache.sourceFileContext(original, kind);
    }

    @NotNull
    private static OCInclusionContext sourceFileContext(@NotNull PsiFile file, @Nullable OCLanguageKind kindOrNullForDefault) {
        OCResolveConfiguration config;
        if (kindOrNullForDefault == null) {
            OCLanguageKind kind = OCPsiFile.getKind(file);
            assert (kind != null) : "file without OC resolve";
            kindOrNullForDefault = kind;
        }
        if ((config = OCResolveConfigurations.getPreselectedConfiguration((VirtualFile)OCFileUtil.getVirtualFile(file), (Project)file.getProject())) != null) {
            return OCInclusionContext.sourceParsingContext(config, kindOrNullForDefault, file);
        }
        return OCInclusionContextImpl.emptyWithBuiltinMacros(kindOrNullForDefault, file);
    }
}

