/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.preprocessor;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.preprocessor.MapUtil;
import com.jetbrains.cidr.lang.preprocessor.OCContextChangeSet;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCContextChanges {
    private static final NotNullLazyKey<Map<VirtualFile, OCContextChangeSet>, Project> CONTEXT_CHANGES_KEY = NotNullLazyKey.create((String)"CONTEXT_CHANGES_KEY", p -> ContainerUtil.createConcurrentSoftValueMap());

    public static void invalidateContextChangeCacheExcept(@Nullable VirtualFile virtualFile, @NotNull Project project) {
        MapUtil.removeExcept(OCContextChanges.getCache(project), virtualFile);
    }

    public static void storeCachedContextChangeSet(@NotNull Project project, @NotNull VirtualFile virtualFile, @NotNull OCContextChangeSet changeSet) {
        OCContextChanges.getCache(project).put(virtualFile, changeSet);
    }

    @Contract(value="_, null -> null; _, !null -> !null")
    public static OCContextChangeSet cachedContextChangeSet(@NotNull Project project, @Nullable VirtualFile virtualFile) {
        if (virtualFile == null) {
            return null;
        }
        return OCContextChanges.getCache(project).get(virtualFile);
    }

    @NotNull
    private static Map<VirtualFile, OCContextChangeSet> getCache(@NotNull Project project) {
        return (Map)CONTEXT_CHANGES_KEY.getValue((UserDataHolder)project);
    }
}

